/*
 * $Id: CloseProjectNotification.java 170738 2015-12-16 17:39:22Z fpina $
 */
package csbase.logic;

import tecgraf.javautils.core.lng.LNG;

/**
 * Notificao de fechamento de projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CloseProjectNotification extends Notification {

  /**
   * Nome do projeto.
   */
  private String projectName;

  /**
   * Construtor.
   * 
   * @param sender remetente
   * @param projectName nome do projeto.
   */
  public CloseProjectNotification(String sender, String projectName) {
    super(sender);
    this.projectName = projectName;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return (String.format(LNG.get("csbase.logic.ProjectClosingNote"),
    			projectName));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isVolatile() {
    return false;
  }

  /**
   * Consulta nome do projeto.
   * 
   * @return nome
   */
  public String getProjectName() {
    return this.projectName;
  }
}
