/**
 * $Id: ProjectDeletedEvent.java 146059 2013-10-22 18:32:34Z fpina $
 */

package csbase.logic;

/**
 * Representa o evento de remoo de um projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectDeletedEvent extends ProjectEvent {
  /**
   * Retorna o identificador do projeto que foi removido.
   * 
   * @return O identificador do projeto que foi removido.
   */
  public String getProjectId() {
    return (String) projectId;
  }

  /**
   * Construtor.
   * 
   * @param projectId o identificador do projeto que foi removido.
   */
  public ProjectDeletedEvent(Object projectId) {
    event = PROJECT_DELETED;
    this.projectId = projectId;
  }
}
