package csbase.logic.algorithms;

import java.io.Serializable;

public class MonitoredFile implements Serializable {
  private static final String FORMAT_START = ":";
  private static final String FORMAT_SEPARATOR = ",";
  private static final String TEXT_TYPE = "TEXT";

  private String fileName;
  private String[] formats = new String[0];

  public String getFileName() {
    return fileName;
  }

  public String[] getFormats() {
    return formats;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public void setFormats(String[] formats) {
    this.formats = formats;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append(fileName).append(FORMAT_START);
    String sep = "";
    for (String type : formats) {
      sb.append(sep).append(type);
      sep = FORMAT_SEPARATOR;
    }

    return sb.toString();
  }

  public static MonitoredFile parseMonitoredFile(String s) {
    String[] split = s.split(FORMAT_START);
    String fileName = split[0];
    String[] formats;
    if (split.length > 1) {
      formats = split[1].split(FORMAT_SEPARATOR);
    } else {
      formats = new String[]{TEXT_TYPE};
    }

    MonitoredFile monitoredFile = new MonitoredFile();
    monitoredFile.setFileName(fileName);
    monitoredFile.setFormats(formats);

    return monitoredFile;
  }
}
