package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.StringToEnumConverter;

/**
 * Converte strings para valores da enumerao {@link URLProtocol}.
 * 
 * @author Tecgraf
 */
public class URLProtocolConverter implements StringToEnumConverter<URLProtocol> {

  /**
   * {@inheritDoc}
   */
  @Override
  public URLProtocol valueOf(String value) throws ParseException {
    if (value != null) {
      String upperCaseString = value.toUpperCase().trim();
      for (URLProtocol location : URLProtocol.values()) {
        String[] possibleMatches = getPossibleMatches(location);
        for (String possibleMatch : possibleMatches) {
          if (possibleMatch.toUpperCase().equals(upperCaseString)) {
            return location;
          }
        }
      }
    }

    String f = "No foi possvel converter '%s' em um item da enumerao %s.";
    String msg = String.format(f, value, URLProtocol.class.getSimpleName());
    throw new ParseException(msg);
  }

  /**
   * Retorna as strings que correspondem a cada um dos possveis valores da
   * enumerao {@link URLProtocol}.
   * 
   * @param value valor da enumerao.
   * @return array com todas as strings que representam o valor.
   */
  private String[] getPossibleMatches(URLProtocol value) {
    switch (value) {
      case PROJECT:
        return new String[] { "project", "projeto" };
      case LOCAL:
        return new String[] { "local", "client", "cliente" };
      case SGA:
        return new String[] { "sga" };
      default:
        return new String[] { value.getType() };
    }
  }
}
