package csbase.logic.algorithms.xml.category;

import tecgraf.javautils.xml.XMLWriter;
import tecgraf.javautils.xml.exception.XMLException;
import csbase.logic.algorithms.CategorySet;

/**
 * Esta classe implementa o escritor XML de arquivos de categorias de algoritmos
 * existentes no sistema.
 * 
 */
public class XmlCategoriesWriter extends XMLWriter {
  /**
   * Constri um escritor XML de arquivos de categorias de algoritmos.
   * 
   * @param categorySet conjunto de categorias de algoritmos
   * @throws XMLException exceo de XML
   */
  public XmlCategoriesWriter(CategorySet categorySet) throws XMLException {
    super(categorySet, new XmlCategoriesFactory(categorySet));
  }
}
