/**
 * $Id: DeploymentInfo.java 170738 2015-12-16 17:39:22Z fpina $
 */
package csbase.logic.diagnosticservice;

import java.io.Serializable;

import tecgraf.javautils.core.lng.LNG;

/**
 * Informaes sobre o ambiente de instalao do servidor.
 * 
 * @author Tecgraf
 */
public class DeploymentInfo implements Serializable {
  /**
   * Nome do sistema operacional (Linux, Windows etc.).
   */
  public static final String OS_NAME = System.getProperty("os.name");
  /**
   * Verso do sistema operacional (no Linux, verso do kernel).
   */
  public static final String OS_VERSION = System.getProperty("os.version");
  /**
   * Arquitetura do sistema operacional.
   */
  public static final String OS_ARCH = System.getProperty("os.arch");
  /**
   * Identificador (nome) da JVM.
   */
  public static final String JAVA_NAME = System.getProperty("java.vm.name");
  /**
   * Verso da JVM.
   */
  public static final String JAVA_VERSION = System.getProperty("java.version");
  /**
   * Implementao da JVM (Oracle, IBM etc.).
   */
  public static final String JAVA_VENDOR = System.getProperty("java.vendor");

  /**
   * Informaes da classe sob a forma de uma nica string.
   */
  private static String fullInfo = null;

  /**
   * Instncia da classe.
   */
  private static final DeploymentInfo instance = new DeploymentInfo();

  /**
   * Construtor privado.
   */
  private DeploymentInfo() {
    fullInfo = LNG.get("csbase.logic.diagnosticservice.OSLabel");
    fullInfo += String.format("\n    %s (%s)", OS_NAME, OS_ARCH);
    fullInfo += "\n    " + OS_VERSION;
    fullInfo += "\n\nJava:";
    fullInfo += "\n    " + JAVA_NAME;
    fullInfo += "\n    " + JAVA_VERSION;
    fullInfo += "\n    " + JAVA_VENDOR;
  }

  /**
   * Obtm a instncia nica da classe.
   * 
   * @return instncia nica da classe
   */
  public static DeploymentInfo getInstance() {
    return instance;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return fullInfo;
  }
}
