/*
 * Decompiled with CFR 0.152.
 */
package csbase.console.remote;

import csbase.exception.CSBaseException;
import csbase.logic.ServerURI;
import csbase.logic.Session;
import csbase.logic.SingleServerManager;
import csbase.logic.User;
import csbase.logic.Version;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.UserPasswordAuthenticator;
import java.rmi.RemoteException;
import java.util.Locale;

public class ClientRemoteMonitor
extends SingleServerManager {
    private static final int WINDOWS_SIZE = 10;
    private UserPasswordAuthenticator authenticator;

    public ClientRemoteMonitor(String server, int port, String login, String password, boolean verbose) {
        super(ServerURI.create((String)server, (int)port), ClientRemoteLocator.class, verbose, 10);
        this.authenticator = new UserPasswordAuthenticator(login, password, Locale.getDefault());
    }

    protected String lang(String key) {
        return key;
    }

    protected Session login() throws CSBaseException, RemoteException {
        Session session = this.authenticator.authenticate(this.getServer());
        if (session == null) {
            return null;
        }
        if (!this.isSameVersion()) {
            throw new CSBaseException("Vers\u00e3o do console (" + Version.getInstance().getName() + ") diferente da vers\u00e3o do servidor (" + this.getServer().getVersionName() + ").");
        }
        User user = session.getUser();
        User.registerLogin((Object)session.getKey(), (User)user);
        return session;
    }
}

