/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.console.AbstractConsoleApp;
import csbase.console.CreateAlgorithmParams;
import csbase.console.ExitCode;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.remote.ClientRemoteLocator;
import java.util.Hashtable;

class CreateAlgorithm
extends AbstractConsoleApp {
    CreateAlgorithm(String[] args) {
        super(args);
    }

    @Override
    protected CreateAlgorithmParams createParams() {
        return new CreateAlgorithmParams();
    }

    @Override
    protected void postLoginInit() {
    }

    @Override
    protected boolean preLogout() {
        return true;
    }

    @Override
    public String getLogin() {
        CreateAlgorithmParams params = (CreateAlgorithmParams)this.getParams();
        String login = (String)(params.userLogin == null ? User.getAdminId() : params.userLogin);
        return login;
    }

    @Override
    public ExitCode execute() throws Exception {
        CreateAlgorithmParams params = (CreateAlgorithmParams)this.getParams();
        Hashtable<String, String> table = new Hashtable<String, String>();
        String errorMsg = CreateAlgorithm.extractAttributeTable(params.attributes, table);
        if (errorMsg != null) {
            System.out.println("Formato do par\u00e2metro \"-a (atributos)\" n\u00e3o \u00e9 v\u00e1lido.");
            System.out.println(errorMsg);
            return ExitCode.FAILURE;
        }
        return CreateAlgorithm.startAlgorithmCreation(params.algorithmId, params.algorithmName, table);
    }

    private static String extractAttributeTable(String attributes, Hashtable<String, String> table) {
        String[] attArray;
        if (attributes == null || attributes.trim().isEmpty()) {
            return null;
        }
        for (String attribute : attArray = attributes.split(",")) {
            String[] entry = attribute.split("=");
            if (entry.length != 2) {
                return "O atributo " + entry + " n\u00e3o tem o formato <nome> = <valor>";
            }
            String key = entry[0].trim();
            String value = entry[1].trim();
            if (key.equalsIgnoreCase("id") || key.equalsIgnoreCase("nome")) {
                return "Nenhum atributo pode ter como id as tags reservadas \"id\" ou \"nome\".";
            }
            table.put(key, value);
        }
        return null;
    }

    private static ExitCode startAlgorithmCreation(String algorithmId, String algorithmName, Hashtable<String, String> attributeTable) throws Exception {
        AlgorithmInfo info = ClientRemoteLocator.algorithmService.getInfo((Object)algorithmId);
        if (info != null) {
            System.err.println("Id de algoritmo j\u00e1 existente.");
            return ExitCode.FAILURE;
        }
        AlgorithmInfo algorithm = ClientRemoteLocator.algorithmService.createAlgorithm(algorithmName, algorithmId, attributeTable);
        if (algorithm == null) {
            System.out.println("Falha na cria\u00e7\u00e3o do algoritmo: " + algorithmId);
            return ExitCode.FAILURE;
        }
        System.out.println("Algoritmo " + algorithmId + " criado com sucesso.");
        return ExitCode.SUCCESS;
    }
}

