/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.console.AbstractConsoleApp;
import csbase.console.BasicParams;
import csbase.console.ExitCode;
import csbase.console.ListAlgoVersionsParams;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;
import java.util.Vector;

class ListAlgoVersions
extends AbstractConsoleApp {
    ListAlgoVersions(String[] args) {
        super(args);
    }

    @Override
    protected BasicParams createParams() {
        return new ListAlgoVersionsParams();
    }

    @Override
    protected void postLoginInit() {
    }

    @Override
    protected boolean preLogout() {
        return true;
    }

    @Override
    public String getLogin() {
        ListAlgoVersionsParams params = (ListAlgoVersionsParams)this.getParams();
        String login = (String)(params.userLogin == null ? User.getAdminId() : params.userLogin);
        return login;
    }

    @Override
    public ExitCode execute() throws Exception {
        ListAlgoVersionsParams params = (ListAlgoVersionsParams)this.getParams();
        return ListAlgoVersions.startAlgorithmVersionList(params.algorithmId);
    }

    private static ExitCode startAlgorithmVersionList(String algorithmId) throws Exception {
        AlgorithmInfo info = ClientRemoteLocator.algorithmService.getInfo((Object)algorithmId);
        if (info == null) {
            System.err.println("Id de algoritmo inv\u00e1lido.");
            return ExitCode.FAILURE;
        }
        Vector versions = info.getVersions();
        if (versions == null || versions.size() == 0) {
            System.out.println("Nenhuma vers\u00e3o do algoritmo foi encontrada.");
            return ExitCode.SUCCESS;
        }
        System.out.println("Vers\u00f5es encontradas:");
        for (AlgorithmVersionInfo versionInfo : versions) {
            System.out.println("Vers\u00e3o: " + versionInfo.getId());
        }
        return ExitCode.SUCCESS;
    }
}

