/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.console.BasicParams;
import csbase.console.ExitCode;
import csbase.console.remote.ClientRemoteMonitor;
import csbase.exception.CSBaseException;
import csbase.logic.User;
import csbase.logic.diagnosticservice.DeploymentInfo;
import csbase.logic.diagnosticservice.ServerBasicInfo;
import csbase.remote.ClientRemoteLocator;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Map;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import tecgraf.javautils.core.lng.FormatUtils;

abstract class AbstractConsoleApp {
    protected static final String IDENT = "    ";
    private String serverURI;
    protected ClientRemoteMonitor clientMonitor;
    private int port;
    private String password;
    private BasicParams params;
    private PrintStream out;
    private boolean outputToFile;
    private String currentDir;

    protected AbstractConsoleApp(String _serverURI, int _port, String _password) {
        this.out = System.out;
        this.outputToFile = false;
        this.setPassword(_password);
        this.setServerURI(_serverURI);
        this.setPort(_port);
        this.createClientMonitor();
    }

    protected AbstractConsoleApp(String[] args) {
        CmdLineParser parser;
        block3: {
            this.out = System.out;
            this.outputToFile = false;
            this.params = this.createParams();
            parser = new CmdLineParser((Object)this.params);
            try {
                parser.parseArgument(args);
            }
            catch (CmdLineException e) {
                if (this.params.showHelp) break block3;
                System.err.println(e.getMessage());
                AbstractConsoleApp.showUsage(parser, System.err);
                System.exit(1);
            }
        }
        if (this.params.showHelp) {
            AbstractConsoleApp.showUsage(parser, System.out);
            System.exit(0);
        }
        this.processBasicParams();
        this.processExtraParams();
        this.createClientMonitor();
    }

    private static void showUsage(CmdLineParser parser, PrintStream stream) {
        parser.printUsage((OutputStream)stream);
        stream.println();
        stream.println("OBSERVA\u00c7\u00d5ES:\n");
        stream.println("- projetos de outros usu\u00e1rios podem ser referenciados atrav\u00e9s");
        stream.println("  da sintaxe user:prj/path");
    }

    protected void processBasicParams() {
        this.setServerURI(this.params.serverURI);
        this.setPort(this.params.port);
        this.currentDir = System.getProperty("currDir");
        if (this.currentDir == null) {
            this.currentDir = System.getProperty("user.dir");
            this.printInfo("usando " + this.currentDir + " como diret\u00f3rio corrente", new Object[0]);
        }
        this.setPassword(System.getProperty("password"));
        if (this.getPassword() == null) {
            this.setPassword(this.readPassword());
        }
        if (this.params.outputFile != null) {
            File file = new File(this.params.outputFile);
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                this.out = new PrintStream(file);
                this.outputToFile = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    protected String readPassword() {
        Console cons = AbstractConsoleApp.getConsole();
        return new String(cons.readPassword("senha [%s]: ", this.getLogin()));
    }

    protected String ask(String prompt, Object ... params) {
        Console cons = AbstractConsoleApp.getConsole();
        String answer = new String(cons.readLine(prompt + ' ', params)).trim();
        return answer;
    }

    protected boolean confirm(String prompt, Object ... params) {
        String option = this.ask(prompt + " [s/n]", params);
        return option.equalsIgnoreCase("s");
    }

    protected static Console getConsole() {
        Console cons = System.console();
        if (cons == null) {
            throw new AssertionError((Object)"console n\u00e3o \u00e9 interativo, n\u00e3o foi poss\u00edvel obter a senha");
        }
        return cons;
    }

    protected abstract BasicParams createParams();

    public abstract ExitCode execute() throws Exception;

    protected void processExtraParams() {
    }

    protected void createClientMonitor() {
        this.clientMonitor = new ClientRemoteMonitor(this.getServerURI(), this.getPort(), this.getLogin(), this.getPassword(), false);
    }

    protected boolean login() throws RemoteException {
        try {
            if (!this.clientMonitor.lookup()) {
                this.printError("Autentica\u00e7\u00e3o de " + this.getLogin() + " falhou", new Object[0]);
                return false;
            }
            this.postLoginInit();
            return true;
        }
        catch (CSBaseException e) {
            this.printError(e.getMessage(), new Object[0]);
            return false;
        }
    }

    protected void postLoginInit() throws RemoteException {
    }

    protected void logout() {
        if (this.preLogout()) {
            this.clientMonitor.shutdown();
        }
        this.out.close();
    }

    protected boolean preLogout() {
        return true;
    }

    public String toString() {
        return this.getServerURI() + '\n' + this.getLogin();
    }

    protected final boolean isAdmin(boolean verbose) {
        if (!User.isAdmin((Object)this.getLogin())) {
            if (verbose) {
                this.printError("esta opera\u00e7\u00e3o s\u00f3 pode ser executada pelo administrador", new Object[0]);
            }
            return false;
        }
        return true;
    }

    protected BasicParams getParams() {
        return this.params;
    }

    public static Map<String, String> getRuntimeProperties() throws RemoteException {
        return ClientRemoteLocator.serverService.getRuntimeProperties();
    }

    public static String getSystemVersion() throws RemoteException {
        String versionName = ClientRemoteLocator.server.getVersionName();
        return versionName.isEmpty() ? "??.??.??" : versionName;
    }

    public static DeploymentInfo getDeploymentInfo() throws RemoteException {
        return ClientRemoteLocator.diagnosticService.getDeploymentInfo();
    }

    public AbstractConsoleApp setServerURI(String serverURI) {
        this.serverURI = serverURI;
        return this;
    }

    public String getServerURI() {
        return this.serverURI;
    }

    public AbstractConsoleApp setPort(int port) {
        this.port = port;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public abstract String getLogin();

    protected AbstractConsoleApp setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    protected final void printError(String msg, Object ... params) {
        String errorMsg = String.format("ERRO: " + msg, params);
        System.err.println(errorMsg);
        if (this.outputToFile) {
            this.println(errorMsg, new Object[0]);
        }
    }

    protected final void printInfo(String msg, Object ... params) {
        this.println("INFO: " + msg, params);
    }

    protected final void printWarning(String msg, Object ... params) {
        this.println("ALERTA: " + msg, params);
    }

    protected final void println() {
        this.println("", new Object[0]);
    }

    protected final void println(String msg, Object ... params) {
        if (params.length == 0) {
            this.printf("%s\n", msg);
        } else {
            this.printf(msg + '\n', params);
        }
    }

    protected final void printf(String format, Object ... args) {
        this.out.printf(format, args);
    }

    protected void print(String msg) {
        this.out.print(msg);
    }

    protected static String readLine(String format, Object ... args) {
        return AbstractConsoleApp.getConsole().readLine(format, args);
    }

    protected void printStackTrace(Exception e) {
        e.printStackTrace(System.err);
        if (this.outputToFile) {
            e.printStackTrace(this.out);
        }
    }

    protected void showBasicInfo() throws RemoteException {
        ServerBasicInfo info = ClientRemoteLocator.diagnosticService.getServerBasicInfo();
        this.println("\nSistema:", new Object[0]);
        this.println("%snome: %s", IDENT, info.systemName);
        this.println("%svers\u00e3o: %s", IDENT, info.systemVersion);
        long startupTime = info.startUpTime;
        long delta = System.currentTimeMillis() - startupTime;
        long mins = delta / 60000L;
        long hours = mins / 60L;
        long days = hours / 24L;
        this.println("%siniciado em: %s (%dd %dh %dmin)", IDENT, FormatUtils.format((long)startupTime), days, hours % 24L, mins % 60L);
    }

    static <T> int getMaxStrLen(Collection<T> strs) {
        int maxLen = 0;
        for (T t : strs) {
            maxLen = Math.max(maxLen, t.toString().length());
        }
        return maxLen;
    }

    protected String getCurrentDir() {
        return this.currentDir;
    }
}

