/*
 * Decompiled with CFR 0.152.
 */
package csbase.login;

import br.com.petrobras.cenpes.te.marlim.ValidaAcesso;
import br.com.petrobras.security.ISecurityContext;
import br.com.petrobras.security.configuration.SecurityConfigurer;
import br.com.petrobras.security.configuration.SecuritySettings;
import br.com.petrobras.security.configuration.StandaloneSecurityConfigurer;
import br.com.petrobras.security.exception.ExpiredPasswordException;
import br.com.petrobras.security.exception.InactivatedApplicationEnvironmentException;
import br.com.petrobras.security.exception.InactivatedUserException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidCredentialsException;
import br.com.petrobras.security.exception.InvalidOperationException;
import csbase.logic.User;
import csbase.server.plugin.service.loginservice.ILoginService;
import java.util.Properties;
import java.util.logging.Logger;
import tecgraf.javautils.core.properties.PropertiesUtils;
import tecgraf.javautils.core.properties.PropertyException;

public class CALoginProtocol
implements ILoginService {
    private static final String CAVERSION_PROP_NAME = "CAVersion";
    private ISecurityContext securityContext = ISecurityContext.getContext();
    private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private StandaloneSecurityConfigurer configurer;
    private int version;
    private Properties pluginProperties;

    public ILoginService.LoginProtocol getProtocolType() {
        return ILoginService.LoginProtocol.PROTOCOL_CA;
    }

    public void setProperties(Properties pluginProperties) {
        try {
            this.version = PropertiesUtils.getIntValue((Properties)pluginProperties, (String)CAVERSION_PROP_NAME);
            if (this.version == 4) {
                this.checkCAv4Properties();
            }
            this.pluginProperties = pluginProperties;
        }
        catch (PropertyException e) {
            this.logger.severe(String.format("Propriedade '%s' n\u00e3o est\u00e1 configurada corretamente.", CAVERSION_PROP_NAME));
        }
    }

    public User authenticate(User user, String password) {
        if (this.version == 4) {
            return this.authenticateCAv4(user, password);
        }
        if (this.version == 3) {
            return this.authenticateCAv3(user, password);
        }
        return null;
    }

    private User authenticateCAv3(User user, String password) {
        if (ValidaAcesso.Autenticacao((String)user.getLogin(), (String)password)) {
            return user;
        }
        return null;
    }

    private User authenticateCAv4(User user, String password) {
        if (this.configurer == null) {
            this.configurer = new StandaloneSecurityConfigurer();
            SecuritySettings.load((SecurityConfigurer)this.configurer, (Properties)this.pluginProperties, (boolean)false);
        }
        try {
            this.securityContext.getUserAuthenticator().logon(user.getLogin(), password);
            this.securityContext.getUserAuthenticator().logoff();
            return user;
        }
        catch (InvalidArgumentException e) {
            this.logger.warning(String.format("Argumento inv\u00e1lido: %s", e.getMessage()));
        }
        catch (InvalidCredentialsException e) {
            this.logger.warning(String.format("Credenciais inv\u00e1lidas: usu\u00e1rio '%s'", user.getLogin()));
        }
        catch (NullPointerException e) {
            this.logger.warning(String.format("Credenciais incorretas: usu\u00e1rio '%s'.%n%s", user.getLogin(), e.getMessage()));
        }
        catch (InactivatedApplicationEnvironmentException e) {
            this.logger.warning(String.format("Ambiente de aplica\u00e7\u00e3o inativo: %s", e.getMessage()));
        }
        catch (InactivatedUserException e) {
            this.logger.warning(String.format("Usu\u00e1rio '%s' inativo.", user.getLogin()));
        }
        catch (InvalidOperationException e) {
            this.logger.warning(String.format("Opera\u00e7\u00e3o inv\u00e1lida: %s", e.getMessage()));
        }
        catch (ExpiredPasswordException e) {
            this.logger.warning(String.format("Usu\u00e1rio '%s' com senha expirada.", user.getLogin()));
        }
        catch (Exception e) {
            this.logger.warning(String.format("Erro na autentica\u00e7\u00e3o com o servidor CAv4.%n%s", e.getMessage()));
        }
        return null;
    }

    private void checkCAv4Properties() {
        String[] cav4ConfigKeys;
        for (String prop : cav4ConfigKeys = new String[]{"regional_id", "application_catalog_id", "application_password", "environment_id", "endpoint_wsdl"}) {
            try {
                PropertiesUtils.getValue((Properties)this.pluginProperties, (String)prop);
            }
            catch (Exception e) {
                this.logger.warning(String.format("Propriedade '%s' n\u00e3o encontrada.", prop));
            }
        }
    }
}

