package br.com.petrobras.security.consume.soap.connection;

import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.connection.IApplicationEnvironmentConnectionTesterConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationEnvironmentConnectionTesterConsumerSoapImpl implements IApplicationEnvironmentConnectionTesterConsumer {

    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationEnvironmentConnectionTesterConsumerSoapImpl.class);

	@Override
	public ReturnMessage<Boolean> testConnection(String regionalId,
			String environmentId, String applicationCatalogId,
			String applicationPassword) {

        if(LOGGER.isInfoEnabled()) {
		    LOGGER.info("Teste da conexo da aplicao " + applicationCatalogId + " no ambiente " + environmentId + " da regional " + regionalId +
                    " atravs do token de console usando consumidor de servio SOAP...");
        }

        SoapMessageHeader smh = new SoapMessageHeader();
        smh.setExecutionTechnology("JAVA");
        smh.setExecutionVersion(br.com.petrobras.security.DefaultSecurityContext.class.getPackage().getImplementationVersion());

		// Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .testApplicationEnvironmentConnection(smh, regionalId, environmentId, applicationCatalogId, applicationPassword);

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

        if(LOGGER.isInfoEnabled()) {
            LOGGER.info("Teste da conexo da aplicao " + applicationCatalogId + " no ambiente " + environmentId + " da regional " + regionalId +
                " usando consumidor de servio SOAP realizado.");
        }

        return rm;
	}

}
