 /*
 * FunctionManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.enterprise;

 import br.com.petrobras.security.consume.MessageHeader;
 import br.com.petrobras.security.consume.ReturnMessage;
 import br.com.petrobras.security.consume.management.enterprise.IFunctionManagerConsumer;
 import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
 import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
 import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
 import br.com.petrobras.security.model.Function;
 import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

 import java.util.List;

/**
 * Implementao "SOAP" do consumidor de gerenciador de funo de empregado.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class FunctionManagerConsumerSoapImpl implements
        IFunctionManagerConsumer {

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IFunctionManagerConsumer#find(br.com.petrobras.security.consume.MessageHeader, java.lang.Long)
     */
    public ReturnMessage<Function> find(MessageHeader messageHeader,
            Long functionCode) {

        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findFunctionByCode(smhDTO, functionCode);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithFunctionValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IFunctionManagerConsumer#findAll(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<Function>> findAll(MessageHeader messageHeader) {

        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllFunctions(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithFunctionListValue(rmDTO);
    }

}
