/*
 * ConsumeSoapUtil
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities;

import br.com.petrobras.security.consume.soap.SecurityEndPoint;
import br.com.petrobras.security.exception.ConfigurationException;
import br.com.petrobras.security.server.service.soap.ISecurityEndPoint41;
import javax.net.ssl.*;
import javax.xml.ws.BindingProvider;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Utilitrio de consumo do servio SOAP.
 * 
 * @since 1.0
 * @version 1.1
 * 
 */
public class ConsumeSoapUtil {

    /**
     * Logger da classe.
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumeSoapUtil.class);
    /**
     * "End Point" atual.
     */
    private static ISecurityEndPoint41 currentEndPoint = null;

    /**
     * Obtm o "End Point" atual.
     * 
     * @return "End Point" atual.
     */
    public static synchronized ISecurityEndPoint41 getCurrentEndPoint() {
        if (currentEndPoint == null) {
            load();
        }
        return currentEndPoint;
    }

    /**
     * Carrega o "End Point" atual.
     */
    private static void load() {
        try {
            acceptSSL();

            currentEndPoint = new SecurityEndPoint().getSecurity41Port();

            maintainSession(currentEndPoint);
        } catch (MalformedURLException mfue) {
            throw new ConfigurationException("URL do WSDL do servio do Controle de Acesso Corporativo  invlida.", mfue);
        } catch (javax.xml.ws.WebServiceException wse) {
            if (isSSLKeyException(wse)) {
                throw new ConfigurationException("Certificado digital do servio do Controle de Acesso Corporativo no est presente na lista de certificados confiveis do Weblogic Server onde a aplicao est deployada. Entre em contato com a infraestrutura para realizar esta configurao.", wse);
            } else {
                throw new ConfigurationException("Erro de comunicao entre a aplicao e o servio do Controle de Acesso Corporativo.", wse);
            }
        } catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private static void maintainSession(ISecurityEndPoint41 currentEndPoint) {
        // Define que  necessrio manter a sesso com o cliente.

        ((BindingProvider) currentEndPoint).getRequestContext().put(BindingProvider.SESSION_MAINTAIN_PROPERTY, true);
    }

    // https://stackoverflow.com/questions/19005318/implementing-x509trustmanager-passing-on-part-of-the-verification-to-existing
    public static void acceptSSL() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());

        // Using null here initialises the TMF with the default trust store.
        tmf.init((KeyStore) null);

        // Get hold of the default trust manager
        X509TrustManager x509Tm = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (tm instanceof X509TrustManager) {
                x509Tm = (X509TrustManager) tm;
                break;
            }
        }

        // Wrap it in your own class.
        final X509TrustManager finalTm = x509Tm;
        X509TrustManager customTm = new X509TrustManager() {
            @Override
            public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                return finalTm.getAcceptedIssuers();
            }

            @Override
            public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
                finalTm.checkServerTrusted(chain, authType);
            }

            @Override
            public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
                finalTm.checkClientTrusted(chain, authType);
            }
        };

        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[] { customTm }, null);

        // You don't have to set this as the default context,
        // it depends on the library you're using.
        SSLContext.setDefault(sslContext);
    }

    /**
     * Mximo da profundidade da causa da exceo que ser analisada.
     */
    private static final int MAX_DEPTH_CAUSE = 10;

    private static boolean isSSLKeyException(javax.xml.ws.WebServiceException e) {

        LOGGER.debug("Verificando se a exceo tem origem SSLKeyException.");

        Throwable cause = e.getCause();
        int count = 0;

        while (cause != null && count < MAX_DEPTH_CAUSE) {

            if (cause instanceof SSLKeyException) {
                return true;
            }

            count++;
            cause = cause.getCause();
        }

        return false;
    }

}
