/*
 * ResourceMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.Resource;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.ResourceDTO;

import javax.xml.datatype.DatatypeConfigurationException;
import java.util.List;
import java.util.Locale;

/**
 * Montador de recursos.
 * @author Equipe de Desenvolvimento do Controle de Acesso Corporativo
 *
 */
public class ResourceMounter {

    public static Resource mountLocalObject(ResourceDTO resourceDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages)
    {
    	if ((resourceDTO != null) && (((resourceDTO.getParentId() == null) || (resourceDTO.getParentId().equals(""))) == false)) {
    		Resource parent = new Resource(resourceDTO.getParentId()); 
    		return mountLocalObject(resourceDTO, preferredUserLanguage, supportedApplicationLanguages, parent);
    	} else {
    		return mountLocalObject(resourceDTO, preferredUserLanguage, supportedApplicationLanguages, null);
    	}
    }

    public static Resource mountLocalObject(ResourceDTO resourceDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages, Resource parent)
    {
        if (resourceDTO == null)
        {
            return null;
        }
        else
        {
            Resource resource = new Resource();

            //Simple.
            resource.setUid(resourceDTO.getUid());
            resource.setId(resourceDTO.getId());
            resource.setStatisticsEnabled(resourceDTO.isStatisticsEnabled());
            resource.setCreationDate(DateMounter.mountLocalObject(resourceDTO.getCreationDate()));
            resource.setParent(parent);

            //Complex.
            resource.setType(ResourceTypeMounter.mountLocalObject(resourceDTO.getResourceType(), preferredUserLanguage, supportedApplicationLanguages));
            if (resourceDTO.getChildren() != null)
            {
                for(ResourceDTO resChild : resourceDTO.getChildren())
                {
                    resource.getChildren().add(ResourceMounter.mountLocalObject(resChild, preferredUserLanguage, supportedApplicationLanguages, resource));
                }
            }

            //I18n.
            resource.setNameTranslations(I18nStringMounter.mountModelObject(resourceDTO.getNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
            resource.setDescriptionTranslations(I18nStringMounter.mountModelObject(resourceDTO.getDescriptionTranslations(), preferredUserLanguage, supportedApplicationLanguages));
            resource.setCommentTranslations(I18nStringMounter.mountModelObject(resourceDTO.getCommentTranslations(), preferredUserLanguage, supportedApplicationLanguages));

            return resource;
        }
    }
    
    public static ResourceDTO mountTransferObject(Resource resource, List<SupportedLanguage> supportedApplicationLanguages)
    {        
         if ((resource != null ) && (resource.getParent() != null))
         { 
             ResourceDTO parentDTO = new ResourceDTO();
             parentDTO.setId(resource.getParent().getId());

             return mountTransferObject (resource, supportedApplicationLanguages, parentDTO );
         }
         else
         {
             return mountTransferObject (resource, supportedApplicationLanguages, null );
         }
    }

    public static ResourceDTO mountTransferObject
        (Resource resource, List<SupportedLanguage> supportedApplicationLanguages, ResourceDTO parent) {
        
        if (resource == null) {
            return null;
        }
        else {
            if (resource.getNameTranslations() == null || resource.getNameTranslations().getCount() < 1) {
                throw new IllegalArgumentException("A lista de tradues de nome do recurso est nula ou vazia.");
            }

            if (resource.getDescriptionTranslations() == null || resource.getDescriptionTranslations().getCount() < 1) {
                throw new IllegalArgumentException("A lista de tradues de descrio do recurso est nula ou vazia.");
            }

            if (resource.getCommentTranslations() == null || resource.getCommentTranslations().getCount() < 1) {
                throw new IllegalArgumentException("A lista de tradues de comentrio do recurso est nula ou vazia.");
            }

            ResourceDTO resourceDTO = new ResourceDTO();

            //Simple.
            resourceDTO.setUid(resource.getUid());
            resourceDTO.setId(resource.getId());
            resourceDTO.setStatisticsEnabled(resource.isStatisticsEnabled());
            try {
                resourceDTO.setCreationDate(DateMounter.mountTransferObject(resource.getCreationDate()));
            } catch (DatatypeConfigurationException dtce) {
                throw new InvalidOperationException(
                        "No foi possvel converter a data de cadastro do recurso para enviar ao servio. "
                                + dtce.getMessage());
            }
            
            if (parent != null) {
                resourceDTO.setParentId(parent.getId());
            } else {
                resourceDTO.setParentId(null);
            }

            //Complex.
            resourceDTO.setResourceType(ResourceTypeMounter.mountTransferObject(resource.getType()));
            for (Resource resChild : resource.getChildren()) {
                resourceDTO.getChildren().add(ResourceMounter.mountTransferObject(resChild, supportedApplicationLanguages, resourceDTO));
            }

            //I18n.
            resourceDTO.setNameTranslations(I18nStringMounter.mountTransferObject(resource.getNameTranslations(), supportedApplicationLanguages));
            resourceDTO.setDescriptionTranslations(I18nStringMounter.mountTransferObject(resource.getDescriptionTranslations(), supportedApplicationLanguages));
            resourceDTO.setCommentTranslations(I18nStringMounter.mountTransferObject(resource.getCommentTranslations(), supportedApplicationLanguages));

            return resourceDTO;
        }
    }
}

