/*
* @(#)RoleUseCaseAuthorizationListMounter.java
*
*/
/*
 * RoleUseCaseAuthorizationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.configuration.RoleUseCaseAuthorization;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.RoleUseCaseAuthorizationDTO;

import java.util.List;
import java.util.Locale;

/**
 * TODO Comentar.
 *
 * @author Equipe de desenvolvimento do Controle de Acesso Corporativo.
 *
 */
public class RoleUseCaseAuthorizationMounter {

    /**
     * Monta um autorizao de papel em caso de uso a partir de uma autorizao
     * de papel em caso de uso de transferncia.
     * 
     * @param roleUseCaseAuthorizationDTO
     *            Autorizao de papel em caso de uso de transferncia.
     * @param preferredUserLanguage
     * @param supportedApplicationLanguages
     * @return Autorizao de papel em caso de uso
     */
    public static RoleUseCaseAuthorization mountLocalObject(RoleUseCaseAuthorizationDTO roleUseCaseAuthorizationDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (roleUseCaseAuthorizationDTO == null) {
            return null;
        }
        else
        {
            RoleUseCaseAuthorization roleUseCaseAuthorization = new RoleUseCaseAuthorization();

            roleUseCaseAuthorization.setUid(roleUseCaseAuthorizationDTO.getUid());
            roleUseCaseAuthorization.setCreationDate(DateMounter.mountLocalObject(roleUseCaseAuthorizationDTO.getCreationDate()));

            roleUseCaseAuthorization.setRole(RoleMounter.mountLocalObject(roleUseCaseAuthorizationDTO.getRole(), preferredUserLanguage, supportedApplicationLanguages));
            roleUseCaseAuthorization.setUseCase(UseCaseMounter.mountLocalObject(roleUseCaseAuthorizationDTO.getUseCase(), preferredUserLanguage, supportedApplicationLanguages));
            
            return roleUseCaseAuthorization;
        }
    }

}

