/*
 * TokenUserMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.model.security.TokenUser;
import br.com.petrobras.security.server.service.soap.TokenUserDTO;

import java.util.List;

public class TokenUserMounter {

	public static TokenUser mountLocalObject(
			br.com.petrobras.security.server.service.soap.TokenUserDTO tokenUserDTO) {
		if (tokenUserDTO == null) {
			return null;
		} else {
			TokenUser tokenUser = new TokenUser();

			tokenUser.setTicket(TicketMounter.mountLocalObject(tokenUserDTO
					.getTicket()));

			tokenUser.setUser(UserMounter.mountModelObject(tokenUserDTO
					.getUser()));

			List<SupportedLanguage> supportedApplicationLanguages = SupportedLanguageListMounter
					.mountLocalObjectList(tokenUserDTO.getSupportedLanguages());

			tokenUser.setSupportedLanguages(supportedApplicationLanguages);

			tokenUser.setApplicationEnvironment(ApplicationEnvironmentMounter
					.mountLocalObject(tokenUserDTO.getApplicationEnvironment(),
							tokenUser.getUser().getPreferredLanguage(), true));

			tokenUser.setArea(AreaMounter.mountLocalObject(tokenUserDTO
					.getArea(), tokenUser.getUser().getPreferredLanguage(),
					tokenUser.getSupportedLanguages()));

			return tokenUser;
		}
	}

	public static TokenUserDTO mountTransferObject(TokenUser tokenUser) {

		if (tokenUser == null) {
			return null;
		} else {
			TokenUserDTO tokenUserDTO = new TokenUserDTO();

			tokenUserDTO.setTicket(TicketMounter.mountTransferObject(tokenUser
					.getTicket()));

			return tokenUserDTO;
		}
	}

	public static void updateLocalObject(TokenUserDTO tokenUserDTO,
			TokenUser tokenUser) {

		if ((tokenUser != null && tokenUserDTO != null)
				&& (tokenUser.getTicket() != null)
				&& (tokenUserDTO.getTicket() != null)) {
			if (tokenUser.getTicket().equals(tokenUserDTO.getTicket()) == false) {
				throw new InvalidOperationException(
						"Ticket do token de usurio informado  diferente do ticket do token de usurio de transferncia.");
			}

			tokenUser.setTicket(TicketMounter.mountLocalObject(tokenUserDTO
					.getTicket()));
		}
	}

}
