package csbase.login;

import java.security.DigestException;
import java.util.Properties;

import csbase.logic.MDigest;
import csbase.logic.User;
import csbase.server.plugin.service.loginservice.ILoginService;

/**
 * Protocolo LDAP para login do CSBase
 *
 * @author Tecgraf
 */
public class LocalLoginProtocol implements ILoginService {

  /**
   * {@inheritDoc}
   */
  @Override
  public LoginProtocol getProtocolType() { 
    return LoginProtocol.PROTOCOL_LOCAL;
  }

  @Override
  public void setProperties(Properties arg0) {
    // TODO Auto-generated method stub
    
  }
  
  /**
   * Verifica o login de um usurio utilizando o mtodo de autenticao local.
   * Nesse caso, o digest da senha fornecida ser comparado ao da senha local,
   * que se encontra gravado no arquivo de definio do usurio.
   *
   * @param user objeto contendo todas as informaes do usurio.
   * @param password a senha digitada pelo usurio.
   *
   * @return O usurio que se logou ou null se o login e/ou a senha forem
   *         invlidos.
   */
  @Override
  public User authenticate(User user, String password) {
    String digest = "";
    try {
      digest = MDigest.getDigest(password);
    } catch (DigestException e) {
      System.err.println("Erro no login de " + user.getLogin());
      e.printStackTrace();
    }
    if (!user.getPasswordDigest().equals(digest)) {
      return null;
    }
    return user;
  } 
}