/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.rest.adapter.algorithm.v1.ParameterFactory;
import ibase.rest.model.algorithm.v2.InputFileParameter;
import ibase.rest.model.algorithm.v2.Parameter;

public class InputFileParameterFactory
implements ParameterFactory {
    @Override
    public Parameter buildParameter(SimpleParameter p) {
        InputFileParameter parameter = new InputFileParameter();
        this.setCommonAttributes((Parameter)parameter, p);
        parameter.setType(Parameter.TypeEnum.INPUT_FILE);
        if (InputFileListParameter.class.isInstance(p)) {
            InputFileListParameter csbaseParam = (InputFileListParameter)InputFileListParameter.class.cast(p);
            parameter.setMultipleSelection(Boolean.valueOf(true));
            parameter.setSort(Boolean.valueOf(csbaseParam.mustSort()));
            parameter.setUseFilter(Boolean.valueOf(csbaseParam.usesFilter()));
            this.setMode(csbaseParam.getMode(), parameter);
        } else if (csbase.logic.algorithms.parameters.InputFileParameter.class.isInstance(p)) {
            csbase.logic.algorithms.parameters.InputFileParameter csbaseParam = (csbase.logic.algorithms.parameters.InputFileParameter)csbase.logic.algorithms.parameters.InputFileParameter.class.cast(p);
            parameter.setMultipleSelection(Boolean.valueOf(false));
            parameter.setSort(Boolean.valueOf(false));
            parameter.setUseFilter(Boolean.valueOf(csbaseParam.usesFilter()));
            parameter.setAllowsPipe(Boolean.valueOf(csbaseParam.usesPipe().equals((Object)FileParameterPipeAcceptance.TRUE)));
            this.setMode(csbaseParam.getMode(), parameter);
        }
        return parameter;
    }

    private void setMode(FileParameterMode mode, InputFileParameter parameter) {
        switch (mode) {
            case REGULAR_FILE: {
                parameter.setCategory(InputFileParameter.CategoryEnum.REGULAR);
                break;
            }
            case DIRECTORY: {
                parameter.setCategory(InputFileParameter.CategoryEnum.FOLDER);
                break;
            }
            case DIRECTORY_AND_REGULAR_FILE: {
                parameter.setCategory(InputFileParameter.CategoryEnum.BOTH);
            }
        }
    }

    @Override
    public Parameter.TypeEnum getType() {
        return Parameter.TypeEnum.INPUT_FILE;
    }
}

