/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.drmaa2.v1;

import csbase.logic.CommandInfo;
import csbase.logic.User;
import csbase.server.Service;
import csbase.server.services.sgaservice.SGAService;
import ibase.rest.api.drmaa2.v1.adapter.JobDAO;
import ibase.rest.api.drmaa2.v1.adapter.JobMonitorListener;
import ibase.rest.model.drmaa2.v1.Job;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.Executors;

public class JobInfoMonitor {
    private JobDAO jobDAO = null;
    private Collection<JobMonitorListener> jobsListener = Collections.synchronizedList(new ArrayList());
    private Runnable UpdateJobInfoThread = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                JobInfoMonitor jobInfoMonitor = JobInfoMonitor.this;
                synchronized (jobInfoMonitor) {
                    while (JobInfoMonitor.this.jobsListener.isEmpty()) {
                        try {
                            JobInfoMonitor.this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                Service.setUserId((Object)User.getAdminId());
                Vector infos = SGAService.getInstance().getAllSGACommands();
                LinkedList<Job> jobs = new LinkedList<Job>();
                for (CommandInfo info : infos) {
                    Job job = JobInfoMonitor.this.jobDAO.findJobById(info.getId());
                    if (info.getProgressData() == null || info.getProgressData().getDescription().equals(job.getProgressInfo())) continue;
                    job.setProgressInfo(info.getProgressData().getDescription());
                    job.setLastModifiedTime(LocalDateTime.now().toString());
                    JobInfoMonitor.this.jobDAO.updateJob(job);
                    jobs.add(job);
                }
                JobInfoMonitor jobInfoMonitor2 = JobInfoMonitor.this;
                synchronized (jobInfoMonitor2) {
                    if (!jobs.isEmpty()) {
                        for (JobMonitorListener l : JobInfoMonitor.this.jobsListener.toArray(new JobMonitorListener[0])) {
                            l.infoChanged(jobs);
                        }
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                }
            }
        }
    };

    public JobInfoMonitor(JobDAO jobDAO) {
        this.jobDAO = jobDAO;
        Executors.newSingleThreadExecutor().execute(this.UpdateJobInfoThread);
    }

    public synchronized void addJobMonitorListener(JobMonitorListener listener) {
        this.jobsListener.add(listener);
        this.notify();
    }

    public synchronized void removeJobMonitorListener(JobMonitorListener listener) {
        this.jobsListener.remove(listener);
    }
}

