package csbase.rest.adapter.job.v1.parameters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parameters.FileListParameter;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import ibase.common.ServiceUtil;

public class JobParameter {
  private static String ROOT = "root";
  private static String PATH_KEY = "path";
  private static String ID_KEY = "id";


  private String name;
  private Object value;

  public String getName() {
    return name;
  }

  public Object getValue() {
    return value;
  }

  public JobParameter(SimpleParameter p) {
    name = p.getName();
    value = convertValue(p);
  }

  private Object convertValue(SimpleParameter p) {
    if (p.getValue() == null) {
      return null;
    }

    List<Object> paramValue = new ArrayList<>();
    if (p instanceof EnumerationListParameter) {
      paramValue =
        EnumerationListParameter.class.cast(p).getValue().stream().
          map(EnumerationItem::getId).
          collect(Collectors.toList());
    } else if (p instanceof FileParameter) {
      paramValue.add(buildPathObject(FileParameter.class.cast(p).getValue().getPath()));
    } else if (p instanceof FileListParameter) {
      paramValue = FileListParameter.class.cast(p).getValue().stream().
        map(fp -> buildPathObject(fp.getPath())).
        collect(Collectors.toList());
    } else if (p instanceof ListParameter) {
      paramValue =
        List.class.cast(ListParameter.class.cast(p).getValue());
    } else if (p instanceof TableParameter) {
      Map<String, Object> tab = TableParameter.class.cast(p).exportValue();
      List<Object[]> rows = (List<Object[]>) tab.get(p.getName());
      for(Object[] row : rows) {
        paramValue.add(row);
      }
    } else {
      paramValue.add(p.getValueAsText());
    }

    return paramValue;
  }

  private HashMap<String, String> buildPathObject(String path) {
    HashMap<String, String> pathObj = new HashMap<>();
    pathObj.put(PATH_KEY, path);
    if (path.equals(".")) {
      pathObj.put(ID_KEY, ROOT);
    } else {
      pathObj.put(ID_KEY, ServiceUtil.encodeToBase64(path));
    }
    return pathObj;
  }
}
