/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1.DAO;

import ibase.rest.api.job.v1.adapter.JobDAO;
import ibase.rest.model.job.v1.Job;
import ibase.rest.model.job.v1.JobSession;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultJobDAO
implements JobDAO {
    private Map<String, JobSession> jobSessions = new HashMap<String, JobSession>();
    private Map<String, Job> jobs = new HashMap<String, Job>();
    private Map<String, List<Job>> jobsBySession = new HashMap<String, List<Job>>();

    public boolean containsJob(String jobId) {
        return this.jobs.containsKey(jobId);
    }

    public List<Job> findAllJobs() {
        return this.jobs.values().stream().collect(Collectors.toList());
    }

    public Job findJobById(String jobId) {
        return this.jobs.get(jobId);
    }

    public List<Job> findJobs(String projectId, Long modifiedAfter) {
        List<Job> filteredJobs = this.jobs.values().stream().filter(j -> {
            if (projectId != null && !j.getProjectId().equals(projectId)) {
                return false;
            }
            return modifiedAfter == null || !LocalDateTime.parse(j.getLastModifiedTime()).isBefore(LocalDateTime.ofInstant(Instant.ofEpochMilli(modifiedAfter), ZoneId.systemDefault()));
        }).collect(Collectors.toList());
        return filteredJobs;
    }

    public List<Job> findJobsBySession(String jobSessionId) {
        return this.jobsBySession.get(jobSessionId);
    }

    public boolean insertJob(Job job) {
        this.jobs.put(job.getJobId(), job);
        List<Job> jobs = this.jobsBySession.get(job.getSessionId());
        if (jobs == null) {
            jobs = new ArrayList<Job>();
            this.jobsBySession.put(job.getSessionId(), jobs);
        }
        jobs.add(job);
        return true;
    }

    public boolean updateJob(Job job) {
        Job oldJob = this.jobs.get(job.getJobId());
        this.jobs.put(job.getJobId(), job);
        List<Job> sessionJobs = this.jobsBySession.get(job.getSessionId());
        sessionJobs.remove(oldJob);
        sessionJobs.add(job);
        return true;
    }

    public boolean containsJobSession(String sessionId) {
        return this.jobSessions.containsKey(sessionId);
    }

    public List<JobSession> findAllJobSessions() {
        return this.jobSessions.values().stream().collect(Collectors.toList());
    }

    public JobSession findJobSessionById(String sessionId) {
        return this.jobSessions.get(sessionId);
    }

    public void insertJobSession(JobSession jobSession) {
        this.jobSessions.put(jobSession.getSessionName(), jobSession);
    }
}

