/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocalCache<K, V>
extends ConcurrentHashMap<K, V> {
    private Map<K, Long> timeMap = new ConcurrentHashMap<K, Long>();
    private long expiryInMillis;

    public LocalCache(long expiryInMillis) {
        this.expiryInMillis = expiryInMillis;
    }

    @Override
    public V put(K key, V value) {
        this.timeMap.put(key, System.currentTimeMillis());
        V returnVal = super.put(key, value);
        this.cleanMap();
        return returnVal;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K key : m.keySet()) {
            this.put(key, m.get(key));
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (!this.containsKey(key)) {
            return this.put(key, value);
        }
        return this.get(key);
    }

    public Collection<V> valuesAfter(long after) {
        ArrayList values = new ArrayList();
        for (K key : this.timeMap.keySet()) {
            if (after > this.timeMap.get(key)) continue;
            values.add(this.get(key));
        }
        return values;
    }

    private void cleanMap() {
        long currentTime = System.currentTimeMillis();
        for (K key : this.timeMap.keySet()) {
            if (currentTime <= this.timeMap.get(key) + this.expiryInMillis) continue;
            this.remove(key);
            this.timeMap.remove(key);
        }
    }
}

