/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1.event;

import br.pucrio.tecgraf.soma.job.Algorithm;
import br.pucrio.tecgraf.soma.job.Flow;
import br.pucrio.tecgraf.soma.job.JobFinishedEvent;
import br.pucrio.tecgraf.soma.job.JobScheduledEvent;
import br.pucrio.tecgraf.soma.job.SpecificationType;
import csbase.logic.CommandInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.rest.adapter.job.v1.event.IJobHistoryEventFactory;
import csbase.rest.adapter.job.v1.util.CSBaseCommandUtil;
import csbase.server.plugin.service.commandpersistenceservice.ICommandInfo;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.UUID;

public class JobHistoryEventFactory
implements IJobHistoryEventFactory {
    @Override
    public JobScheduledEvent buildScheduledEvent(ICommandInfo commandInfo, CommandInfo csbaseCommandInfo) {
        JobScheduledEvent scheduledEvent = new JobScheduledEvent();
        scheduledEvent.setAutomaticallyMachineSelection(Boolean.valueOf(csbaseCommandInfo.isAutomatic()));
        scheduledEvent.setJobId(commandInfo.getCommandId());
        scheduledEvent.setOwner(csbaseCommandInfo.getUserId().toString());
        try {
            AlgorithmConfigurator algoConf = csbaseCommandInfo.getConfigurator();
            if (this.isFlow(algoConf)) {
                Flow flow = this.buildFlowObject(algoConf);
                scheduledEvent.setSpecificationType(SpecificationType.FLOW);
                scheduledEvent.setSpecification((Object)flow);
            } else {
                Algorithm algorithm = this.createAlgorithmFromConfig(algoConf);
                scheduledEvent.setSpecificationType(SpecificationType.ALGORITHM);
                scheduledEvent.setSpecification((Object)algorithm);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        String description = csbaseCommandInfo.getDescription();
        if (description == null) {
            scheduledEvent.setDescription("");
        } else {
            scheduledEvent.setDescription(description);
        }
        scheduledEvent.setEventId(UUID.randomUUID().toString());
        scheduledEvent.setGroupId(csbaseCommandInfo.getGroupId() != null ? csbaseCommandInfo.getGroupId() : "");
        scheduledEvent.setMultipleExecution(Boolean.valueOf(csbaseCommandInfo.getExecutionType() == ExecutionType.MULTIPLE));
        Integer execCount = csbaseCommandInfo.getExecutionCountForMultipleExecution();
        if (execCount == null) {
            execCount = 1;
        }
        scheduledEvent.setNumberOfProcesses(execCount);
        Integer execCountBtMachine = csbaseCommandInfo.getExecutionCountPerSGAForMultipleExecution();
        if (execCountBtMachine == null) {
            execCountBtMachine = 1;
        }
        scheduledEvent.setNumberOfProcessesByMachine(execCountBtMachine);
        scheduledEvent.setPriority(Integer.valueOf(csbaseCommandInfo.getPriority().ordinal()));
        scheduledEvent.setProjectId(commandInfo.getProjectId());
        scheduledEvent.setSelectedMachines(Arrays.asList(csbaseCommandInfo.getSelectedSGAsNames().toArray(new String[0])));
        scheduledEvent.setSubmissionTime(Long.valueOf(csbaseCommandInfo.getSubmittedDate().getTime()));
        scheduledEvent.setTimestamp(Long.valueOf(csbaseCommandInfo.getSubmittedDate().getTime()));
        return scheduledEvent;
    }

    private long calcEndTime(CommandInfo csbaseCommandInfo) {
        if (csbaseCommandInfo.getWallTimeSec() == null) {
            return csbaseCommandInfo.getSubmittedDate().getTime();
        }
        return csbaseCommandInfo.getSubmittedDate().getTime() + (long)(csbaseCommandInfo.getWallTimeSec() * 1000);
    }

    @Override
    public JobFinishedEvent buildFinishedEvent(ICommandInfo commandInfo, CommandInfo csbaseCommandInfo) {
        JobFinishedEvent finishedEvent = new JobFinishedEvent();
        finishedEvent.setJobId(commandInfo.getCommandId());
        finishedEvent.setProjectId(commandInfo.getProjectId());
        long currentTimeMillis = this.calcEndTime(csbaseCommandInfo);
        finishedEvent.setEndTime(Long.valueOf(currentTimeMillis));
        Double cpuTimeSec = csbaseCommandInfo.getCpuTimeSec();
        if (cpuTimeSec == null) {
            cpuTimeSec = 0.0;
        }
        finishedEvent.setCpuTime(Long.valueOf(cpuTimeSec.longValue()));
        finishedEvent.setEventId(UUID.randomUUID().toString());
        finishedEvent.setExitCode(csbaseCommandInfo.getFinalizationInfo().getExitCode());
        finishedEvent.setExitStatus(CSBaseCommandUtil.getExitStatusFromInfo(csbaseCommandInfo.getFinalizationInfo()));
        finishedEvent.setGuiltyNodeId(commandInfo.getGuiltyNodeId());
        finishedEvent.setTimestamp(Long.valueOf(currentTimeMillis));
        Integer wallTimeSec = csbaseCommandInfo.getWallTimeSec();
        if (wallTimeSec == null) {
            wallTimeSec = 0;
        }
        finishedEvent.setWallclockTime(Long.valueOf(wallTimeSec.longValue()));
        return finishedEvent;
    }

    protected boolean isFlow(AlgorithmConfigurator algoConf) {
        return algoConf.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW;
    }

    protected Algorithm createAlgorithmFromConfig(AlgorithmConfigurator algoConf) {
        return CSBaseCommandUtil.createAlgorithmFromConfig(algoConf);
    }

    protected Flow buildFlowObject(AlgorithmConfigurator algoConf) {
        FlowAlgorithmConfigurator flowConf = (FlowAlgorithmConfigurator)algoConf;
        Flow flow = CSBaseCommandUtil.createFlowFromConfig(flowConf);
        return flow;
    }
}

