/*
 * Decompiled with CFR 0.152.
 */
package csbase.server;

import csbase.exception.ServiceFailureException;
import csbase.logic.Permission;
import csbase.logic.SecureKey;
import csbase.logic.User;
import csbase.remote.ServiceInterface;
import csbase.server.HierachicalResourceBundle;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.ServerRemoteObjectObservable;
import csbase.server.ServerSideProperties;
import csbase.server.ServiceManager;
import csbase.server.ServiceState;
import csbase.server.services.loginservice.LoginService;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedSet;
import org.slf4j.MDC;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.properties.PropertiesUtils;

public abstract class Service
extends ServerRemoteObjectObservable
implements ServiceInterface {
    private static final String DEFAULT_LAGUANGE_FILE_NAME = "idiom";
    private static final String ADDITIONAL_LANGUAGE_FILE_PROPERTY = "additional.language.file";
    private final ServerSideProperties serviceProperties;
    private String serviceName;
    private ServiceState state;
    private boolean enabled;
    private final Hashtable<Locale, HierachicalResourceBundle> bundles = new Hashtable();
    private static ThreadLocal<Object> threadUserKey = new ThreadLocal();
    private static ThreadLocal<String> threadSystemKey = new ThreadLocal();

    private static void updateMDCUser() {
        User user = Service.getUser();
        if (user != null) {
            MDC.put((String)"user", (String)user.getLogin());
        } else {
            MDC.remove((String)"user");
        }
    }

    public static void setKey(Object key) {
        threadUserKey.set(key);
        Service.updateMDCUser();
    }

    public static void setUserId(Object userId) {
        threadUserKey.set(userId);
        Service.updateMDCUser();
    }

    public static boolean isInternalServerRequest() {
        Object localObject = threadUserKey.get();
        return !(localObject instanceof SecureKey);
    }

    public static final User getUser() {
        Object localObject = threadUserKey.get();
        if (localObject == null) {
            return null;
        }
        if (localObject instanceof SecureKey) {
            return LoginService.getInstance().getUserByKey(localObject);
        }
        try {
            return User.getUser((Object)localObject);
        }
        catch (Exception e) {
            throw new ServiceFailureException("Falha ao obter usu\u00e1rio " + localObject, (Throwable)e);
        }
    }

    public static final Object getKey() {
        return threadUserKey.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadLanguageBundle(Locale locale) {
        ArrayList<String> languageFiles = new ArrayList<String>();
        languageFiles.add(DEFAULT_LAGUANGE_FILE_NAME);
        languageFiles.addAll(this.getStringListProperty(ADDITIONAL_LANGUAGE_FILE_PROPERTY));
        boolean hasBundlesForService = false;
        HierachicalResourceBundle parent = null;
        for (String filePath : languageFiles) {
            String fileName = String.format("%s_%s.properties", filePath, locale);
            Class<?> thisClass = ((Object)((Object)this)).getClass();
            parent = Server.getInstance().getBundle(locale);
            if (parent != null) {
                hasBundlesForService = true;
                this.bundles.put(locale, parent);
            }
            while (thisClass != Service.class) {
                String logFormat;
                InputStream in = thisClass.getResourceAsStream(fileName);
                thisClass = thisClass.getSuperclass();
                try {
                    if (in == null) continue;
                    hasBundlesForService = true;
                    HierachicalResourceBundle bundle = new HierachicalResourceBundle(in);
                    this.bundles.put(locale, bundle);
                    logFormat = "Arquivo de bundle %s carregado.";
                    Server.logInfoMessage(String.format(logFormat, fileName));
                    if (parent != null) {
                        bundle.setParent(parent);
                    }
                    parent = bundle;
                }
                catch (Exception e) {
                    logFormat = "Falha na leitura de: %s --> %s";
                    String msg = e.getMessage();
                    Server.logSevereMessage(String.format(logFormat, filePath, msg));
                    logFormat = "Falha no bundle de: %s";
                    Server.logSevereMessage(String.format(logFormat, locale));
                    boolean bl = hasBundlesForService;
                    return bl;
                }
                finally {
                    FileUtils.close((Closeable)in);
                }
            }
        }
        return hasBundlesForService;
    }

    public final Locale getDefaultLocale() {
        Server server = Server.getInstance();
        return server.getDefaultLocale();
    }

    protected final Locale getThreadLocale() {
        Object key = Service.getKey();
        if (key == null) {
            return null;
        }
        LoginService lgService = LoginService.getInstance();
        Locale locale = lgService.getUserSessionLocale(key);
        return locale;
    }

    protected final <T extends Permission> T getUserPermission(Class<T> permissionClass) {
        return (T)Service.getUser().getPermission(permissionClass);
    }

    public final String getFormattedString(String key, Object[] objects, Locale locale) {
        String txt = this.getString(key, locale);
        String msg = MessageFormat.format(txt, objects);
        return msg;
    }

    public final String getFormattedString(String key, Object[] objects) {
        String txt = this.getString(key);
        String msg = MessageFormat.format(txt, objects);
        return msg;
    }

    public final String getString(String key) {
        Locale locale = this.getThreadLocale();
        if (locale == null) {
            locale = this.getDefaultLocale();
        }
        return this.getString(key, locale);
    }

    public final String getOptionalString(String key) {
        Locale locale = this.getThreadLocale();
        if (locale == null) {
            locale = this.getDefaultLocale();
        }
        return this.getOptionalString(key, locale);
    }

    public final String getString(String key, Locale locale) {
        String str = this.getOptionalString(key, locale);
        if (str != null) {
            return str;
        }
        return "<<<" + key + ":" + locale + ">>>";
    }

    public final String getOptionalString(String key, Locale locale) {
        boolean loaded;
        if (key == null) {
            Server.logSevereMessage("Chave nula em consulta \u00e0 internacionaliza\u00e7\u00e3o");
            return "<<<null-key>>>";
        }
        if (locale == null) {
            Server.logSevereMessage("Locale nulo em consulta \u00e0 internacionaliza\u00e7\u00e3o da chave: " + key);
            return "<<<null-locale>>>";
        }
        if (!this.bundles.containsKey(locale) && !(loaded = this.loadLanguageBundle(locale))) {
            return null;
        }
        try {
            ResourceBundle bnd = this.bundles.get(locale);
            return bnd.getString(key);
        }
        catch (MissingResourceException mre) {
            return null;
        }
        catch (Exception e) {
            String txt = "Falha de internacionaliza\u00e7\u00e3o";
            String msg = e.getMessage();
            Server.logSevereMessage("Falha de internacionaliza\u00e7\u00e3o [" + key + ":" + locale + "] - " + msg);
            return "<<<" + key + ":" + locale + ">>>";
        }
    }

    private ServerSideProperties loadProperties(String fileName) throws ServerException {
        ServerSideProperties prop = new ServerSideProperties(fileName);
        prop.load();
        return prop;
    }

    private final String getPrefixedPropertyKey(String key) {
        return this.getName() + "." + key;
    }

    private void checkPropertiesLoaded() {
        if (this.serviceProperties == null) {
            String msg = "Falha interna de implementa\u00e7\u00e3o do servi\u00e7o!\n\nPropriedades do servi\u00e7o ainda n\u00e3o devidamente carregadas";
            throw new IllegalStateException("Falha interna de implementa\u00e7\u00e3o do servi\u00e7o!\n\nPropriedades do servi\u00e7o ainda n\u00e3o devidamente carregadas");
        }
    }

    public final boolean isPropertyNull(String key) {
        this.checkPropertiesLoaded();
        String prefixedKey = this.getPrefixedPropertyKey(key);
        Server server = Server.getInstance();
        if (server.overridesServiceProperty(prefixedKey)) {
            String value = server.getStringServiceProperty(prefixedKey);
            return ServerSideProperties.isPropertyValueNull(value);
        }
        return this.serviceProperties.isPropertyNull(prefixedKey);
    }

    protected final Properties getExternalPropertyFile(String key) {
        String filePath = this.getStringProperty(key);
        if (ServerSideProperties.isPropertyValueNull(filePath)) {
            return new Properties();
        }
        try {
            return PropertiesUtils.loadProperties((String)filePath);
        }
        catch (Exception e) {
            throw new ServiceFailureException("Erro na carga de propriedades de " + filePath, (Throwable)e);
        }
    }

    public final List<String> getStringListProperty(String key) {
        this.checkPropertiesLoaded();
        Server server = Server.getInstance();
        String prefixedKey = this.getPrefixedPropertyKey(key);
        boolean overriden = server.overridesServiceProperty(prefixedKey.concat(".1"));
        if (overriden) {
            return server.getStringListServiceProperty(prefixedKey);
        }
        return this.serviceProperties.getStringListProperty(prefixedKey);
    }

    public final String getStringProperty(String key) {
        this.checkPropertiesLoaded();
        Server server = Server.getInstance();
        String prefixedKey = this.getPrefixedPropertyKey(key);
        boolean overriden = server.overridesServiceProperty(prefixedKey);
        if (overriden) {
            return server.getStringServiceProperty(prefixedKey);
        }
        return this.serviceProperties.getStringProperty(prefixedKey);
    }

    public final double getDoubleProperty(String key) {
        String prefixedKey;
        Server server = Server.getInstance();
        boolean overriden = server.overridesServiceProperty(prefixedKey = this.getPrefixedPropertyKey(key));
        if (overriden) {
            return server.getDoubleServiceProperty(prefixedKey);
        }
        return this.serviceProperties.getDoubleProperty(prefixedKey);
    }

    public final int getIntProperty(String key) {
        String prefixedKey;
        Server server = Server.getInstance();
        boolean overriden = server.overridesServiceProperty(prefixedKey = this.getPrefixedPropertyKey(key));
        if (overriden) {
            return server.getIntServiceProperty(prefixedKey);
        }
        return this.serviceProperties.getIntProperty(prefixedKey);
    }

    public final long getLongProperty(String key) {
        String prefixedKey;
        Server server = Server.getInstance();
        boolean overriden = server.overridesServiceProperty(prefixedKey = this.getPrefixedPropertyKey(key));
        if (overriden) {
            return server.getLongServiceProperty(prefixedKey);
        }
        return this.serviceProperties.getLongProperty(prefixedKey);
    }

    public final boolean getBooleanProperty(String key) {
        String prefixedKey;
        Server server = Server.getInstance();
        boolean overriden = server.overridesServiceProperty(prefixedKey = this.getPrefixedPropertyKey(key));
        if (overriden) {
            return server.getBooleanServiceProperty(prefixedKey);
        }
        return this.serviceProperties.getBooleanProperty(prefixedKey);
    }

    final String getDefaultPropertyValue(String key) {
        return this.serviceProperties.hasProperty(key) ? this.serviceProperties.getStringProperty(key) : null;
    }

    protected final String getOSPropertyPath(String propertyPath) {
        String UNIX_SEPARATOR = "/";
        if (propertyPath.indexOf("/") < 1) {
            return propertyPath;
        }
        String[] splittedPath = FileUtils.splitPath((String)propertyPath, (String)"/");
        String osPath = FileUtils.joinPath((String[])splittedPath);
        if (propertyPath.lastIndexOf("/") == propertyPath.length() - 1) {
            return osPath + File.separator;
        }
        return osPath;
    }

    public final String getName() {
        return this.serviceName;
    }

    public String getSenderName() {
        String serviceName = this.getName();
        String text = this.getOptionalString(serviceName);
        if (text == null) {
            return serviceName;
        }
        Server server = Server.getInstance();
        String serverName = server.getSystemName();
        text = text.replaceAll("\\$SERVICE_ID", serviceName);
        text = text.replaceAll("\\$SERVER_NAME", serverName);
        return text;
    }

    public boolean isLoggingNotifications() {
        return true;
    }

    public void logNotification(String msg) {
        Server.logInfoMessage(this.getName() + " " + msg);
    }

    public static Map<String, Service> getServices() {
        return ServiceManager.getInstance().getServices();
    }

    public boolean isActive() {
        return this.isEnabled() && this.state.equals((Object)ServiceState.INITED);
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    protected final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static Service getInstance(String serviceName) {
        return ServiceManager.getInstance().getService(serviceName);
    }

    protected Service(String srvName) throws ServerException {
        super(Server.getInstance().getDefaultLocale());
        this.serviceName = srvName;
        this.enabled = true;
        String sep = File.separator;
        String proDirName = Server.getPropertiesRootDirectoryName();
        String proFileName = srvName + ".properties";
        String servicePropertiesFileName = proDirName + sep + proFileName;
        this.serviceProperties = this.loadProperties(servicePropertiesFileName);
        this.state = ServiceState.CREATED;
        ServiceManager serviceManager = ServiceManager.getInstance();
        serviceManager.addService(this);
    }

    public static void setSystemId(String systemId) {
        threadSystemKey.set(systemId);
    }

    public static final String getSystemId() {
        return threadSystemKey.get();
    }

    protected Service[] getInitializationDependencies() {
        return new Service[0];
    }

    final boolean tryInit() throws ServerException {
        Server.logFineMessage(String.format("Tentando inicializar o servi\u00e7o %s.", this.getName()));
        if (!this.isEnabled()) {
            throw new ServerException(String.format("O servi\u00e7o %s n\u00e3o pode ser inicializado porque est\u00e1 desabilitado.", this.getName()));
        }
        Service[] dependencies = this.getInitializationDependencies();
        for (int i = 0; i < dependencies.length; ++i) {
            if (dependencies[i].isEnabled()) {
                if (dependencies[i].getState() == ServiceState.INITED) continue;
                return false;
            }
            Server.logWarningMessage(String.format("O servi\u00e7o %s, que \u00e9 uma depend\u00eancia do servi\u00e7o %s, n\u00e3o est\u00e1 habilitado", dependencies[i].getName(), this.getName()));
        }
        this.init();
        return true;
    }

    private final void init() throws ServerException {
        Server.logInfoMessage(String.format("Inicializando o servi\u00e7o %s", this.getName()));
        this.initService();
        this.state = ServiceState.INITED;
        Server.logInfoMessage(String.format("O servi\u00e7o %s foi iniciado com sucesso", this.getName()));
    }

    protected abstract void initService() throws ServerException;

    final void shutdown() throws ServerException {
        Server.logInfoMessage(String.format("Terminando o servi\u00e7o %s", this.getName()));
        if (!this.isEnabled()) {
            throw new ServerException(String.format("O servi\u00e7o %s n\u00e3o pode ser terminado porque est\u00e1 desabilitado.", this.getName()));
        }
        this.shutdownService();
        this.state = ServiceState.TERMINATED;
        Server.logInfoMessage(String.format("O servi\u00e7o %s foi terminado com sucesso", this.getName()));
    }

    protected abstract void shutdownService() throws ServerException;

    final ServiceState getState() {
        return this.state;
    }

    SortedSet<Object> getPropertiesKeys() {
        return this.serviceProperties.getPropertiesKeys();
    }

    Map<String, String> getPropertiesMap() {
        return this.serviceProperties.getPropertiesMap();
    }

    protected <T> void incrCounter(Map<T, Integer> counter, T key) {
        Integer count = counter.get(key);
        if (count == null) {
            counter.put(key, 1);
        } else {
            counter.put(key, count + 1);
        }
    }

    public boolean hasProperty(String propertyKey) {
        return this.serviceProperties.hasProperty(propertyKey);
    }
}

