/*
 * $Id:$
 */

package csbase.server.services.administrationservice;

import java.util.Properties;

/**
 * Implementao da fbrica de DAOs (Data Access Objects) para o servio de
 * administrao que ser utilizada caso no seja especificada nenhuma outra
 * implementao. Essa implementao cria os DAOs que utilizam o armazenamento
 * em arquivo (serializao de objetos). Responsvel pela criao dos objetos de
 * acesso a dados de usurios, grupos, perfis, permisses e paltaforma.
 * 
 * @see DefaultPermissionDAO
 * @see DefaultPlatformDAO
 * @see DefaultRoleDAO
 * @see DefaultUserDAO
 * @see DefaultUserGroupDAO
 * @author Tecgraf/PUC-Rio
 */
public class DefaultAdministrationDAOFactory implements
  AdministrationDAOFactory {

  /**
   * {@inheritDoc}
   */
  public PermissionDAO createPermissionDAO() {
    return new DefaultPermissionDAO();
  }

  /**
   * {@inheritDoc}
   */
  public PlatformDAO createPlatformDAO() {
    return new DefaultPlatformDAO();
  }

  /**
   * {@inheritDoc}
   */
  public RoleDAO createRoleDAO() {
    return new DefaultRoleDAO();
  }

  /**
   * {@inheritDoc}
   */
  public UserDAO createUserDAO() {
    return new DefaultUserDAO();
  }

  /**
   * {@inheritDoc}
   */
  public UserGroupDAO createUserGroupDAO() {
    return new DefaultUserGroupDAO();
  }
}
