/*
 * $Id:$
 */
package csbase.server.services.filetransferservice.ftp;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;

import csbase.exception.ServiceFailureException;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferElement;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.server.services.filetransferservice.FileTransferJob;
import csbase.server.services.filetransferservice.FileTransferProtocolStub;

/**
 * Stub de implementao do protocolo FTP.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FTPStub implements FileTransferProtocolStub {

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean checkConnection(final FileTransferConnection connection)
    throws ServiceFailureException {
    FTPClient ftp = new FTPClient();
    try {
      final String server = connection.getServerName();
      final String user = connection.getUserName();
      final String password = connection.getPassword();
      ftp.connect(server);
      final boolean loginOk = ftp.login(user, password);
      if (!loginOk) {
        return false;
      }
      return true;
    }
    catch (Exception e) {
      try {
        if (ftp.isConnected()) {
          ftp.disconnect();
        }
      }
      catch (Exception e2) {
        // No faz nada, pois a falha foi justamente no disconnect.
      }
      throw new ServiceFailureException(e.getMessage());
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public FileTransferJob createDownloadJob(FileTransferRequest request)
    throws ServiceFailureException {
    final FTPDownloadJob job = new FTPDownloadJob(request);
    return job;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<FileTransferElement> listContent(
    FileTransferConnection connection, String remoteDirPath)
    throws ServiceFailureException {
    FTPClient ftp = new FTPClient();
    try {
      final String server = connection.getServerName();
      final String user = connection.getUserName();
      final String password = connection.getPassword();
      ftp.connect(server);
      final boolean loginOk = ftp.login(user, password);
      if (!loginOk) {
        throw new Exception("Bad login");
      }
      ftp.enterLocalPassiveMode();
      ftp.setFileType(FTP.ASCII_FILE_TYPE);
      final String systemName = ftp.getSystemName();

      if (systemName == null) {
        final String UNIX = FTPClientConfig.SYST_UNIX;
        final FTPClientConfig config = new FTPClientConfig(UNIX);
        ftp.configure(config);
      }

      final FTPFile[] content;
      String rDir = remoteDirPath;
      if (remoteDirPath.equals("/")) {
        ftp.changeWorkingDirectory("/");
        content = ftp.listFiles();
        // System.out.println(ok+" - "+content.length);
      }
      else if (remoteDirPath.equals("")) {
        content = ftp.listFiles();
      }
      else {
        content = ftp.listFiles(rDir);
      }

      final ArrayList<FileTransferElement> list =
        new ArrayList<FileTransferElement>();
      for (FTPFile f : content) {
        if (f == null)
          continue;
        // System.out.println(f);
        final String name = f.getName();
        if (name.equals("..")) {
          continue;
        }
        if (name.equals(".")) {
          continue;
        }
        final boolean isDir = f.isDirectory();
        final long size = f.getSize();
        final boolean isLink = f.isSymbolicLink();
        final FileTransferElement ftpFile =
          new FileTransferElement(name, isDir, size, isLink);
        list.add(ftpFile);
      }

      ftp.logout();
      ftp.disconnect();
      return list;
    }
    catch (Exception e) {
      try {
        if (ftp.isConnected()) {
          ftp.disconnect();
        }
      }
      catch (Exception e2) {
        // No faz nada, pois a falha foi justamente no disconnect.
      }
      throw new ServiceFailureException(e.getMessage());
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public FileTransferJob createUploadJob(FileTransferRequest request)
    throws ServiceFailureException {
    final FTPUploadJob job = new FTPUploadJob(request);
    return job;
  }
}
