/*
 * $Id: FTPUtils.java 96878 2009-09-30 17:50:41Z clinio $
 */

package csbase.server.services.filetransferservice.ftp;


/**
 * Classe interna do servio para fazer escape de caracteres reservados.
 * 
 * @author Carlos Cassino.
 */
class FTPCharMap {

  /**
   * Caracter reservado
   */
  final public String reserved;

  /**
   * Caracter de escape
   */
  final public String escape;

  /**
   * Construtor padro com ajuste de caracteres (reservado e escape).
   * 
   * @param reserved caracter reservado
   * @param escape caracter escape
   */
  FTPCharMap(final String reserved, final String escape) {
    this.reserved = reserved;
    this.escape = escape;
  }
}

/**
 * Mtodos estticos para FTP.
 * 
 * @author Tecgraf/PUC-Rio
 */
class FTPUtils {

  /**
   * Codifica os caracteres necessrios de um texto para que ele possa ser
   * inserido corretamente em uma URL.
   * 
   * @param value o texto.
   * @return uma string com <i>escapes</i>.
   */
  static String encode(final String value) {
    String val = value;
    for (int i = 0; i < maps.length; i++) {
      val = val.replaceAll(maps[i].reserved, maps[i].escape);
    }
    return val;
  }

  /**
   * Caracteres reservados para a URL
   */
  private static final FTPCharMap[] maps =
    { new FTPCharMap(";", "%3B"), new FTPCharMap("/", "%2F"),
        new FTPCharMap("\\x3F", "%3F"), new FTPCharMap(":", "%3A"),
        new FTPCharMap("@", "%40"), new FTPCharMap("&", "%26"),
        new FTPCharMap("=", "%3D"), new FTPCharMap("\\x2B", "%2B"),
        new FTPCharMap("\\x24", "%24"), new FTPCharMap(",", "%2C") };

  /**
   * Constri o componente de especificao do arquivo remoto a ser colocado na
   * URL; uma <code>'/'</code> no incio do caminho para o arquivo significa que
   * ele  absoluto e no relativo ao diretrio padro (home) do usurio remoto.
   * 
   * @param path o caminho para o arquivo remoto.
   * @return o texto a ser colocado na URL para referenciar o arquivo remoto.
   */
  static String encodeFilePath(final String path) {
    final StringBuffer result = new StringBuffer();
    final String[] parts = path.split("/");
    String sep = "";
    for (int i = 0; i < parts.length; i++) {
      if (parts[i].equals("")) {
        if (i == 0) {
          result.append("%2F");
        }
      }
      else {
        result.append(sep).append(encode(parts[i]));
        sep = "/";
      }
    }
    return result.toString();
  }
}
