package csbase.server.services.projectservice;

import java.io.Serializable;

import csbase.logic.ProjectFileInfo;

/**
 * Define um template de projeto a partir de um diretrio-base. O template define restries impostas a operaes nos
 * arquivos de projeto dentro do diretrio especificado.
 */
public interface ProjectTemplate extends Serializable {

  /**
   * Determina se o arquivo pode ser renomeado.
   *
   * @param file o arquivo.
   * @param newName o novo nome para o arquivo.
   *
   * @return verdadeiro se o arquivo pode ser renomeado ou falso, caso contrrio.
   */
  public boolean canRename(ServerProjectFile file, String newName);

  /**
   * Determina se o arquivo pode ser removido.
   *
   * @param file o arquivo.
   * @return verdadeiro se o arquivo pode ser removido ou falso, caso contrrio.
   */
  public boolean canDelete(ServerProjectFile file);

  /**
   * Determina se o arquivo pode ser criado.
   *
   * @param name o nome do arquivo a ser criado.
   * @param type o tipo do arquivo a ser criado.
   * @param parent o diretrio onde o arquivo seria criado.
   * @return verdadeiro se o arquivo pode ser criado ou falso, caso contrrio.
   */
  public boolean canCreate(ServerProjectFile parent, String name, String type);

  /**
   * Determina se o tipo do arquivo pode ser trocado.
   *
   * @param file o arquivo.
   * @param newType o novo tipo do arquivo.
   * @return verdadeiro se o tipo pode ser trocado ou falso, caso contrrio.
   */
  public boolean canChangeType(ServerProjectFile file, String newType);

  /**
   * Obtm o diretrio-base do template.
   *
   * @return o diretrio.
   */
  public ProjectFileInfo getBaseDir();
}
