package csbase.server.services.filetransferservice.sftp;

import com.jcraft.jsch.UserInfo;

/**
 * Stub de UserInfo
 * 
 * @author Tecgraf/PUC-Rio
 */
final class StubUserInfo implements UserInfo {

  /**
   * Senha.
   */
  final private String password;

  /**
   * {@inheritDoc}
   */
  @Override
  public void showMessage(String arg0) {
    return;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean promptYesNo(String arg0) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean promptPassword(String arg0) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean promptPassphrase(String arg0) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getPassword() {
    return password;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getPassphrase() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param password senha
   */
  StubUserInfo(final String password) {
    this.password = password;
  }
}
