/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.exception.PermissionException;
import csbase.logic.SuperUserPermission;
import csbase.logic.User;
import csbase.logic.UserInfo;
import csbase.logic.UserOutline;
import csbase.logic.UserUpdate;
import csbase.server.services.administrationservice.DAOException;
import csbase.server.services.administrationservice.UserDAO;
import csbase.server.services.administrationservice.UserIO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DefaultUserDAO
implements UserDAO {
    private UserIO userRepository = new UserIO();

    @Override
    public User createUser(UserInfo info) throws DAOException {
        User user;
        try {
            user = this.userRepository.write(info);
        }
        catch (Exception e) {
            throw new DAOException(e, info.getAttributes().toString());
        }
        if (user == null) {
            throw new DAOException("Falha em UserIO.write", info.getAttributes().toString());
        }
        return user;
    }

    @Override
    public User createStandardUser(String login, String password, Map<String, Serializable> attributes) {
        return null;
    }

    @Override
    public void deleteUser(Object id) throws DAOException {
        try {
            this.userRepository.delete(id);
        }
        catch (Exception e) {
            throw new DAOException(e, "id: " + id);
        }
    }

    @Override
    public User modifyUser(Object id, UserInfo info) throws DAOException {
        User user;
        try {
            user = this.userRepository.write(info);
        }
        catch (Exception e) {
            throw new DAOException(e, info.getAttributes().toString() + " - para o usu\u00e1rio: " + id);
        }
        if (user == null) {
            throw new DAOException("Falha em UserIO.write", info.getAttributes().toString() + " - para o usu\u00e1rio: " + id);
        }
        return user;
    }

    @Override
    public Set<Object> readAllUserIds() throws DAOException {
        try {
            Vector<User> users = this.userRepository.readAll();
            HashSet<Object> idSet = new HashSet<Object>();
            for (User user : users) {
                idSet.add(user.getId());
            }
            return idSet;
        }
        catch (Exception e) {
            throw new DAOException(e);
        }
    }

    @Override
    public List<UserOutline> readAllUserOutlines() throws DAOException {
        try {
            Vector<User> users = this.userRepository.readAll();
            Vector<UserOutline> outlines = new Vector<UserOutline>();
            for (User user : users) {
                outlines.add(user.getOutline());
            }
            return outlines;
        }
        catch (Exception e) {
            throw new DAOException(e);
        }
    }

    @Override
    public List<UserUpdate> readAllUserUpdates() throws DAOException {
        try {
            Vector<User> users = this.userRepository.readAll();
            Vector<UserUpdate> updates = new Vector<UserUpdate>();
            for (User user : users) {
                updates.add(new UserUpdate(user));
            }
            return updates;
        }
        catch (Exception e) {
            throw new DAOException(e);
        }
    }

    @Override
    public List<User> readAllUsers() throws DAOException {
        try {
            return this.userRepository.readAll();
        }
        catch (Exception e) {
            throw new DAOException(e);
        }
    }

    @Override
    public User readUser(Object id) throws DAOException {
        try {
            return this.userRepository.read(id);
        }
        catch (Exception e) {
            throw new DAOException(e, "id: " + id);
        }
    }

    @Override
    public User changeUser(User superuser, String delegatedLogin) throws DAOException {
        SuperUserPermission permission = (SuperUserPermission)superuser.getPermission(SuperUserPermission.class);
        if (!superuser.isAdmin() && permission == null) {
            throw new PermissionException("O usu\u00e1rio '" + superuser.getLogin() + "' n\u00e3o tem permiss\u00e3o de super-usu\u00e1rio");
        }
        User delegatedUser = this.readUser(delegatedLogin);
        if (delegatedUser == null) {
            String msg = "Login de usu\u00e1rio inexistente: '" + delegatedLogin + "'";
            throw new DAOException(msg, null);
        }
        if (delegatedUser.isAdmin()) {
            throw new PermissionException("O Administrador n\u00e3o pode ser delegado por um super-usu\u00e1rio");
        }
        if (!superuser.isAdmin()) {
            Map roleMap = permission.getAttributes();
            Set roleKeySet = roleMap.keySet();
            boolean hasRole = false;
            Iterator i = roleKeySet.iterator();
            block0: while (i.hasNext()) {
                Collection roleIds = (Collection)roleMap.get(i.next());
                for (Object id : roleIds) {
                    if (delegatedUser.getRole(id) == null) continue;
                    hasRole = true;
                    continue block0;
                }
            }
            if (!hasRole) {
                throw new PermissionException("O usu\u00e1rio '" + delegatedLogin + "' n\u00e3o tem o perfil necess\u00e1rio para autentica\u00e7\u00e3o por delega\u00e7\u00e3o de '" + superuser.getLogin() + "'");
            }
        }
        return delegatedUser;
    }
}

