/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice.v1_02;

import csbase.exception.CSBaseRuntimeException;
import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;
import csbase.logic.SyncRemoteFileChannel;
import csbase.logic.User;
import csbase.logic.UserProjectInfo;
import csbase.logic.filters.ProjectFileNameFilter;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.projectservice.ServerProject;
import csbase.server.services.projectservice.UpdatableFileInfo;
import csbase.server.services.projectservice.v1_02.DataValidation;
import csbase.server.services.projectservice.v1_02.FindService;
import csbase.server.services.projectservice.v1_02.OpenBusProjectFileUpdater;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.omg.CORBA.Any;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.exception.FileLockedException;
import tecgraf.ftc.common.exception.MaxClientsReachedException;
import tecgraf.ftc.common.logic.RemoteFileChannel;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.openbus.data_service.core.v1_02.AbsentViews;
import tecgraf.openbus.data_service.core.v1_02.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_02.DataAlreadyExist;
import tecgraf.openbus.data_service.core.v1_02.DataDescription;
import tecgraf.openbus.data_service.core.v1_02.DataKeyWrapper;
import tecgraf.openbus.data_service.core.v1_02.DataNotFound;
import tecgraf.openbus.data_service.core.v1_02.DataView;
import tecgraf.openbus.data_service.core.v1_02.DefaultView;
import tecgraf.openbus.data_service.core.v1_02.IDataService;
import tecgraf.openbus.data_service.core.v1_02.IDataServiceOperations;
import tecgraf.openbus.data_service.core.v1_02.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_02.Metadata;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;
import tecgraf.openbus.data_service.core.v1_02.UnavailableDataService;
import tecgraf.openbus.data_service.core.v1_02.UnstructuredDataView;
import tecgraf.openbus.data_service.core.v1_02.UnstructuredDataViewHelper;
import tecgraf.openbus.data_service.core.v1_02.UnstructuredDataViewImpl;
import tecgraf.openbus.data_service.core.v1_02.UnsupportedView;
import tecgraf.openbus.data_service.hierarchical.v1_02.HierarchicalNodeDataView;
import tecgraf.openbus.data_service.hierarchical.v1_02.HierarchicalNodeDataViewHelper;
import tecgraf.openbus.data_service.hierarchical.v1_02.HierarchicalNodeDataViewImpl;
import tecgraf.openbus.data_service.hierarchical.v1_02.IHierarchicalManagementDataServiceOperations;
import tecgraf.openbus.data_service.hierarchical.v1_02.IHierarchicalTransferDataServiceOperations;
import tecgraf.openbus.data_service.hierarchical.v1_02.InvalidContainer;
import tecgraf.openbus.data_service.hierarchical.v1_02.InvalidPrototype;
import tecgraf.openbus.data_service.hierarchical.v1_02.UnsupportedOperation;
import tecgraf.openbus.data_service.project.v1_02.IProjectNavigationDataServiceOperations;
import tecgraf.openbus.data_service.project.v1_02.InvalidOwner;
import tecgraf.openbus.data_service.project.v1_02.ProjectDataView;
import tecgraf.openbus.data_service.project.v1_02.ProjectDataViewFactory;
import tecgraf.openbus.data_service.project.v1_02.ProjectDataViewHelper;
import tecgraf.openbus.data_service.project.v1_02.ProjectDataViewImpl;
import tecgraf.openbus.data_service.project.v1_02.ProjectItemDataView;
import tecgraf.openbus.data_service.project.v1_02.ProjectItemDataViewFactory;
import tecgraf.openbus.data_service.project.v1_02.ProjectItemDataViewHelper;
import tecgraf.openbus.data_service.project.v1_02.ProjectItemDataViewImpl;

public class ProjectDataService
implements IHierarchicalManagementDataServiceOperations,
IHierarchicalTransferDataServiceOperations,
IProjectNavigationDataServiceOperations,
IDataServiceOperations {
    private static final DataDescription[] EMPTY_DATA_DESCRIPTION_ARRAY = new DataDescription[0];
    private static final String ABSOLUTE_PATH_METADATUM_NAME = "ABSOLUTE_PATH";
    protected String SourceId = ProjectService.getInstance().getSourceId();
    private static ProjectDataService instance;

    private ProjectDataService() {
        ORB orb = (ORB)OpenBusService.getInstance().getORB();
        orb.register_value_factory(ProjectDataViewHelper.id(), (ValueFactory)new ProjectDataViewFactory());
        orb.register_value_factory(ProjectItemDataViewHelper.id(), (ValueFactory)new ProjectItemDataViewFactory());
    }

    public static ProjectDataService getInstance() {
        if (instance == null) {
            instance = new ProjectDataService();
        }
        return instance;
    }

    public DataDescription[] getRoots() throws ServiceFailure, DataAccessDenied {
        Object userId = Service.getUser().getId();
        ProjectService projectService = ProjectService.getInstance();
        ArrayList<UserProjectInfo> projects = new ArrayList<UserProjectInfo>();
        try {
            projects.addAll(projectService.getProjectsFromUser(userId));
            projects.addAll(projectService.getProjectsSharedWithUser(userId));
        }
        catch (ServiceFailureException e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: erro ao obter as ra\u00edzes dos projetos: {1}", userLogin, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        if (projects.size() == 0) {
            return EMPTY_DATA_DESCRIPTION_ARRAY;
        }
        ArrayList<DataDescription> roots = new ArrayList<DataDescription>(projects.size());
        for (UserProjectInfo projectInfo : projects) {
            String projectName = projectInfo.getProjectName();
            try {
                CommonClientProject project = projectService.openProject(projectInfo.getProjectId(), false);
                ClientProjectFile rootFile = project.getRoot();
                try {
                    roots.add(this.createDataDescription(rootFile));
                }
                catch (InvalidDataKey e) {
                    String userLogin = Service.getUser().getLogin();
                    String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: erro ao criar descri\u00e7\u00e3o da ra\u00edz do projeto {1}: {2}", userLogin, projectName, e.getMessage());
                    Server.logSevereMessage(msg, e);
                    throw new ServiceFailure(msg);
                }
            }
            catch (ServiceFailureException e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: erro ao abrir o projeto {1} do usu\u00e1rio {2}: {3}", userLogin, projectName, projectInfo.getOwnerId(), e.getMessage());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
        }
        return roots.toArray(EMPTY_DATA_DESCRIPTION_ARRAY);
    }

    public DataDescription[] getChildren(byte[] fKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound {
        DataKeyWrapper dataKey = new DataKeyWrapper(fKey);
        DataValidation.checkDataKey(dataKey);
        ClientProjectFile parent = ProjectDataService.getProjectFile(dataKey);
        if (!parent.isDirectory()) {
            return EMPTY_DATA_DESCRIPTION_ARRAY;
        }
        ClientProjectFile[] children = null;
        try {
            children = parent.getChildren();
        }
        catch (RemoteException e) {
            String userLogin = Service.getUser().getLogin();
            String projectName = ServerProject.getProjectName(parent.getProjectId());
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: erro ao obter os fihos do dado {1} no projeto {2}: {3}", userLogin, parent.getName(), projectName, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        if (children == null) {
            return EMPTY_DATA_DESCRIPTION_ARRAY;
        }
        ArrayList<DataDescription> nodes = new ArrayList<DataDescription>(children.length);
        for (int i = 0; i < children.length; ++i) {
            try {
                nodes.add(this.createDataDescription(children[i]));
                continue;
            }
            catch (CSBaseRuntimeException e) {
                String msg = MessageFormat.format("Arquivo {0} exclu\u00eddo ap\u00f3s consulta dos filhos de {1}", children[i].getName(), parent.getName());
                Server.logFineMessage(msg);
            }
        }
        return nodes.toArray(EMPTY_DATA_DESCRIPTION_ARRAY);
    }

    public DataDescription getParent(byte[] fKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound {
        DataKeyWrapper dataKey = new DataKeyWrapper(fKey);
        DataValidation.checkDataKey(dataKey);
        ClientProjectFile file = ProjectDataService.getProjectFile(dataKey);
        if (file == null) {
            throw new DataNotFound("Dado n\u00e3o encontrado.", (byte[][])new byte[][]{fKey});
        }
        ClientProjectFile parent = file.getParent();
        if (parent == null) {
            return this.createEmptyDataDescription();
        }
        return this.createDataDescription(parent);
    }

    public ProjectDataView[] getProject(String fOwner) throws DataAccessDenied, ServiceFailure, InvalidOwner {
        Object owner;
        try {
            owner = User.getUserByLogin((String)fOwner).getId();
        }
        catch (Exception e) {
            throw new InvalidOwner("Erro ao obter informa\u00e7\u00f5es do usu\u00e1rio dono.");
        }
        if (owner == null) {
            throw new InvalidOwner("Usu\u00e1rio dono n\u00e3o existe.");
        }
        ProjectService projectService = ProjectService.getInstance();
        Object userId = Service.getUser().getId();
        ArrayList<UserProjectInfo> projects = new ArrayList<UserProjectInfo>();
        if (userId.equals(owner)) {
            projects.addAll(projectService.getProjectsFromUser(userId));
        } else {
            projects.addAll(projectService.getProjectsSharedWithUser(userId));
        }
        ArrayList<ProjectDataView> projectsView = new ArrayList<ProjectDataView>();
        for (UserProjectInfo prjInfo : projects) {
            if (!prjInfo.getOwnerId().equals(fOwner)) continue;
            try {
                projectsView.add(this.createProjectDataView(prjInfo.getProjectId()));
            }
            catch (InvalidDataKey e) {
                String userLogin = Service.getUser().getLogin();
                String projectName = ServerProject.getProjectName(prjInfo.getProjectId());
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: erro ao criar a vis\u00e3o ProjectDataView do projeto {1}: {2}", userLogin, projectName, e.getMessage());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
        }
        return projectsView.toArray(new ProjectDataView[0]);
    }

    public DataDescription getDataDescription(byte[] fKey) throws ServiceFailure, InvalidDataKey, DataNotFound, DataAccessDenied {
        DataKeyWrapper dataKey = new DataKeyWrapper(fKey);
        DataValidation.checkDataKey(dataKey);
        ClientProjectFile file = ProjectDataService.getProjectFile(dataKey);
        return this.createDataDescription(file);
    }

    public DataView getDataView(byte[] fKey, String fViewInterface) throws ServiceFailure, InvalidDataKey, DataNotFound, UnsupportedView, DataAccessDenied {
        DataKeyWrapper dataKey = new DataKeyWrapper(fKey);
        DataValidation.checkDataKey(dataKey);
        ClientProjectFile file = ProjectDataService.getProjectFile(dataKey);
        if (file == null) {
            throw new DataNotFound("Dado n\u00e3o encontrado.", (byte[][])new byte[][]{dataKey.getKey()});
        }
        return this.createDataView(file, fViewInterface);
    }

    public DataView[] getDataViewSeq(byte[][] fKeys, String fViewInterface) throws ServiceFailure, InvalidDataKey, DataNotFound, UnsupportedView, DataAccessDenied {
        LinkedList<DataView> viewList = new LinkedList<DataView>();
        LinkedList<byte[]> InvalidDataKeyList = new LinkedList<byte[]>();
        LinkedList<byte[]> DataNotFoundList = new LinkedList<byte[]>();
        LinkedList<byte[]> UnsupportedViewList = new LinkedList<byte[]>();
        LinkedList<byte[]> DataAccessDeniedList = new LinkedList<byte[]>();
        for (byte[] key : fKeys) {
            try {
                viewList.add(this.getDataView(key, fViewInterface));
            }
            catch (InvalidDataKey e) {
                for (byte[] k : e.fKeys) {
                    InvalidDataKeyList.add(k);
                }
            }
            catch (DataNotFound e) {
                for (byte[] k : e.fKeys) {
                    DataNotFoundList.add(k);
                }
            }
            catch (UnsupportedView e) {
                for (byte[] k : e.fKeys) {
                    UnsupportedViewList.add(k);
                }
            }
            catch (DataAccessDenied e) {
                for (byte[] k : e.fKeys) {
                    DataAccessDeniedList.add(k);
                }
            }
        }
        if (!InvalidDataKeyList.isEmpty()) {
            throw new InvalidDataKey("Chaves dos dados s\u00e3o inv\u00e1lidas.", (byte[][])InvalidDataKeyList.toArray((T[])new byte[0][]));
        }
        if (!DataNotFoundList.isEmpty()) {
            throw new DataNotFound("Dados n\u00e3o encontrados.", (byte[][])DataNotFoundList.toArray((T[])new byte[0][]));
        }
        if (!UnsupportedViewList.isEmpty()) {
            throw new UnsupportedView("Vis\u00e3o n\u00e3o suportada pelos dados.", (byte[][])UnsupportedViewList.toArray((T[])new byte[0][]));
        }
        if (!DataAccessDeniedList.isEmpty()) {
            throw new DataAccessDenied("Usu\u00e1rio solicitante n\u00e3o tem permiss\u00e3o de acesso aos dados.", (byte[][])DataAccessDeniedList.toArray((T[])new byte[0][]));
        }
        return viewList.toArray(new DataView[0]);
    }

    public byte[] createData(DataDescription fPrototype, byte[] fParentKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound, DataAlreadyExist, InvalidPrototype, InvalidContainer, UnsupportedOperation {
        DataKeyWrapper key1;
        DataKeyWrapper parentKey = new DataKeyWrapper(fParentKey);
        DataValidation.checkDataKey(parentKey);
        ClientProjectFile parent = ProjectDataService.getProjectFile(parentKey);
        if (parent == null) {
            throw new DataNotFound("Dado n\u00e3o encontrado.", (byte[][])new byte[][]{parentKey.getKey()});
        }
        if (!parent.isDirectory()) {
            String msg = MessageFormat.format("Dado n\u00e3o \u00e9 um diret\u00f3rio.", parent.getName());
            throw new InvalidContainer(msg, (byte[][])new byte[][]{fParentKey});
        }
        if (fPrototype.fName == null || fPrototype.fName.length() == 0) {
            throw new InvalidPrototype("O prot\u00f3tipo n\u00e3o tem o campo fName preenchido. Na cria\u00e7\u00e3o de dado este \u00e9 um campo obrigat\u00f3rio.");
        }
        if (fPrototype.fDefaultView == null) {
            throw new InvalidPrototype("O prot\u00f3tipo n\u00e3o tem vis\u00e3o padr\u00e3o. Na cria\u00e7\u00e3o de dado este \u00e9 um campo obrigat\u00f3rio.");
        }
        if (!fPrototype.fDefaultView.fInterfaceName.equals(ProjectItemDataViewHelper.id())) {
            throw new InvalidPrototype("O prot\u00f3tipo n\u00e3o tem a vis\u00e3o padr\u00e3o do tipo ProjectItemDataView. Na cria\u00e7\u00e3o de dado esta deve ser a vis\u00e3o padr\u00e3o.");
        }
        ProjectItemDataView prototypeProjItemDataView = (ProjectItemDataView)ProjectItemDataView.class.cast(fPrototype.fDefaultView.fValue);
        try {
            if (parent.getChild(fPrototype.fName) != null) {
                String msg = MessageFormat.format("Dado {0} j\u00e1 existe no diret\u00f3rio {1}.", fPrototype.fName, parent.getName());
                throw new DataAlreadyExist(msg);
            }
            if (prototypeProjItemDataView.fIsContainer) {
                parent.createFile(fPrototype.fName, "DIRECTORY_TYPE");
            } else {
                parent.createFile(fPrototype.fName, prototypeProjItemDataView.fType);
            }
        }
        catch (RemoteException e) {
            String userLogin = Service.getUser().getLogin();
            String projectName = ServerProject.getProjectName(parent.getProjectId());
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao criar o dado {1} no projeto {2}: {3}", userLogin, fPrototype.fName, projectName, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (ServiceFailureException e) {
            String userLogin = Service.getUser().getLogin();
            String projectName = ServerProject.getProjectName(parent.getProjectId());
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao criar o dado {1} no projeto {2}: {3}", userLogin, fPrototype.fName, projectName, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        String dataId = ProjectDataService.generateDataId(parent, fPrototype.fName);
        DataKeyWrapper key = key1 = this.generateDataKey(dataId);
        return key.getKey();
    }

    public byte[] copyData(byte[] fSourceKey, byte[] fParentKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound, DataAlreadyExist, InvalidContainer, UnsupportedOperation {
        DataKeyWrapper parentKey = new DataKeyWrapper(fParentKey);
        DataValidation.checkDataKey(parentKey);
        ClientProjectFile parent = ProjectDataService.getProjectFile(parentKey);
        DataKeyWrapper sourceKey = new DataKeyWrapper(fSourceKey);
        DataValidation.checkDataKey(sourceKey);
        ClientProjectFile source = ProjectDataService.getProjectFile(sourceKey);
        if (!parent.isDirectory()) {
            String msg = MessageFormat.format("Dado n\u00e3o \u00e9 um diret\u00f3rio.", parent.getName());
            throw new InvalidContainer(msg, (byte[][])new byte[][]{fParentKey});
        }
        try {
            if (parent.getChild(source.getName()) != null) {
                String msg = MessageFormat.format("Dado {0} j\u00e1 existe no diret\u00f3rio {1}.", source.getName(), parent.getName());
                throw new DataAlreadyExist(msg);
            }
            source.copy(parent);
        }
        catch (RemoteException e) {
            String userLogin = Service.getUser().getLogin();
            String projectName = ServerProject.getProjectName(parent.getProjectId());
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao copiar o dado {1} para o diret\u00f3rio {2} dentro do projeto {3}: {4}", userLogin, source.getName(), parent.getName(), projectName, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (PermissionException e) {
            throw new DataAccessDenied("Usu\u00e1rio solicitante n\u00e3o tem permiss\u00e3o de acesso ao dado.", (byte[][])new byte[][]{fParentKey});
        }
        String dataId = ProjectDataService.generateDataId(parent, source.getName());
        DataKeyWrapper dataKey = this.generateDataKey(dataId);
        return dataKey.getKey();
    }

    public void moveData(byte[] fKey, byte[] fNewParentKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound, DataAlreadyExist, InvalidContainer, UnsupportedOperation {
        DataKeyWrapper dataKey = new DataKeyWrapper(fKey);
        DataValidation.checkDataKey(dataKey);
        DataKeyWrapper newParentKey = new DataKeyWrapper(fNewParentKey);
        DataValidation.checkDataKey(newParentKey);
        ClientProjectFile file = ProjectDataService.getProjectFile(dataKey);
        ClientProjectFile newParent = ProjectDataService.getProjectFile(newParentKey);
        if (!newParent.isDirectory()) {
            String msg = MessageFormat.format("Dado n\u00e3o \u00e9 um diret\u00f3rio.", newParent.getName());
            throw new InvalidContainer(msg, (byte[][])new byte[][]{fNewParentKey});
        }
        try {
            if (newParent.getChild(file.getName()) != null) {
                String msg = MessageFormat.format("Dado {0} j\u00e1 existe no diret\u00f3rio {1}.", file.getName(), newParent.getName());
                throw new DataAlreadyExist(msg);
            }
            file.move(newParent);
        }
        catch (RemoteException e) {
            String userLogin = Service.getUser().getLogin();
            String projectName = ServerProject.getProjectName(newParent.getProjectId());
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao mover o dado {1} para o diret\u00f3rio {2} dentro do projeto {3}: {4}", userLogin, file.getName(), newParent.getName(), projectName, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (PermissionException e) {
            throw new DataAccessDenied("Usu\u00e1rio solicitante n\u00e3o tem permiss\u00e3o de acesso ao dado.", (byte[][])new byte[][]{fNewParentKey});
        }
    }

    public void updateData(byte[] fKey, byte[] fSourceKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound, AbsentViews {
        DataKeyWrapper dataKey = new DataKeyWrapper(fKey);
        DataValidation.checkDataKey(dataKey);
        DataKeyWrapper sourceKey = new DataKeyWrapper(fSourceKey);
        DataValidation.checkDataKey(sourceKey);
        ClientProjectFile destFile = ProjectDataService.getProjectFile(dataKey);
        ClientProjectFile sourceFile = ProjectDataService.getProjectFile(sourceKey);
        if (sourceFile.equals((Object)destFile)) {
            return;
        }
        Object projectId = destFile.getProjectId();
        String[] path = destFile.getPath();
        try (BufferedOutputStream out = new BufferedOutputStream(ProjectService.getInstance().getOutputStream(projectId, path));){
            sourceFile.download((OutputStream)out, 8192L, null);
        }
        catch (csbase.exception.project.FileLockedException e) {
            String userLogin = Service.getUser().getLogin();
            String projectName = ServerProject.getProjectName(destFile.getProjectId());
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado {1} dentro do projeto {2}: o dado est\u00e1 bloqueado: {3}", userLogin, destFile.getName(), projectName, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (IOException e) {
            String userLogin = Service.getUser().getLogin();
            String projectName = ServerProject.getProjectName(destFile.getProjectId());
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado {1} dentro do projeto {2}: {3}", userLogin, destFile.getName(), projectName, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (PermissionException e) {
            throw new DataAccessDenied("Usu\u00e1rio solicitante n\u00e3o tem permiss\u00e3o de acesso ao dado.", (byte[][])new byte[][]{fKey});
        }
    }

    public void deleteData(byte[] fKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound, UnsupportedOperation {
        DataKeyWrapper dataKey = new DataKeyWrapper(fKey);
        DataValidation.checkDataKey(dataKey);
        ClientProjectFile file = ProjectDataService.getProjectFile(dataKey);
        if (file.getParent() == null) {
            ProjectService.getInstance().removeProject(file.getProjectId());
        } else {
            try {
                file.remove();
            }
            catch (RemoteException e) {
                String userLogin = Service.getUser().getLogin();
                String projectName = ServerProject.getProjectName(file.getProjectId());
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao remover o dado {1} dentro do projeto {2}: {3}", userLogin, file.getName(), projectName, e.getMessage());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            catch (PermissionException e) {
                throw new DataAccessDenied("Usu\u00e1rio solicitante n\u00e3o tem permiss\u00e3o de acesso ao dado.", (byte[][])new byte[][]{fKey});
            }
        }
    }

    public byte[] copyDataFrom(byte[] fSourceKey, byte[] fParentKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound, AbsentViews, UnavailableDataService, DataAlreadyExist, InvalidContainer, UnsupportedOperation {
        DataKeyWrapper parentKey = new DataKeyWrapper(fParentKey);
        DataValidation.checkDataKey(parentKey);
        DataKeyWrapper sourceDataKey = new DataKeyWrapper(fSourceKey);
        try {
            DataValidation.checkDataKey(sourceDataKey);
            return this.copyData(fSourceKey, fParentKey);
        }
        catch (DataNotFound dataNotFound) {
            OpenBusService.getInstance().joinChain();
            try {
                DataDescription parentDescription = this.getDataDescription(fParentKey);
                String parentAbsolutePath = null;
                for (int i = 0; i < parentDescription.fMetadata.length; ++i) {
                    if (!parentDescription.fMetadata[i].fName.equals(ABSOLUTE_PATH_METADATUM_NAME)) continue;
                    Any any = parentDescription.fMetadata[i].fValue;
                    parentAbsolutePath = any.extract_string();
                }
                IDataService sourceDataService = FindService.find(sourceDataKey);
                if (sourceDataService == null) {
                    String userLogin = Service.getUser().getLogin();
                    String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao copiar o dado: servi\u00e7o de dados da origem n\u00e3o dispon\u00edvel: {1} {2}", userLogin, sourceDataKey.getSystemDeploymentId(), sourceDataKey.getDataSourceId());
                    Server.logWarningMessage(msg);
                    throw new UnavailableDataService(msg);
                }
                DataDescription sourceDataDescription = sourceDataService.getDataDescription(fSourceKey);
                ProjectItemDataView sourceProjItemDataView = (ProjectItemDataView)ProjectItemDataView.class.cast(sourceDataService.getDataView(fSourceKey, ProjectItemDataViewHelper.id()));
                String absolutePath = parentAbsolutePath + "/" + sourceDataDescription.fName;
                Metadata[] metadata = ProjectDataService.createMetadataList(absolutePath);
                long date = System.currentTimeMillis();
                String userLogin = Service.getUser().getLogin();
                ProjectItemDataViewImpl prototypeProjItemDataView = new ProjectItemDataViewImpl(null, userLogin, sourceProjItemDataView.fDescription, absolutePath, sourceProjItemDataView.fType, 0L, sourceProjItemDataView.fIsContainer, sourceProjItemDataView.fCanRead, sourceProjItemDataView.fCanWrite, date, date);
                DefaultView defaultView = new DefaultView(ProjectItemDataViewHelper.id(), (DataView)prototypeProjItemDataView);
                DataDescription prototype = new DataDescription(null, sourceDataDescription.fName, defaultView, null, metadata);
                byte[] key = this.createData(prototype, fParentKey);
                this.updateDataFrom(key, fSourceKey);
                byte[] byArray = key;
                return byArray;
            }
            catch (ServiceFailure e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao copiar o dado: {1}", userLogin, e.fMessage);
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            catch (InvalidPrototype e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao copiar o dado: prot\u00f3tipo inv\u00e1lido: {1}", userLogin, e.fMessage);
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            catch (UnsupportedView e) {
                throw new AbsentViews("Vis\u00e3o n\u00e3o suportada pelo dado.", e.fKeys, new String[]{ProjectItemDataViewHelper.id()});
            }
            finally {
                OpenBusService.getInstance().exitChain();
            }
        }
    }

    private static String[] createViewSet(boolean container, boolean root) {
        HashSet<String> views = new HashSet<String>();
        if (!container) {
            views.add(UnstructuredDataViewHelper.id());
        }
        if (root) {
            views.add(ProjectItemDataViewHelper.id());
        }
        views.add(HierarchicalNodeDataViewHelper.id());
        return views.toArray(new String[0]);
    }

    private static Metadata[] createMetadataList(String absolutePath) {
        ArrayList<Metadata> metadataList = new ArrayList<Metadata>();
        org.omg.CORBA.ORB orb = OpenBusService.getInstance().getORB();
        if (absolutePath != null) {
            Any any = orb.create_any();
            any.insert_string(absolutePath);
            metadataList.add(new Metadata(ABSOLUTE_PATH_METADATUM_NAME, any));
        }
        return metadataList.toArray(new Metadata[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateDataFrom(byte[] fKey, byte[] fSourceKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound, UnavailableDataService, AbsentViews {
        DataKeyWrapper dataKey = new DataKeyWrapper(fKey);
        DataValidation.checkDataKey(dataKey);
        DataKeyWrapper sourceDataKey = new DataKeyWrapper(fSourceKey);
        ClientProjectFile file = ProjectDataService.getProjectFile(dataKey);
        OpenBusService.getInstance().joinChain();
        if (dataKey.getSystemDeploymentId().equals(sourceDataKey.getSystemDeploymentId()) && dataKey.getDataSourceId().equals(sourceDataKey.getDataSourceId()) && dataKey.getDataId().equals(sourceDataKey.getDataId())) {
            return;
        }
        try {
            DataValidation.checkDataKey(sourceDataKey);
            this.updateData(fKey, fSourceKey);
            return;
        }
        catch (DataNotFound dataNotFound) {
            SyncRemoteFileChannel sourceChannel;
            SyncRemoteFileChannel channel;
            UnstructuredDataView view;
            UnstructuredDataView sourceView;
            IDataService sourceDataService = FindService.find(sourceDataKey);
            if (sourceDataService == null) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao copiar o dado: servi\u00e7o de dados da origem n\u00e3o dispon\u00edvel: {1} {2}", userLogin, sourceDataKey.getSystemDeploymentId(), sourceDataKey.getDataSourceId());
                Server.logWarningMessage(msg);
                throw new UnavailableDataService(msg);
            }
            try {
                sourceView = (UnstructuredDataView)UnstructuredDataView.class.cast(sourceDataService.getDataView(sourceDataKey.getKey(), UnstructuredDataViewHelper.id()));
            }
            catch (UnsupportedView e) {
                throw new AbsentViews("Vis\u00e3o n\u00e3o suportada pelo dado.", e.fKeys, new String[]{UnstructuredDataViewHelper.id()});
            }
            try {
                view = (UnstructuredDataView)UnstructuredDataView.class.cast(this.createDataView(file, UnstructuredDataViewHelper.id()));
            }
            catch (UnsupportedView e) {
                throw new AbsentViews("Vis\u00e3o n\u00e3o suportada pelo dado.", e.fKeys, new String[]{UnstructuredDataViewHelper.id()});
            }
            try {
                channel = new SyncRemoteFileChannel(dataKey.getDataId().getBytes("UTF8"), view.fWritable, view.fHost, view.fPort, view.fAccessKey);
            }
            catch (UnsupportedEncodingException e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: erro ao converter o identificador do dado de destino ({1}) para bytes.", userLogin, dataKey.getDataId());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            try {
                sourceChannel = new SyncRemoteFileChannel(sourceDataKey.getDataId().getBytes("UTF8"), sourceView.fWritable, sourceView.fHost, sourceView.fPort, sourceView.fAccessKey);
            }
            catch (UnsupportedEncodingException e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: erro ao converter o identificador do dado de origem ({1}) para bytes.", userLogin, sourceDataKey.getDataId());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            try {
                channel.open(false);
            }
            catch (tecgraf.ftc.common.exception.PermissionException e) {
                Server.logWarningMessage(e.getMessage());
                throw new DataAccessDenied("Usu\u00e1rio solicitante n\u00e3o tem permiss\u00e3o de acesso ao dado.", (byte[][])new byte[][]{fKey});
            }
            catch (FileNotFoundException e) {
                Server.logWarningMessage(e.getMessage());
                throw new DataNotFound("Dado n\u00e3o encontrado.", (byte[][])new byte[][]{fKey});
            }
            catch (FailureException e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: falha na transfer\u00eancia do arquivo: {1}", userLogin, e.getMessage());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            catch (MaxClientsReachedException e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: quantidade m\u00e1xima de clientes atingida: {1}", userLogin, e.getMessage());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            try {
                sourceChannel.open(true);
            }
            catch (tecgraf.ftc.common.exception.PermissionException e) {
                Server.logWarningMessage(e.getMessage());
                throw new DataAccessDenied("Usu\u00e1rio solicitante n\u00e3o tem permiss\u00e3o de acesso ao dado.", (byte[][])new byte[][]{fSourceKey});
            }
            catch (FileNotFoundException e) {
                Server.logWarningMessage(e.getMessage());
                throw new DataNotFound("Dado n\u00e3o encontrado.", (byte[][])new byte[][]{fSourceKey});
            }
            catch (FailureException e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: falha na transfer\u00eancia do arquivo: {1}", userLogin, e.getMessage());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            catch (MaxClientsReachedException e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: quantidade m\u00e1xima de clientes atingida: {1}", userLogin, e.getMessage());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            try {
                ProjectItemDataView sourceProjectView = (ProjectItemDataView)sourceDataService.getDataView(sourceDataKey.getKey(), ProjectItemDataViewHelper.id());
                channel.syncTransferFrom((RemoteFileChannel)sourceChannel, 0L, sourceProjectView.fSize);
                channel.setSize(sourceProjectView.fSize);
            }
            catch (tecgraf.ftc.common.exception.PermissionException e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: arquivo aberto somente para escrita: {1}", userLogin, e.getMessage());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            catch (FailureException e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: falha na transfer\u00eancia do arquivo: {1}", userLogin, e.getMessage());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            catch (FileLockedException e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: arquivo bloqueado para escrita: {1}", userLogin, e.getMessage());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            catch (UnsupportedView e) {
                throw new AbsentViews("Vis\u00e3o n\u00e3o suportada pelo dado.", e.fKeys, new String[]{ProjectItemDataViewHelper.id()});
            }
            finally {
                block52: {
                    OpenBusService.getInstance().exitChain();
                    channel.close();
                    try {
                        sourceChannel.close();
                    }
                    catch (FailureException failureException) {}
                    break block52;
                    catch (FailureException failureException) {
                        try {
                            sourceChannel.close();
                        }
                        catch (FailureException failureException2) {}
                        break block52;
                        catch (Throwable throwable) {
                            try {
                                sourceChannel.close();
                            }
                            catch (FailureException failureException3) {}
                            throw throwable;
                        }
                    }
                }
            }
            if (!ProjectService.getInstance().setUpdatableFileInfo(file, new UpdatableFileInfo(OpenBusProjectFileUpdater.class, (Serializable)sourceDataKey.getKey()))) {
                Server.logWarningMessage(MessageFormat.format("A informa\u00e7\u00e3o sobre atualiza\u00e7\u00e3o do arquivo {0} n\u00e3o foi definida", file.getStringPath()));
            }
            return;
        }
    }

    public void updateDataFrom(Object projectId, String[] pathArray, byte[] fSourceKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound, UnavailableDataService, AbsentViews {
        String dataId = ProjectDataService.generateDataId(projectId, pathArray);
        DataKeyWrapper dataKey = this.generateDataKey(dataId);
        this.updateDataFrom(dataKey.getKey(), fSourceKey);
    }

    public static ClientProjectFile getProjectFile(DataKeyWrapper dataKey) throws InvalidDataKey, ServiceFailure, DataNotFound, DataAccessDenied {
        CommonClientProject project;
        String dataId = dataKey.getDataId();
        String[] splittedKey = dataId.split("@/@");
        if (splittedKey.length < 1) {
            throw new InvalidDataKey("Chave do dado \u00e9 inv\u00e1lida.", (byte[][])new byte[][]{dataKey.getKey()});
        }
        String projectId = splittedKey[0];
        if (!ProjectService.getInstance().existsProject(projectId)) {
            throw new DataNotFound("Dado n\u00e3o encontrado.", (byte[][])new byte[][]{dataKey.getKey()});
        }
        Object userId = Service.getUser().getId();
        if (!ProjectService.getInstance().userHasAccess(projectId, userId)) {
            throw new DataAccessDenied("Usu\u00e1rio solicitante " + userId + " n\u00e3o tem acesso ao dado.", (byte[][])new byte[][]{dataKey.getKey()});
        }
        try {
            project = ProjectService.getInstance().openProject(projectId, false);
        }
        catch (ServiceFailureException e) {
            String userLogin = Service.getUser().getLogin();
            String projectName = ServerProject.getProjectName(projectId);
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: erro ao abrir o projeto {1}: {2}", userLogin, projectName, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        if (splittedKey.length == 1) {
            ClientProjectFile file = project.getRoot();
            if (file == null) {
                throw new DataNotFound("Dado n\u00e3o encontrado.", (byte[][])new byte[][]{dataKey.getKey()});
            }
            return file;
        }
        String[] filePath = new String[splittedKey.length - 1];
        for (int i = 0; i < filePath.length; ++i) {
            filePath[i] = splittedKey[i + 1];
        }
        try {
            ClientProjectFile file = project.getFile(filePath);
            if (file == null) {
                throw new DataNotFound("Dado n\u00e3o encontrado.", (byte[][])new byte[][]{dataKey.getKey()});
            }
            return file;
        }
        catch (RemoteException e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: erro ao obter o arquivo {1}: {2}", userLogin, filePath, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
    }

    private static String generateDataId(ClientProjectFile file) {
        return ProjectDataService.generateDataId(file.getProjectId(), file.getPath());
    }

    private static String generateDataId(Object projectId, String[] pathArray) {
        String dataId = (String)projectId;
        for (String path : pathArray) {
            dataId = dataId + "@/@" + path;
        }
        return dataId;
    }

    private static String generateDataId(ClientProjectFile parent, String childName) {
        String dataId = ProjectDataService.generateDataId(parent);
        dataId = dataId + "@/@" + childName;
        return dataId;
    }

    private DataKeyWrapper generateDataKey(String dataId) throws InvalidDataKey {
        String systemDeploymentId = OpenBusService.getInstance().getEntityName();
        DataKeyWrapper dataKey = new DataKeyWrapper(systemDeploymentId, this.SourceId, dataId);
        return dataKey;
    }

    private DataDescription createDataDescription(ClientProjectFile file) throws InvalidDataKey, ServiceFailure {
        DefaultView defaultView;
        try {
            defaultView = this.createDefaultDataView(file);
        }
        catch (UnsupportedView e) {
            String userLogin = Service.getUser().getLogin();
            String projectName = ServerProject.getProjectName(file.getProjectId());
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: erro ao criar descri\u00e7\u00e3o do dado {1} do projeto {2}: {3}", userLogin, file.getName(), projectName, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        String[] othersViews = ProjectDataService.createViewSet(file.isDirectory(), file.isRoot());
        Metadata[] metadata = ProjectDataService.createMetadataList(file.getStringPath());
        return new DataDescription(defaultView.fValue.getKey(), file.getName(), defaultView, othersViews, metadata);
    }

    private DataView createDataView(ClientProjectFile file, String viewInterface) throws UnsupportedView, ServiceFailure, InvalidDataKey {
        if (viewInterface.equals(UnstructuredDataViewHelper.id())) {
            return this.createUnstructuredDataView(file);
        }
        if (viewInterface.equals(HierarchicalNodeDataViewHelper.id())) {
            return this.createHierarchicalNodeDataView(file);
        }
        if (viewInterface.equals(ProjectItemDataViewHelper.id())) {
            return this.createProjectItemDataView(file);
        }
        if (viewInterface.equals(ProjectDataViewHelper.id())) {
            return this.createProjectDataView(file);
        }
        String dataIdString = ProjectDataService.generateDataId(file);
        DataKeyWrapper dataKey = this.generateDataKey(dataIdString);
        throw new UnsupportedView("Vis\u00e3o n\u00e3o suportada.", (byte[][])new byte[][]{dataKey.getKey()});
    }

    private UnstructuredDataView createUnstructuredDataView(ClientProjectFile file) throws UnsupportedView, ServiceFailure, InvalidDataKey {
        String dataIdString = ProjectDataService.generateDataId(file);
        DataKeyWrapper dataKey = this.generateDataKey(dataIdString);
        if (file.isDirectory()) {
            throw new UnsupportedView("Vis\u00e3o n\u00e3o suportada por diret\u00f3rios.", (byte[][])new byte[][]{dataKey.getKey()});
        }
        ProjectService prjSrv = ProjectService.getInstance();
        try {
            RemoteFileChannelInfo accessInfo = prjSrv.createFileChannelInfo(file);
            return new UnstructuredDataViewImpl(dataKey.getKey(), accessInfo.getHost(), accessInfo.getPort(), accessInfo.getKey(), true);
        }
        catch (PermissionException e) {
            String userLogin = Service.getUser().getLogin();
            String projectName = ServerProject.getProjectName(file.getProjectId());
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: erro ao criar vis\u00e3o n\u00e3o estruturada do dado {1} do projeto {2}: usu\u00e1rio sem permiss\u00e3o.", userLogin, file.getName(), projectName);
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (Exception e) {
            String userLogin = Service.getUser().getLogin();
            String projectName = ServerProject.getProjectName(file.getProjectId());
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: erro ao criar vis\u00e3o n\u00e3o estruturada do dado {1} do projeto {2}: {3}", userLogin, file.getName(), projectName, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
    }

    private HierarchicalNodeDataView createHierarchicalNodeDataView(ClientProjectFile file) throws InvalidDataKey {
        String dataIdString = ProjectDataService.generateDataId(file);
        DataKeyWrapper dataKey = this.generateDataKey(dataIdString);
        ClientProjectFile parent = file.getParent();
        if (parent != null) {
            String parentDataIdString = ProjectDataService.generateDataId(parent);
            DataKeyWrapper parentDataKey = this.generateDataKey(parentDataIdString);
            return new HierarchicalNodeDataViewImpl(dataKey.getKey(), parentDataKey.getKey(), file.isDirectory());
        }
        return new HierarchicalNodeDataViewImpl(dataKey.getKey(), new byte[0], file.isDirectory());
    }

    private DefaultView createDefaultDataView(ClientProjectFile file) throws InvalidDataKey, UnsupportedView, ServiceFailure {
        if (file.isRoot()) {
            return new DefaultView(ProjectDataViewHelper.id(), (DataView)this.createProjectDataView(file));
        }
        return new DefaultView(ProjectItemDataViewHelper.id(), (DataView)this.createProjectItemDataView(file));
    }

    private ProjectItemDataView createProjectItemDataView(ClientProjectFile file) throws InvalidDataKey {
        String description = null;
        try {
            description = file.getDescription();
        }
        catch (RemoteException e) {
            Server.logWarningMessage(MessageFormat.format("Erro ao obter a descri\u00e7\u00e3o do arquivo {0}.", file.getStringPath()));
        }
        String dataIdString = ProjectDataService.generateDataId(file);
        DataKeyWrapper dataKey = this.generateDataKey(dataIdString);
        String[] pathArray = file.getPath();
        String path = (String)file.getProjectId();
        for (int i = 0; i < pathArray.length; ++i) {
            path = path + "/" + pathArray[i];
        }
        String owner = (String)file.whoCreated();
        if (owner == null) {
            owner = "";
        }
        if (description == null) {
            description = "";
        }
        return new ProjectItemDataViewImpl(dataKey.getKey(), owner, description, path, file.getType(), file.size(), file.isDirectory(), file.canRead(), file.canWrite(), file.getCreationDate(), file.getModificationDate());
    }

    private ProjectDataView createProjectDataView(ClientProjectFile file) throws InvalidDataKey, UnsupportedView, ServiceFailure {
        if (!file.isRoot()) {
            String dataIdString = ProjectDataService.generateDataId(file);
            DataKeyWrapper dataKey = this.generateDataKey(dataIdString);
            throw new UnsupportedView("Vis\u00e3o somente suportada por dados ra\u00edzes de projetos.", (byte[][])new byte[][]{dataKey.getKey()});
        }
        Object projectId = file.getProjectId();
        return this.createProjectDataView(projectId);
    }

    private ProjectDataView createProjectDataView(Object projectId) throws InvalidDataKey, ServiceFailure {
        ProjectService prjService = ProjectService.getInstance();
        CommonClientProject clientProject = prjService.openProject(projectId, false);
        Set userRO = clientProject.getUsersRO();
        Set userRW = clientProject.getUsersRW();
        HashSet readingUsers = new HashSet(userRO.size());
        for (Object user : userRO) {
            readingUsers.add(String.class.cast(user));
        }
        HashSet writingUsers = new HashSet(userRW.size());
        for (Object user : userRW) {
            writingUsers.add(String.class.cast(user));
        }
        String dataId = ProjectDataService.generateDataId(clientProject.getRoot());
        DataKeyWrapper dataKey = this.generateDataKey(dataId);
        String path = (String)clientProject.getId();
        long projectSize = clientProject.getRoot().getLocalTotalSize((ProjectFileFilter)new ProjectFileNameFilter(""));
        return new ProjectDataViewImpl(dataKey.getKey(), (String)clientProject.getUserId(), clientProject.getDescription() != null ? clientProject.getDescription() : "", path, clientProject.getOwnerServerName(), projectSize, readingUsers, writingUsers, clientProject.getCreationDate(), clientProject.getLastModificationDate());
    }

    private DataDescription createEmptyDataDescription() {
        DataDescription emptyDataDescription = new DataDescription();
        emptyDataDescription.fKey = new byte[0];
        emptyDataDescription.fName = "";
        emptyDataDescription.fDefaultView = new DefaultView();
        emptyDataDescription.fOthersViews = new String[0];
        emptyDataDescription.fMetadata = new Metadata[0];
        return emptyDataDescription;
    }
}

