package csbase.server.services.schedulerservice.heuristic;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;

import csbase.logic.CommandInfo;
import csbase.logic.Priority;
import csbase.logic.SGASet;

public class AllocationComparatorByPriority implements Comparator<Allocation> {

	@Override
	public int compare(Allocation o1, Allocation o2) {
		if (o1.isFeasible() && !o2.isFeasible())
			return 1;
		if (!o1.isFeasible() && o2.isFeasible())
			return -1;
		
		Map<CommandInfo, SGASet> map1 = o1.getPartialAllocationMap();
		Map<CommandInfo, SGASet> map2 = o2.getPartialAllocationMap();
		
		if (map1.isEmpty() && map2.isEmpty())
			return 0;
		if (map1.isEmpty())
			return -1;
		if (map2.isEmpty())
			return 1;
		
		// calcula nmero de jobs de cada prioridade:
		int[] oldNumJobs = createPriorityArray(map1.keySet());
		int[] newNumJobs = createPriorityArray(map2.keySet());

		for (int i = 0; i < oldNumJobs.length; i++) {
			if (oldNumJobs[i] > newNumJobs[i])
				return 1;
			if (oldNumJobs[i] < newNumJobs[i])
				return -1;
		}
		return 0;
	}
	
	private int[] createPriorityArray(Set<CommandInfo> commands) {
		Priority[] priorityValues = Priority.values();
		int[] priorityCounter = new int[priorityValues.length];
		for (int i = 0; i < priorityCounter.length; i++)
			priorityCounter[i] = 0;
		for (CommandInfo cmd : commands) {
			priorityCounter[cmd.getPriority().ordinal()]++;
		}
		return priorityCounter;
	}

}
