package csbase.server.services.ftcservice;

import java.io.File;
import java.nio.channels.FileChannel;

/**
 * Define as operaes que o provedor de um arquivo deve implementar.
 */
public interface FTCRequester {
  /**
   * Solicita a criao de um java.util.FileChannel de acesso ao arquivo.
   * 
   * @param file o arquivo a ser acessado.
   * @param readOnly indica se o acesso  somente leitura (true) ou se  de
   *        leitura e escrita (false).
   * @return um canal para acesso ao contedo do arquivo.
   * @throws Exception caso haja erro na operao.
   */
  public FileChannel createFileChannel(File file, boolean readOnly)
    throws Exception;

  /**
   * Informa se o arquivo indicado est bloqueado para escrita.
   * 
   * @param file o arquivo.
   * @return true se estiver bloqueado para escrita, ou false caso no esteja
   *         bloqueado.
   * @throws Exception caso haja erro na operao.
   */
  public boolean isLocked(File file) throws Exception;

  /**
   * Informa que o canal para o arquivo indicado foi fechado.
   * 
   * @param file o arquivo cujo canal foi fechado.
   * @throws Exception caso haja erro na operao.
   */
  public void fileChannelClosed(File file) throws Exception;
}
