package csbase.server.services.restservice;

import csbase.remote.RestServiceInterface;
import csbase.server.Server;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/**
 * Handler de logger para registro no log do RestService.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CSBaseLoggerHandler extends Handler {

  /**
   * {@inheritDoc}
   */
  @Override
  public void publish(LogRecord record) {
    RestServiceInterface restService = RestService.getInstance();
    if (record.getLevel().equals(Level.INFO)) {
      Server.logInfoMessage(record.getMessage());
      return;
    }
    if (record.getLevel().equals(Level.SEVERE)) {
      Server.logSevereMessage(record.getMessage(), record.getThrown());
      return;
    }
  }

  /**
   * {@inheritDoc}
   * 
   * Nada a fazer.
   */
  @Override
  public void flush() {
  }

  /**
   * {@inheritDoc}
   * 
   * Nada a fazer.
   */
  @Override
  public void close() throws SecurityException {
  }

}
