/**
 * $Id: SGAUtils.java 159864 2014-12-11 12:01:07Z fpina $
 */
package csbase.server.services.sgaservice;

import java.util.HashMap;

import sgaidl.Pair;

/**
 * Classe utilitria para o pacote SGAService.
 * 
 * @author Tecgraf
 */
public class SGAUtils {

  /**
   * Transforma um vetor de pares <chave x valor> em um hash map.
   * 
   * @param pairs um vetor de pares <chave x valor>.
   * 
   * @return o hash map.
   */
  static HashMap<String, String> pairToHashMap(Pair[] pairs) {
    if (pairs == null) {
      return null;
    }
    HashMap<String, String> hash = new HashMap<String, String>();
    for (Pair pair : pairs) {
      hash.put(pair.key, pair.value);
    }
    return hash;
  }
}
