package csbase.server.services.projectservice;

import csbase.logic.ProjectFileInfo;

/**
 * Define um template de projeto a partir de um diretrio-base sem restries.
 */
public class BasicProjectTemplate implements ProjectTemplate {

  /**
   * Direttio-base do template.
   */
  private final ProjectFileInfo baseDir;

  /**
   * Parmetros para configurao do template.
   */
  private String[] parameters;

  /**
   * Construtor.
   *
   * @param baseDir diretrio-base do template.
   * @param params parmetros para configurao do template.
   */
  public BasicProjectTemplate(ProjectFileInfo baseDir, String... params) {
    this.baseDir = baseDir;
    this.parameters = params;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canRename(ServerProjectFile file, String newName) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canDelete(ServerProjectFile file) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canCreate(ServerProjectFile parentDir, String name, String type) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canChangeType(ServerProjectFile file, String newType) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ProjectFileInfo getBaseDir() {
    return baseDir;
  }

  /**
   * Obtm os parmetros do template.
   *
   * @return os parmetros.
   */
  public String[] getParameters() {
    return parameters;
  }
}
