/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.exception.ServiceFailureException;
import csbase.logic.ProjectFileTypeInfo;
import csbase.server.Server;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;

public final class ProjectFileTypeRepository {
    static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static final String PREFFIX_KEY = "filetype.%s.";
    private static final String CODE_KEY = "filetype.%s.typeCode";
    private static final String DESCRIPTION_KEY = "filetype.%s.description_%s";
    private static final String BASE_ICON_KEY = "filetype.%s.baseIcon";
    private static final String UNDER_CONSTRUCTION_ICON_KEY = "filetype.%s.ucIcon";
    private static final String CUT_ICON_KEY = "filetype.%s.cutIcon";
    private static final String MIME_TYPE_KEY = "filetype.%s.mimeType";
    private static final String EXTENSIONS_KEY = "filetype.%s.extensions";
    private static final String IS_DIRECTORY_KEY = "filetype.%s.isDirectory";
    private byte[] defaultIcon;
    private Map<Locale, Map<String, ProjectFileTypeInfo>> infosByCodeByLocale = new HashMap<Locale, Map<String, ProjectFileTypeInfo>>();
    private String path;

    public ProjectFileTypeRepository(String path) {
        this.setPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ProjectFileTypeInfo> getInfos(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("O par\u00e2metro locale est\u00e1 nulo.");
        }
        Map<String, ProjectFileTypeInfo> infosByCode = this.infosByCodeByLocale.get(locale);
        if (infosByCode == null) {
            Map<Locale, Map<String, ProjectFileTypeInfo>> map = this.infosByCodeByLocale;
            synchronized (map) {
                infosByCode = this.infosByCodeByLocale.get(locale);
                if (infosByCode == null) {
                    infosByCode = this.loadInfos(locale);
                    this.infosByCodeByLocale.put(locale, infosByCode);
                }
            }
        }
        return Collections.unmodifiableMap(infosByCode);
    }

    public ProjectFileTypeInfo getInfo(Locale locale, String code) {
        ProjectFileTypeInfo type;
        Map<String, ProjectFileTypeInfo> infosByCode = this.getInfos(locale);
        if (code == null) {
            String msg = String.format("Obtendo informa\u00e7\u00f5es sobre o tipo desconhecido (%s), j\u00e1 que foi fornecido um c\u00f3digo null.", "UNKNOWN");
            Server.logFineMessage(msg);
            code = "UNKNOWN";
        }
        if ((type = infosByCode.get(code)) == null) {
            String msg = String.format("Obtendo informa\u00e7\u00f5es sobre o tipo desconhecido (%s), j\u00e1 que foi fornecido o c\u00f3digo %s que n\u00e3o est\u00e1 presente no sistema.", "UNKNOWN", code);
            Server.logFineMessage(msg);
            return this.getInfo(locale, "UNKNOWN");
        }
        return type;
    }

    public Set<ProjectFileTypeInfo> findInfosByExtension(Locale locale, String extension) {
        Map<String, ProjectFileTypeInfo> infosByCode = this.getInfos(locale);
        HashSet<ProjectFileTypeInfo> infos = new HashSet<ProjectFileTypeInfo>();
        for (ProjectFileTypeInfo info : infosByCode.values()) {
            if (!info.getExtensions().contains(extension)) continue;
            infos.add(info);
        }
        return Collections.unmodifiableSet(infos);
    }

    public ProjectFileTypeInfo findInfoByExtension(Locale locale, String extension) {
        Set<ProjectFileTypeInfo> infos = this.findInfosByExtension(locale, extension);
        if (infos.isEmpty()) {
            String msg = String.format("N\u00e3o h\u00e1 tipos cadastrados para a extens\u00e3o '%s'.Ser\u00e1 utilizado o tipo 'Desconhecido'.", extension);
            Server.logWarningMessage(msg);
            return this.getInfo(locale, "UNKNOWN");
        }
        if (infos.size() != 1) {
            String msg = String.format("H\u00e1 2 ou mais tipos cadastrados para a extens\u00e3o '%s'.S\u00e3o eles: %s.Ser\u00e1 retornado algum deles.", extension, infos);
            Server.logWarningMessage(msg);
        }
        ProjectFileTypeInfo info = infos.iterator().next();
        return info;
    }

    private void setPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("O par\u00e2metro path \u00e9 nulo.");
        }
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ProjectFileTypeInfo> loadInfos(Locale locale) {
        InputStream inputStream = this.getClass().getResourceAsStream(this.path);
        if (inputStream == null) {
            String msg = String.format("N\u00e3o foi poss\u00edvel encontrar o arquivo %s no classpath.", this.path);
            throw new ServiceFailureException(msg);
        }
        try {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
                String msg = String.format("Erro de E/S ao ler o arquivo %s no classpath.", this.path);
                throw new ServiceFailureException(msg, (Throwable)e);
            }
            HashMap<String, ProjectFileTypeInfo> infosByCode = new HashMap<String, ProjectFileTypeInfo>();
            Set<String> codes = this.getCodes(properties);
            if (!codes.contains("UNKNOWN")) {
                String msg = String.format("N\u00e3o foi poss\u00edvel encontrar informa\u00e7\u00f5es sobre o tipo %s no arquivo %s presente no classpath do sistema.\n", "UNKNOWN", this.path);
                throw new ServiceFailureException(msg);
            }
            this.readDefaultIcon(properties);
            for (String code : codes) {
                infosByCode.put(code, this.readInfo(properties, code, locale));
            }
            HashMap<String, ProjectFileTypeInfo> hashMap = infosByCode;
            return hashMap;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private Set<String> getCodes(Properties properties) {
        HashSet<String> codes = new HashSet<String>();
        int i = 0;
        String code = properties.getProperty(String.format(CODE_KEY, i));
        while (code != null) {
            codes.add(code);
            code = properties.getProperty(String.format(CODE_KEY, ++i));
        }
        return Collections.unmodifiableSet(codes);
    }

    private ProjectFileTypeInfo readInfo(Properties properties, String code, Locale locale) {
        byte[] cutIcon;
        byte[] ucIcon;
        byte[] baseIcon;
        String mimeType;
        String description = this.getDescription(properties, code, locale);
        if (description.isEmpty()) {
            String msg = String.format("Faltando a descri\u00e7\u00e3o para o tipo %s.Usando o pr\u00f3prio c\u00f3digo do tipo como descri\u00e7\u00e3o.Corrija o arquivo %s dispon\u00edvel no classpath do Sistema.", code, this.path);
            Server.logWarningMessage(msg);
            description = code;
        }
        if ((mimeType = this.getMimeType(properties, code)).isEmpty()) {
            String msg = String.format("Faltando o mime-type para o tipo %s.Usando o pr\u00f3prio o mime-type padr\u00e3o %s.Corrija o arquivo %s dispon\u00edvel no classpath do Sistema.", code, DEFAULT_MIME_TYPE, this.path);
            Server.logWarningMessage(msg);
            mimeType = DEFAULT_MIME_TYPE;
        }
        if ((baseIcon = this.readBaseIcon(properties, code)).length == 0) {
            String msg = String.format("Faltando o \u00edcone base para o tipo %s.Usando o \u00edcone base do tipo %s..Corrija o arquivo %s dispon\u00edvel no classpath do Sistema.", code, "UNKNOWN", this.path);
            Server.logWarningMessage(msg);
            baseIcon = Arrays.copyOf(this.defaultIcon, this.defaultIcon.length);
        }
        if ((ucIcon = this.readUnderConstructionIcon(properties, code)).length == 0) {
            String msg = String.format("Faltando o \u00edcone em constru\u00e7\u00e3o para o tipo %s.Usando o \u00edcone base do tipo %s..Corrija o arquivo %s dispon\u00edvel no classpath do Sistema.", code, "UNKNOWN", this.path);
            Server.logWarningMessage(msg);
            ucIcon = Arrays.copyOf(this.defaultIcon, this.defaultIcon.length);
        }
        if ((cutIcon = this.readCutIcon(properties, code)).length == 0) {
            String msg = String.format("Faltando o \u00edcone cortar para o tipo %s.Usando o \u00edcone base do tipo %s..Corrija o arquivo %s dispon\u00edvel no classpath do Sistema.", code, "UNKNOWN", this.path);
            Server.logWarningMessage(msg);
            cutIcon = Arrays.copyOf(this.defaultIcon, this.defaultIcon.length);
        }
        Set<String> extensions = this.getExtensions(properties, code);
        boolean isDirectory = this.isDirectory(properties, code);
        return new ProjectFileTypeInfo(code, description, mimeType, baseIcon, ucIcon, cutIcon, extensions, isDirectory);
    }

    private boolean isDirectory(Properties properties, String code) {
        String text = this.getText(properties, code, IS_DIRECTORY_KEY);
        if (text.isEmpty()) {
            String message = String.format("N\u00e3o propriedade %s para o tipo %s, logo assumindo que o tipo \u00e9 aplicavel a arquivos.", IS_DIRECTORY_KEY, code);
            Server.logWarningMessage(message);
            return false;
        }
        if (text.equals(Boolean.TRUE.toString())) {
            return true;
        }
        if (text.equals(Boolean.FALSE.toString())) {
            return false;
        }
        String message = String.format("O valor '%s' da propriedade %s para o tipo %s n\u00e3o \u00e9 um valor booleano v\u00e1lido, assumindo falso, logo assumindo que o tipo \u00e9 aplicavel a arquivos. Valores v\u00e1lidos: %s ou %s.", text, IS_DIRECTORY_KEY, code, Boolean.TRUE, Boolean.FALSE);
        Server.logWarningMessage(message);
        return false;
    }

    private String getDescription(Properties properties, String code, Locale locale) {
        return this.getText(properties, code, locale, DESCRIPTION_KEY);
    }

    private String getMimeType(Properties properties, String code) {
        return this.getText(properties, code, MIME_TYPE_KEY);
    }

    private byte[] readBaseIcon(Properties properties, String code) {
        return this.readIcon(properties, code, BASE_ICON_KEY);
    }

    private byte[] readUnderConstructionIcon(Properties properties, String code) {
        return this.readIcon(properties, code, UNDER_CONSTRUCTION_ICON_KEY);
    }

    private byte[] readCutIcon(Properties properties, String code) {
        return this.readIcon(properties, code, CUT_ICON_KEY);
    }

    private void readDefaultIcon(Properties properties) {
        byte[] icon = this.readBaseIcon(properties, "UNKNOWN");
        if (icon.length == 0) {
            String msg = String.format("N\u00e3o foi poss\u00edvel encontrar o \u00edcone base %s sobre o tipo %s no arquivo %s presente no classpath do sistema. Se algum tipo n\u00e3o tiver um dos \u00edcones definidos, o \u00edcone n\u00e3o aparecer\u00e1 no sistema. Corrija o arquivo.\n", BASE_ICON_KEY, "UNKNOWN", this.path);
            Server.logWarningMessage(msg);
        }
        this.defaultIcon = icon;
    }

    private Set<String> getExtensions(Properties properties, String code) {
        String text = this.getText(properties, code, EXTENSIONS_KEY);
        StringTokenizer tokenizer = new StringTokenizer(text, ",");
        HashSet<String> extensions = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            token = token.trim();
            extensions.add(token);
        }
        return Collections.unmodifiableSet(extensions);
    }

    private String getText(Properties properties, String code, Locale locale, String format) {
        String key = String.format(format, code, locale);
        return this.getText(properties, key);
    }

    private String getText(Properties properties, String code, String format) {
        String key = String.format(format, code);
        return this.getText(properties, key);
    }

    private String getText(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            String msg = String.format("N\u00e3o foi poss\u00edvel encontrar a chave %s no arquivo %s.", key, this.path);
            Server.logWarningMessage(msg);
            return "";
        }
        if ((value = value.trim()).isEmpty()) {
            String msg = String.format("O valor da chave %s no arquivo %s est\u00e1 vazio.", key, this.path);
            Server.logWarningMessage(msg);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readIcon(Properties properties, String code, String format) {
        String key = String.format(format, code);
        String value = this.getText(properties, key);
        if (value.isEmpty()) {
            return new byte[0];
        }
        InputStream inputStream = this.getClass().getResourceAsStream(value);
        if (inputStream == null) {
            String msg = String.format("O arquivo %s que \u00e9 mencionando como valor da chave %s do arquivo %s n\u00e3o est\u00e1 no classpath.", value, key, this.path);
            Server.logWarningMessage(msg);
            return new byte[0];
        }
        try {
            byte[] msg = IOUtils.toByteArray((InputStream)inputStream);
            return msg;
        }
        catch (IOException e) {
            String msg = String.format("Erro de E/S ao ler arquivo %s que \u00e9 mencionando como valor da chave %s do arquivo %s do classpath.", value, key, this.path);
            Server.logWarningMessage(msg);
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

