/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.repositoryservice;

import csbase.exception.ServiceFailureException;
import csbase.server.services.repositoryservice.AbstractRepository;
import csbase.server.services.repositoryservice.IRepositoryFile;
import csbase.server.services.repositoryservice.LocalFile;
import csbase.server.services.repositoryservice.RepositoryFileException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import tecgraf.javautils.core.io.FileUtils;

class LocalRepository
extends AbstractRepository {
    private Set<String> locks = new HashSet<String>();

    LocalRepository(String uri) {
        super(LocalRepository.handleURI(uri));
    }

    @Override
    public IRepositoryFile getFile(String ... path) {
        if (!this.isValidPath(path)) {
            return null;
        }
        String filePath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])path);
        String fullPath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])new String[]{this.uri, filePath});
        File file = new File(fullPath);
        if (file.exists()) {
            filePath = this.clearPath(filePath);
            return new LocalFile(file, this, filePath);
        }
        return null;
    }

    @Override
    public char getFileSeparator() {
        return File.separatorChar;
    }

    private static String handleURI(String uri) {
        File file = new File(uri);
        return file.getPath();
    }

    @Override
    public IRepositoryFile getDir(String ... path) {
        IRepositoryFile file = this.getFile(path);
        return file != null && file.isDirectory() ? file : null;
    }

    @Override
    public List<IRepositoryFile> listFiles() {
        File file = new File(this.uri);
        if (!file.isDirectory()) {
            return null;
        }
        LinkedList<IRepositoryFile> files = new LinkedList<IRepositoryFile>();
        for (File child : file.listFiles()) {
            files.add(new LocalFile(child, this, child.getName()));
        }
        return files;
    }

    @Override
    public synchronized IRepositoryFile createFile(String[] path, String name) throws RepositoryFileException {
        String parentPath = path == null || path.length == 0 ? "." : FileUtils.joinPath((char)this.getFileSeparator(), (String[])path);
        String fullParrentPath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])new String[]{this.uri, parentPath});
        File parent = new File(fullParrentPath);
        File newFile = new File(parent, name);
        if (newFile.exists()) {
            String infoMsg = String.format("J\u00e1 existe um arquivo com o nome %s em %s.", name, parent.getName());
            throw new RepositoryFileException(infoMsg);
        }
        try {
            newFile.createNewFile();
            String relativeFilePath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])new String[]{parentPath, name});
            relativeFilePath = this.clearPath(relativeFilePath);
            return new LocalFile(newFile, this, relativeFilePath);
        }
        catch (IOException e) {
            String errMsg = String.format("LocalRepository: erro ao criar %s", newFile.getAbsolutePath());
            throw new ServiceFailureException(errMsg, (Throwable)e);
        }
    }

    @Override
    public IRepositoryFile createDir(String ... path) throws IOException {
        String filePath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])path);
        String fullPath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])new String[]{this.uri, filePath});
        File file = new File(fullPath);
        if (!file.mkdir()) {
            return null;
        }
        filePath = this.clearPath(filePath);
        return new LocalFile(file, this, filePath);
    }

    @Override
    public boolean renameFile(String srcFilePath, String newFileName) throws IOException {
        if (!this.isValidPath(srcFilePath)) {
            return false;
        }
        String fullPath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])new String[]{this.uri, srcFilePath});
        String targetFullPath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])new String[]{this.uri, FileUtils.getFilePath((String)srcFilePath), newFileName});
        File srcFile = new File(fullPath);
        File destFile = new File(targetFullPath);
        if (!srcFile.exists()) {
            String msg = String.format("N\u00e3o foi poss\u00edvel renomear %s: arquivo n\u00e3o existe.", srcFile.getName());
            throw new IOException(msg);
        }
        if (destFile.exists() && !destFile.delete()) {
            String msg = String.format("%s n\u00e3o foi renomeado para %s", srcFile.getName(), newFileName);
            throw new IOException(msg);
        }
        if (srcFile.renameTo(destFile)) {
            srcFile.delete();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFile(String ... path) throws IOException {
        String filePath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])path);
        String fullPath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])new String[]{this.uri, filePath});
        File file = new File(fullPath);
        if (!this.isValidPath(path)) {
            return false;
        }
        LocalFile localFile = new LocalFile(file, this, filePath);
        if (this.isLocked(localFile)) {
            localFile.close();
            return false;
        }
        return this.delete(file);
    }

    private boolean isValidPath(String ... path) {
        String[] patterns;
        String filePath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])path);
        String fullPath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])new String[]{this.uri, filePath});
        File file = new File(fullPath);
        File uriFile = new File(this.uri);
        if (uriFile.getAbsolutePath().equals(file.getAbsolutePath())) {
            return false;
        }
        for (String suffix : patterns = new String[]{".", "./", "..", "../"}) {
            if (!fullPath.endsWith(suffix)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean fileExists(String ... path) {
        String filePath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])path);
        String fullPath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])new String[]{this.uri, filePath});
        File file = new File(fullPath);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(IRepositoryFile file) {
        Set<String> set = this.locks;
        synchronized (set) {
            return this.locks.add(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release(IRepositoryFile file) {
        Set<String> set = this.locks;
        synchronized (set) {
            return this.locks.remove(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocked(IRepositoryFile file) {
        Set<String> set = this.locks;
        synchronized (set) {
            return this.locks.contains(file.getPath());
        }
    }

    private boolean delete(File file) {
        File[] children;
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory() && (children = file.listFiles()) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                this.delete(children[i]);
            }
        }
        return file.delete();
    }

    @Override
    public IRepositoryFile copyFile(String srcPath, String[] targetPath) throws IOException {
        return this.copyFile(srcPath, targetPath, null);
    }

    @Override
    public IRepositoryFile copyFile(String srcPath, String[] targetPath, String fileName) throws IOException {
        String stringTargetPath;
        IRepositoryFile origin = this.getFile(srcPath);
        if (origin == null) {
            throw new IOException("Arquivo de origem n\u00e3o pode ser null.");
        }
        if (!this.isRoot(targetPath)) {
            IRepositoryFile target = this.getDir(targetPath);
            if (target == null) {
                throw new IOException("N\u00e3o foi poss\u00edvel obter o caminho de destino.");
            }
            if (target.getPath().startsWith(origin.getPath())) {
                throw new IOException("Um diret\u00f3rio n\u00e3o pode ser copiado para dentro de si mesmo.");
            }
            stringTargetPath = target.getPath();
        } else {
            stringTargetPath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])targetPath);
        }
        IRepositoryFile newFile = null;
        if (origin.isDirectory()) {
            newFile = this.createDir(stringTargetPath, origin.getName());
            if (newFile == null) {
                throw new IOException("N\u00e3o foi poss\u00edvel criar o novo arquivo.");
            }
            List<IRepositoryFile> children = origin.getChildren();
            for (IRepositoryFile child : children) {
                this.copyFile(child.getPath(), new String[]{newFile.getPath()});
            }
        } else {
            String filePath = fileName != null ? FileUtils.joinPath((char)this.getFileSeparator(), (String[])new String[]{stringTargetPath, fileName}) : FileUtils.joinPath((char)this.getFileSeparator(), (String[])new String[]{stringTargetPath, origin.getName()});
            String fullPath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])new String[]{this.uri, filePath});
            File targetFile = new File(fullPath);
            if (!targetFile.createNewFile()) {
                throw new IOException("N\ufffdo foi poss\ufffdvel criar o novo arquivo: " + fullPath);
            }
            filePath = this.clearPath(filePath);
            newFile = new LocalFile(targetFile, this, filePath);
            ((LocalFile)origin).copyRegularFile(targetFile);
            targetFile.setLastModified(origin.getModificationDate());
        }
        origin.close();
        return newFile;
    }

    private String clearPath(String filePath) {
        String newFilePath = filePath;
        while (newFilePath.startsWith(String.valueOf(this.getFileSeparator())) || newFilePath.startsWith(".")) {
            newFilePath = newFilePath.substring(1);
        }
        return newFilePath;
    }

    private boolean isRoot(String ... path) {
        String stringPath = FileUtils.joinPath((char)this.getFileSeparator(), (String[])path);
        return String.valueOf(this.getFileSeparator()).equals(stringPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyContent(OutputStream targetFileStream, InputStream sourceFileStream) throws IOException {
        int bufferSize = 262144;
        BufferedOutputStream out = null;
        BufferedInputStream in = null;
        try {
            out = new BufferedOutputStream(targetFileStream);
            in = new BufferedInputStream(sourceFileStream);
            byte[] buffer = new byte[262144];
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }
}

