/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh.pbs.lncc;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.monitor.SGAInfo;
import csbase.sga.ssh.SGADriver;
import csbase.sga.ssh.pbs.lncc.PBSJobData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sgaidl.ProcessState;

public class PBSDriver
implements SGADriver {
    private static final String QUEUE_KEY = "sga_pbs_queue";
    private static final String RESOURCE_LIST = "sga_pbs_resource_list";
    private static final String ENVIRONMENT_CMD = "sga_pbs_environment_cmd";
    private static final String SUBMIT_JOB = "qsub {0} {1}";
    private static final String CHECK_JOB = "qstat -x {0};echo \"{1}\";tracejob -v {2}";
    private static final String KILL_JOB = "qdel {0}";
    private static final String CHECK_ALL_NODES_XML = "pbsnodes -x";
    private static final String CHECK_ALL_JOBS_XML = "qstat -x";
    private static final Pattern JOB_ID_PATTERN = Pattern.compile("([^\\.]+)\\.(.*)\n");
    private static final Pattern TRACEJOB_JOB_PROPERTIES_PATTERN = Pattern.compile("\\s{1}([^\\s]+)=([^\\s]+)\\s{1}");
    private static final Pattern TRACEJOB_JOB_ID_PATTERN = Pattern.compile("pjob: (\\d+)");
    private static final String CHECK_JOB_CMD_SEPARATOR = "%%";
    private Properties properties;

    @Override
    public void init(Properties properties) {
        this.properties = properties;
    }

    private String configureEnvironment() {
        if (this.properties.containsKey(ENVIRONMENT_CMD)) {
            return this.properties.getProperty(ENVIRONMENT_CMD) + ";";
        }
        return "";
    }

    @Override
    public String buildSubmitJobCommand(String script, Map<String, String> extraParam) {
        String cmd = this.configureEnvironment() + SUBMIT_JOB;
        String extra = "";
        if (this.properties.containsKey(QUEUE_KEY)) {
            extra = extra + " -q " + this.properties.get(QUEUE_KEY);
        }
        if (this.properties.contains(RESOURCE_LIST)) {
            extra = extra + " -l " + this.properties.get(RESOURCE_LIST);
        }
        String[] splitedScript = script.split("\\s");
        return MessageFormat.format(cmd, extra, splitedScript[1]);
    }

    @Override
    public String buildKillJobCommand(JobData jobData) {
        String cmd = this.configureEnvironment() + KILL_JOB;
        PBSJobData data = (PBSJobData)jobData;
        return MessageFormat.format(cmd, data.getJobId());
    }

    @Override
    public String buildCheckJobCommand(JobData jobData) {
        String cmd = this.configureEnvironment() + CHECK_JOB;
        PBSJobData data = (PBSJobData)jobData;
        return MessageFormat.format(cmd, data.getJobId(), CHECK_JOB_CMD_SEPARATOR, data.getJobId());
    }

    @Override
    public String buildCheckAllJobsCommand() {
        return null;
    }

    @Override
    public JobData parseJobSubmissionOutput(String output) {
        Matcher matcher = JOB_ID_PATTERN.matcher(output);
        if (matcher.matches()) {
            return new PBSJobData(matcher.group(1));
        }
        return null;
    }

    @Override
    public Map<JobData, JobInfo> parseCheckJobOutput(String output) {
        return this.parseXMLJobOutput(output);
    }

    private Map<JobData, JobInfo> parseXMLJobOutput(String output) {
        HashMap<JobData, JobInfo> jobsInfo = new HashMap<JobData, JobInfo>();
        if (output.isEmpty()) {
            return jobsInfo;
        }
        String[] data = output.split(CHECK_JOB_CMD_SEPARATOR);
        String qstat = data[0];
        String tracejob = data[1];
        byte[] xmlbytes = qstat.getBytes();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream input = new ByteArrayInputStream(xmlbytes);
            Document doc = builder.parse(input);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("Job");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                HashMap<String, String> attrsMap = new HashMap<String, String>();
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element jobElem = (Element)nNode;
                this.splitJobId(jobElem.getTextContent(), attrsMap);
                this.fillJobProperties(jobElem, attrsMap);
                JobInfo job = this.convertToJobInfo(attrsMap);
                jobsInfo.put(new PBSJobData((String)attrsMap.get("pid")), job);
            }
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        String jobId = "";
        Matcher jobIdMatcher = TRACEJOB_JOB_ID_PATTERN.matcher(tracejob);
        if (jobIdMatcher.find()) {
            jobId = jobIdMatcher.group(1);
        }
        Matcher matcher = TRACEJOB_JOB_PROPERTIES_PATTERN.matcher(tracejob);
        int start = 0;
        HashMap<String, String> properties = new HashMap<String, String>();
        while (matcher.find(start)) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            properties.put(key, value);
            start = matcher.start() + 1;
        }
        PBSJobData jobData = new PBSJobData(jobId);
        JobInfo jobInfo = (JobInfo)jobsInfo.get(jobData);
        if (jobInfo == null) {
            jobInfo = new JobInfo();
            jobInfo.jobParam.put("csbase_command_pid", jobId);
            jobInfo.jobParam.put("csbase_command_state", String.valueOf(ProcessState.FINISHED));
            String host = (String)properties.get("exec_host");
            jobInfo.jobParam.put("csbase_command_exec_host", host == null ? "" : host);
            String ctimeS = (String)properties.get("resources_used.cput");
            String ramS = (String)properties.get("resources_used.mem");
            String swapS = (String)properties.get("resources_used.vmem");
            String walltimeS = (String)properties.get("resources_used.walltime");
            long ram = ramS != null ? this.getInfoInMb(ramS) : -1L;
            long swap = swapS != null ? this.getInfoInMb(swapS) : -1L;
            long ctime = Long.parseLong(ctimeS);
            long walltime = Long.parseLong(walltimeS);
            jobInfo.jobParam.put("csbase_command_memory_ram_size_mb", Long.toString(ram));
            jobInfo.jobParam.put("csbase_command_memory_swap_size_mb", Long.toString(swap));
            jobInfo.jobParam.put("csbase_command_time_sec", Long.toString(ctime));
            jobInfo.jobParam.put("csbase_command_wall_time_sec", Long.toString(walltime));
            jobsInfo.put(jobData, jobInfo);
        }
        return jobsInfo;
    }

    private void fillJobProperties(Element jobElem, Map<String, String> attrsMap) {
        int resources_usedCounter = 0;
        NodeList atts = jobElem.getElementsByTagName("*");
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.item(i).getNodeName().equals("resources_used")) {
                attrsMap.put(atts.item(i).getNodeName() + ++resources_usedCounter, atts.item(i).getTextContent());
                continue;
            }
            attrsMap.put(atts.item(i).getNodeName(), atts.item(i).getTextContent());
        }
    }

    private void splitJobId(String jobId, Map<String, String> attrsMap) {
        Pattern JOBID_PATTERN = Pattern.compile("([^.]+).(\\S+)");
        Matcher attrsMatcher = JOBID_PATTERN.matcher(jobId);
        attrsMatcher.find();
        attrsMap.put("pid", attrsMatcher.group(1));
    }

    private JobInfo convertToJobInfo(Map<String, String> jobMap) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.jobParam.put("csbase_command_pid", jobMap.get("pid"));
        jobInfo.jobParam.put("csbase_command_state", this.convertJobState(jobMap.get("job_state")).toString());
        String host = jobMap.get("exec_host");
        jobInfo.jobParam.put("csbase_command_exec_host", host == null ? "" : host);
        this.retrieveResourcesUsed(jobInfo, jobMap);
        return jobInfo;
    }

    private ProcessState convertJobState(String state) {
        switch (state) {
            case "C": {
                return ProcessState.FINISHED;
            }
            case "E": {
                return ProcessState.FINISHED;
            }
            case "H": {
                return ProcessState.SLEEPING;
            }
            case "Q": {
                return ProcessState.WAITING;
            }
            case "R": {
                return ProcessState.RUNNING;
            }
            case "T": {
                return ProcessState.RUNNING;
            }
            case "W": {
                return ProcessState.SLEEPING;
            }
            case "S": {
                return ProcessState.FINISHED;
            }
        }
        return ProcessState.WAITING;
    }

    private void retrieveResourcesUsed(JobInfo jobInfo, Map<String, String> jobMap) {
        String ctimeS = jobMap.get("cput");
        String ramS = jobMap.get("mem");
        String swapS = jobMap.get("vmem");
        String walltimeS = jobMap.get("walltime");
        long ram = ramS != null ? this.getInfoInMb(ramS) : -1L;
        long swap = swapS != null ? this.getInfoInMb(swapS) : -1L;
        long ctime = ctimeS != null ? this.getInfoInSec(ctimeS) : -1L;
        long walltime = walltimeS != null ? this.getInfoInSec(walltimeS) : -1L;
        jobInfo.jobParam.put("csbase_command_memory_ram_size_mb", Long.toString(ram));
        jobInfo.jobParam.put("csbase_command_memory_swap_size_mb", Long.toString(swap));
        jobInfo.jobParam.put("csbase_command_time_sec", Long.toString(ctime));
        jobInfo.jobParam.put("csbase_command_wall_time_sec", Long.toString(walltime));
    }

    @Override
    public String buildCheckEnvironmentCommand() {
        String cmd = this.configureEnvironment() + CHECK_ALL_NODES_XML;
        if (this.properties.containsKey(QUEUE_KEY)) {
            cmd = cmd + " :" + this.properties.get(QUEUE_KEY);
        }
        return cmd;
    }

    @Override
    public SGAInfo parseCheckEnvironmentOutput(String output) {
        SGAInfo sga = new SGAInfo(this.properties);
        byte[] xmlbytes = output.getBytes();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream input = new ByteArrayInputStream(xmlbytes);
            Document doc = builder.parse(input);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("Node");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                PBSNodeInfo pbsnode = new PBSNodeInfo();
                if (nNode.getNodeType() == 1) {
                    Element nodeElem = (Element)nNode;
                    NodeList atts = nodeElem.getElementsByTagName("*");
                    for (int i = 0; i < atts.getLength(); ++i) {
                        pbsnode.attMap.put(atts.item(i).getNodeName(), atts.item(i).getTextContent());
                    }
                    this.splitInfo(pbsnode);
                }
                long ramMem = pbsnode.physmemkb;
                long swapMem = pbsnode.totmemkb - pbsnode.physmemkb;
                long availableRam = pbsnode.availmemkb >= swapMem ? pbsnode.availmemkb - swapMem : 0L;
                long availableSwap = pbsnode.availmemkb - availableRam;
                double freeRamPerc = availableRam * 100L / ramMem;
                double freeSwapPerc = availableSwap * 100L / swapMem;
                sga.addNode(pbsnode.attMap.get("name"), null, pbsnode.attMap.get("ncpus"), "0", Long.toString(ramMem), Long.toString(swapMem), Double.toString(freeRamPerc), Double.toString(freeSwapPerc), pbsnode.attMap.get("loadave"), pbsnode.attMap.get("loadave"), pbsnode.attMap.get("loadave"), Integer.toString(pbsnode.njobs));
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sga;
    }

    private void splitInfo(PBSNodeInfo pbsnode) {
        Pattern NODES_ATTRIBUTES_PATTERN = Pattern.compile("([^,=]+)=([^,]+)");
        pbsnode.njobs = this.countJobs(pbsnode);
        Matcher attrsMatcher = NODES_ATTRIBUTES_PATTERN.matcher(pbsnode.attMap.get("status"));
        while (attrsMatcher.find()) {
            pbsnode.attMap.put(attrsMatcher.group(1), attrsMatcher.group(2));
        }
        pbsnode.totmemkb = this.getInfoInMb(pbsnode.attMap.get("totmem"));
        pbsnode.availmemkb = this.getInfoInMb(pbsnode.attMap.get("availmem"));
        pbsnode.physmemkb = this.getInfoInMb(pbsnode.attMap.get("physmem"));
    }

    private int countJobs(PBSNodeInfo pbsnode) {
        Pattern JOB_IDS_PATTERN = Pattern.compile("([^,]+)");
        if (pbsnode.attMap.containsKey("jobs")) {
            Matcher jobsMatcher = JOB_IDS_PATTERN.matcher(pbsnode.attMap.get("jobs"));
            int jobCounter = 0;
            while (jobsMatcher.find()) {
                ++jobCounter;
            }
            return jobCounter;
        }
        return 0;
    }

    private long getInfoInMb(String string) {
        String measure;
        Pattern BYTE_INFO_PATTERN = Pattern.compile("(\\d+)(\\S+)");
        Matcher attrsMatcher = BYTE_INFO_PATTERN.matcher(string);
        attrsMatcher.find();
        long value = Long.parseLong(attrsMatcher.group(1));
        switch (measure = attrsMatcher.group(2)) {
            case "b": {
                value /= 1000000L;
                break;
            }
            case "kb": {
                value /= 1000L;
                break;
            }
            case "mb": {
                break;
            }
            case "gb": {
                value *= 1000L;
                break;
            }
            case "tb": {
                value *= 1000000L;
                break;
            }
            default: {
                value = 0L;
            }
        }
        return value;
    }

    private long getInfoInSec(String string) {
        Pattern BYTE_INFO_PATTERN = Pattern.compile("(\\d+):(\\d+):(\\d+)");
        Matcher attrsMatcher = BYTE_INFO_PATTERN.matcher(string);
        attrsMatcher.find();
        return Long.parseLong(attrsMatcher.group(1)) * 3600L + Long.parseLong(attrsMatcher.group(2)) * 60L + Long.parseLong(attrsMatcher.group(3));
    }

    @Override
    public Map<JobData, JobInfo> parseCheckAllJobsOutput(String output) {
        return null;
    }

    private class PBSNodeInfo {
        public int njobs;
        public long totmemkb;
        public long availmemkb;
        public long physmemkb;
        public Map<String, String> attMap = new HashMap<String, String>();

        private PBSNodeInfo() {
        }
    }
}

