/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.Client;
import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.algorithms.AlgorithmConfiguratorViewListener;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.SimpleAlgorithmConfiguratorView;
import csbase.client.kernel.ClientException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.SimpleParameterListener;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;

public final class ParameterViewTester<V> {
    private JFrame testFrame;
    private Parameter<V> parameter;
    private JLabel statusLabel;
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    public ParameterViewTester(Parameter<V> parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameter est\u00e1 nulo.");
        }
        this.parameter = parameter;
        this.testFrame = new JFrame("Teste de visualiza\u00e7\u00e3o de par\u00e2metros");
        this.testFrame.setDefaultCloseOperation(3);
        this.testFrame.setSize(800, 600);
        JPanel buttonPanel = new JPanel();
        JButton commandButton = new JButton("Linha de comando");
        commandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String clientName = Client.getInstance().getClientName();
                CommandLineContext context = new CommandLineContext(null, null, '/', "project/usuario/Projeto", null, null, null, null, null, false, null, clientName);
                ParameterViewTester.this.showMessage("Linha de comando: " + ParameterViewTester.this.parameter.getCommandLine(context));
            }
        });
        buttonPanel.add(commandButton);
        JPanel statusPanel = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel();
        statusPanel.add((Component)this.statusLabel, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)statusPanel, "North");
        panel.add((Component)buttonPanel, "South");
        this.testFrame.getContentPane().add((Component)panel, "South");
        GUIUtils.centerOnScreen((Window)this.testFrame);
        this.testFrame.setVisible(true);
    }

    public void test() throws ClientException {
        AlgorithmInfo algorithm = new AlgorithmInfo("Id do algoritmo", "Algoritmo de teste", "Diret\u00f3rio", "algorithms", new Hashtable());
        AlgorithmVersionInfo algorithmVersion = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(0, 0, 0), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(algorithmVersion, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "comando", null, null, true, CMD_PATTERN);
        ParameterGroup group = new ParameterGroup("Par\u00e2metro de teste");
        configurator.addGroup(group);
        group.addParameter(this.parameter);
        if (this.parameter instanceof SimpleParameter) {
            final SimpleParameter simpleParameter = (SimpleParameter)SimpleParameter.class.cast(this.parameter);
            simpleParameter.addSimpleParameterListener(new SimpleParameterListener<V>(){

                public void capabilityWasChanged(SimpleParameter<V> parameter) {
                    ParameterViewTester.this.showMessage("Mudan\u00e7a de estado habilitado/desabilitado.\nPar\u00e2metro: {0};\nStatus: ({1}).\n", new Object[]{simpleParameter, simpleParameter.isEnabled()});
                }

                public void defaultValueWasChanged(SimpleParameter<V> parameter) {
                    ParameterViewTester.this.showMessage("Mudan\u00e7a de valor-padr\u00e3o.\nPar\u00e2metro: {0};\nValor: ({1}).\n", new Object[]{simpleParameter, simpleParameter.getValueAsText()});
                }

                public void valueWasChanged(SimpleParameter<V> parameter) {
                    ParameterViewTester.this.showMessage("Mudan\u00e7a de valor.\nPar\u00e2metro: {0};\nValor: ({1}).\n", new Object[]{simpleParameter, simpleParameter.getValueAsText()});
                }

                public void visibilityWasChanged(SimpleParameter<V> parameter) {
                    ParameterViewTester.this.showMessage("Mudan\u00e7a de visibilidade.\nPar\u00e2metro: {0};\nStatus: ({1}).\n", new Object[]{simpleParameter, simpleParameter.isVisible()});
                }

                public void labelWasChanged(SimpleParameter<V> parameter) {
                    ParameterViewTester.this.showMessage("Mudan\u00e7a de r\u00f3tulo.\nPar\u00e2metro: {0};\nR\u00f3tulo: {1}.\n", new Object[]{simpleParameter.getName(), simpleParameter.getLabel()});
                }
            });
        }
        SimpleAlgorithmConfiguratorView view = new SimpleAlgorithmConfiguratorView((Window)this.testFrame, configurator, ParameterView.Mode.CONFIGURATION, ValidationMode.FULL);
        view.addAlgorithmConfiguratorViewListener(new AlgorithmConfiguratorViewListener(){

            public void wasConfirmed(AlgorithmConfiguratorView view) {
                System.out.println("wasConfirmed " + view.getConfigurator());
            }

            public void wasCancelled(AlgorithmConfiguratorView view) {
                System.out.println("wasCancelled " + view.getConfigurator());
            }
        });
        view.launch();
    }

    private void showMessage(String message) {
        String text = "";
        text = text + "<html>";
        text = text + "<center>";
        text = text + message.replaceAll("\n", "<br>");
        text = text + "</center>";
        text = text + "</html>";
        this.statusLabel.setText(text);
    }

    private void showMessage(String messageFormat, Object ... parameterFormat) {
        this.showMessage(MessageFormat.format(messageFormat, parameterFormat));
    }

    static {
        Locale locale = new Locale("pt", "BR");
        LNG.load((String)"csbase.client.resources.properties.language.idiom", (Locale)locale);
        LNG.load((String)"resources.language.idiom", (Locale)locale);
    }
}

