/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v1_0.filesystem;

import csbase.client.ClientLocalFile;
import csbase.client.csdk.v1_0.filesystem.CSDKFile;
import csbase.client.csdk.v1_0.filesystem.CSDKLocalFileSystemContext;
import csbase.logic.ClientFile;
import csdk.v1_0.api.filesystem.IFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class CSDKLocalFileSystemContextTest {
    private static final File CURRENT_DIR = new File(".");
    private static final String TMP_PREFIX = "csdk_test";

    @Test
    public void testGetLocalFileWithNonExistingPath() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        String[] randomPath = this.getRandomNonExistingPath();
        IFile file = context.getLocalFile(randomPath);
        Assert.assertNull((Object)file);
    }

    @Test
    public void testGetLocalFileInCurrentDir() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomFile = this.createRandomFileInDir(CURRENT_DIR);
        String[] filePath = new String[]{randomFile.getName()};
        IFile file = context.getLocalFile(filePath);
        this.assertFile(filePath, file);
    }

    @Test
    public void testGetLocalFileWithExistingFile() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomFile = this.createRandomFile();
        String[] filePath = randomFile.getPath();
        IFile file = context.getLocalFile(filePath);
        this.assertFile(filePath, file);
    }

    @Test
    public void testGetLocalDirInCurrentDir() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomDir = this.createRandomDirInDir(CURRENT_DIR);
        String[] dirPath = new String[]{randomDir.getName()};
        IFile file = context.getLocalFile(dirPath);
        this.assertDir(dirPath, file);
    }

    @Test
    public void testGetLocalDirWithExistingDir() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomDir = this.createRandomDir();
        String[] filePath = randomDir.getPath();
        IFile file = context.getLocalFile(filePath);
        this.assertDir(filePath, file);
    }

    @Test
    public void testCreateLocalFileWithNonExistingPath() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        String[] randomPath = this.getRandomNonExistingPath();
        String[] parentPath = this.getDirPath(randomPath);
        String fileName = this.getFileName(randomPath);
        IFile newFile = context.createLocalFile(parentPath, fileName, false);
        this.assertFile(randomPath, newFile);
    }

    @Test
    public void testCreateLocalDirWithNonExistingPath() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        String[] randomPath = this.getRandomNonExistingPath();
        String[] parentPath = this.getDirPath(randomPath);
        String fileName = this.getFileName(randomPath);
        IFile newFile = context.createLocalFile(parentPath, fileName, true);
        this.assertDir(randomPath, newFile);
    }

    @Test
    public void testCreateLocalFileWithExistingFile() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomFile = this.createRandomFile();
        IFile parentDir = randomFile.getParent();
        IFile newFile = context.createLocalFile(parentDir.getPath(), randomFile.getName(), false);
        Assert.assertNull((Object)newFile);
    }

    @Test
    public void testCreateLocalFileWithExistingDir() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomDir = this.createRandomDir();
        IFile parentDir = randomDir.getParent();
        IFile newFile = context.createLocalFile(parentDir.getPath(), randomDir.getName(), false);
        Assert.assertNull((Object)newFile);
    }

    @Test
    public void testCreateLocalDirWithExistingFile() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomFile = this.createRandomFile();
        IFile parentDir = randomFile.getParent();
        IFile newDir = context.createLocalFile(parentDir.getPath(), randomFile.getName(), true);
        Assert.assertNull((Object)newDir);
    }

    @Test
    public void testCreateLocalDirWithExistingDir() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomDir = this.createRandomDir();
        IFile parentDir = randomDir.getParent();
        IFile newDir = context.createLocalFile(parentDir.getPath(), randomDir.getName(), true);
        Assert.assertNull((Object)newDir);
    }

    @Test
    public void testCreateLocalDirInCurrentDir() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        String[] randomPath = this.getRandomNonExistingPathInDir(CURRENT_DIR);
        String dirName = this.getFileName(randomPath);
        IFile newDir = context.createLocalFile(null, dirName, true);
        this.assertDir(randomPath, newDir);
    }

    @Test
    public void testCreateLocalFileInCurrentDir() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        String[] randomPath = this.getRandomNonExistingPathInDir(CURRENT_DIR);
        String dirName = this.getFileName(randomPath);
        IFile newFile = context.createLocalFile(null, dirName, false);
        this.assertFile(randomPath, newFile);
    }

    @Test
    public void testRemoveLocalFileInCurrentDir() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomFile = this.createRandomFileInDir(CURRENT_DIR);
        String[] filePath = new String[]{randomFile.getName()};
        Assert.assertTrue((boolean)context.removeLocalFile(filePath));
        Assert.assertFalse((boolean)randomFile.exists());
    }

    @Test
    public void testRemoveLocalFileWithExistingFile() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomFile = this.createRandomFileInDir(CURRENT_DIR);
        Assert.assertTrue((boolean)context.removeLocalFile(randomFile.getPath()));
        Assert.assertFalse((boolean)randomFile.exists());
    }

    @Test
    public void testRemoveLocalDirInCurrentDir() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomDir = this.createRandomDirInDir(CURRENT_DIR);
        String[] dirPath = new String[]{randomDir.getName()};
        Assert.assertTrue((boolean)context.removeLocalFile(dirPath));
        Assert.assertFalse((boolean)randomDir.exists());
    }

    @Test
    public void testRemoveLocalDirWithExistingDir() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomDir = this.createRandomDir();
        Assert.assertTrue((boolean)context.removeLocalFile(randomDir.getPath()));
        Assert.assertFalse((boolean)randomDir.exists());
    }

    @Test
    public void testRemoveLocalFileWithNonExistingFile() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        String[] randomPath = this.getRandomNonExistingPath();
        Assert.assertFalse((boolean)context.removeLocalFile(randomPath));
    }

    @Test
    public void testRemoveLocalFileWithNonExistingFileInCurrentDir() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        String[] randomPath = this.getRandomNonExistingPathInDir(CURRENT_DIR);
        Assert.assertFalse((boolean)context.removeLocalFile(randomPath));
    }

    @Test
    public void testRemoveLocalFileWithNonEmptyDir() throws Exception {
        CSDKLocalFileSystemContext context = new CSDKLocalFileSystemContext(null);
        IFile randomDir = this.createRandomDir();
        this.createRandomFileInDir(new File(randomDir.getStringPath()));
        Assert.assertFalse((boolean)context.removeLocalFile(randomDir.getPath()));
    }

    private String getFileName(String[] path) {
        return path[path.length - 1];
    }

    private String[] getDirPath(String[] path) {
        return Arrays.copyOf(path, path.length - 1);
    }

    private String[] getRandomNonExistingPath() throws IOException {
        return this.getRandomNonExistingPathInDir(null);
    }

    private String[] getRandomNonExistingPathInDir(File dir) throws IOException {
        File tmpFile = dir == null ? File.createTempFile(TMP_PREFIX, null) : File.createTempFile(TMP_PREFIX, null, dir);
        CSDKFile csdkFile = new CSDKFile((ClientFile)new ClientLocalFile(tmpFile));
        String[] path = csdkFile.getPath();
        Assert.assertTrue((boolean)tmpFile.delete());
        return path;
    }

    private IFile createRandomFile() throws IOException {
        return this.createRandomFileInDir(null);
    }

    private IFile createRandomFileInDir(File dir) throws IOException {
        File tmpFile = dir == null ? File.createTempFile(TMP_PREFIX, null) : File.createTempFile(TMP_PREFIX, null, dir);
        tmpFile.deleteOnExit();
        CSDKFile csdkFile = new CSDKFile((ClientFile)new ClientLocalFile(tmpFile));
        Assert.assertTrue((boolean)csdkFile.exists());
        Assert.assertFalse((boolean)csdkFile.isDirectory());
        return csdkFile;
    }

    private IFile createRandomDirInDir(File dir) throws IOException {
        File tmpFile = dir == null ? File.createTempFile(TMP_PREFIX, null) : File.createTempFile(TMP_PREFIX, null, dir);
        Assert.assertTrue((boolean)tmpFile.delete());
        Assert.assertTrue((boolean)tmpFile.mkdir());
        tmpFile.deleteOnExit();
        CSDKFile csdkDir = new CSDKFile((ClientFile)new ClientLocalFile(tmpFile));
        Assert.assertTrue((boolean)csdkDir.exists());
        Assert.assertTrue((boolean)csdkDir.isDirectory());
        return csdkDir;
    }

    private IFile createRandomDir() throws IOException {
        return this.createRandomDirInDir(null);
    }

    private void removeFile(IFile file) throws IOException {
        File fileToRemove = new File(file.getStringPath());
        Assert.assertTrue((boolean)fileToRemove.delete());
    }

    private void assertDir(String[] filePath, IFile dir) throws IOException {
        Assert.assertNotNull((Object)dir);
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.isDirectory());
        Assert.assertArrayEquals((Object[])filePath, (Object[])dir.getPath());
        this.removeFile(dir);
    }

    private void assertFile(String[] filePath, IFile file) throws IOException {
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((!file.isDirectory() ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])filePath, (Object[])file.getPath());
        this.removeFile(file);
    }
}

