/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.configurabletable.table;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.model.AgeColumn;
import csbase.client.facilities.configurabletable.model.NameColumn;
import csbase.client.facilities.configurabletable.model.Person;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;
import tecgraf.javautils.core.filter.IFilter;

public final class ConfigurableTableTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConstrutorIdNull() {
        new ConfigurableTable(null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstrutorColumnsNull() {
        new ConfigurableTable("id", null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstrutorEmptyColumns() {
        ArrayList columns = new ArrayList();
        new ConfigurableTable("id", columns, null);
    }

    @Test
    public void testSetRowsGetRows() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ConfigurableTable table = new ConfigurableTable("id", columns, null);
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Silvio Berlusconi", 75));
        people.add(new Person("Fulano 1", 30));
        table.updateRows(people);
        Assert.assertEquals((int)people.size(), (int)table.getRows().size());
        Assert.assertEquals((String)((Person)people.get(0)).getName(), (String)((Person)table.getRows().get(0)).getName());
        Assert.assertEquals((Object)((Person)people.get(0)).getAge(), (Object)((Person)table.getRows().get(0)).getAge());
        Assert.assertEquals((String)((Person)people.get(1)).getName(), (String)((Person)table.getRows().get(1)).getName());
        Assert.assertEquals((Object)((Person)people.get(1)).getAge(), (Object)((Person)table.getRows().get(1)).getAge());
    }

    @Test
    public void testSetRowsGetRowsWithFilter() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        IFilter<Person> filter = new IFilter<Person>(){

            public boolean accept(Person t) {
                return t.getAge() > 50;
            }
        };
        ConfigurableTable table = new ConfigurableTable("id", columns, (IFilter)filter);
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Silvio Berlusconi", 75));
        people.add(new Person("Fulano 1", 30));
        table.updateRows(people);
        Assert.assertEquals((int)1, (int)table.getRows().size());
        Assert.assertEquals((String)"Silvio Berlusconi", (String)((Person)table.getRows().get(0)).getName());
        Assert.assertTrue((((Person)table.getRows().get(0)).getAge() == 75 ? 1 : 0) != 0);
        table.setFilter(null);
        Assert.assertEquals((int)people.size(), (int)table.getRows().size());
        Assert.assertEquals((String)((Person)people.get(0)).getName(), (String)((Person)table.getRows().get(0)).getName());
        Assert.assertEquals((Object)((Person)people.get(0)).getAge(), (Object)((Person)table.getRows().get(0)).getAge());
        Assert.assertEquals((String)((Person)people.get(1)).getName(), (String)((Person)table.getRows().get(1)).getName());
        Assert.assertEquals((Object)((Person)people.get(1)).getAge(), (Object)((Person)table.getRows().get(1)).getAge());
    }
}

