/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.logic.algorithms.AlgorithmVersionId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;

public final class AlgorithmVersionIdTest
extends TestCase {
    public static AlgorithmVersionId create() {
        return new AlgorithmVersionId(1, 2, 3);
    }

    public void testAlgorithmVersion() {
        int major = 1;
        int minor = 2;
        int patch = 3;
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionIdTest.assertEquals((int)major, (int)id.getMajor());
        AlgorithmVersionIdTest.assertEquals((int)minor, (int)id.getMinor());
        AlgorithmVersionIdTest.assertEquals((int)patch, (int)id.getPatch());
    }

    public void testEqualsObject() {
        int major = 1;
        int minor = 2;
        int patch = 3;
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionId equalsId = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionIdTest.assertTrue((boolean)id.equals((Object)equalsId));
    }

    public void testEqualsObjectDifferentMajor() {
        int major = 1;
        int minor = 2;
        int patch = 3;
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        int differentMajor = major + 10;
        AlgorithmVersionId differentMajorId = new AlgorithmVersionId(differentMajor, minor, patch);
        AlgorithmVersionIdTest.assertFalse((boolean)id.equals((Object)differentMajorId));
    }

    public void testEqualsObjectDifferentMinor() {
        int major = 1;
        int minor = 2;
        int patch = 3;
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        int differentMinor = minor + 10;
        AlgorithmVersionId differentMinorId = new AlgorithmVersionId(major, differentMinor, patch);
        AlgorithmVersionIdTest.assertFalse((boolean)id.equals((Object)differentMinorId));
    }

    public void testEqualsObjectDifferentPatch() {
        int major = 1;
        int minor = 2;
        int patch = 3;
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        int differentPatch = patch + 10;
        AlgorithmVersionId differentPatchId = new AlgorithmVersionId(major, minor, differentPatch);
        AlgorithmVersionIdTest.assertFalse((boolean)id.equals((Object)differentPatchId));
    }

    public void testEqualsObjectObjectNull() {
        int major = 1;
        int minor = 2;
        int patch = 3;
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionIdTest.assertFalse((boolean)id.equals(null));
    }

    public void testEqualsObjectAnotherClassObject() {
        int major = 1;
        int minor = 2;
        int patch = 3;
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        String anotherClassObject = "Another Class Object";
        AlgorithmVersionIdTest.assertFalse((boolean)id.equals((Object)anotherClassObject));
    }

    public void testHashCode() {
        int major = 1;
        int minor = 2;
        int patch = 3;
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionId equalsId = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionIdTest.assertEquals((int)id.hashCode(), (int)equalsId.hashCode());
    }

    public void testCompareToEquals() {
        int major = 1;
        int minor = 2;
        int patch = 3;
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionId equalsId = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionIdTest.assertEquals((int)0, (int)id.compareTo(equalsId));
    }

    public void testCompareToMajorGreaterThan() {
        int major = 1;
        int majorGreaterThan = major + 1;
        int minor = 2;
        int minorLesserThan = minor - 1;
        int patch = 3;
        int patchLesserThan = patch - 1;
        AlgorithmVersionId majorGreaterThanId = new AlgorithmVersionId(majorGreaterThan, minorLesserThan, patchLesserThan);
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionIdTest.assertTrue((majorGreaterThanId.compareTo(id) > 0 ? 1 : 0) != 0);
    }

    public void testCompareToMajorLesserThan() {
        int major = 1;
        int majorLesserThan = major - 1;
        int minor = 2;
        int minorGreaterThan = minor + 1;
        int patch = 3;
        int patchGreaterThan = patch + 1;
        AlgorithmVersionId majorLesserThanId = new AlgorithmVersionId(majorLesserThan, minorGreaterThan, patchGreaterThan);
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionIdTest.assertTrue((majorLesserThanId.compareTo(id) < 0 ? 1 : 0) != 0);
    }

    public void testCompareToMinorGreaterThan() {
        int major = 1;
        int minor = 2;
        int minorGreaterThan = minor + 1;
        int patch = 3;
        int patchLesserThan = patch - 1;
        AlgorithmVersionId minorGreaterThanId = new AlgorithmVersionId(major, minorGreaterThan, patchLesserThan);
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionIdTest.assertTrue((minorGreaterThanId.compareTo(id) > 0 ? 1 : 0) != 0);
    }

    public void testCompareToMinorLesserThan() {
        int major = 1;
        int minor = 2;
        int minorLesserThan = minor - 1;
        int patch = 3;
        int patchGreaterThan = patch + 1;
        AlgorithmVersionId minorGreaterThanId = new AlgorithmVersionId(major, minorLesserThan, patchGreaterThan);
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionIdTest.assertTrue((minorGreaterThanId.compareTo(id) < 0 ? 1 : 0) != 0);
    }

    public void testCompareToPatchGreaterThan() {
        int major = 1;
        int minor = 2;
        int patch = 3;
        int patchGreaterThan = patch + 1;
        AlgorithmVersionId patchGreaterThanId = new AlgorithmVersionId(major, minor, patchGreaterThan);
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionIdTest.assertTrue((patchGreaterThanId.compareTo(id) > 0 ? 1 : 0) != 0);
    }

    public void testCompareToPatchLesserThan() {
        int major = 1;
        int minor = 2;
        int patch = 3;
        int patchGreaterThan = patch - 1;
        AlgorithmVersionId patchLesserThanId = new AlgorithmVersionId(major, minor, patchGreaterThan);
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionIdTest.assertTrue((patchLesserThanId.compareTo(id) < 0 ? 1 : 0) != 0);
    }

    public void testToString() {
        int major = 1;
        int minor = 2;
        int patch = 3;
        AlgorithmVersionId id = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionIdTest.assertNotNull((Object)id.toString());
        String separator = ".";
        String expectedStrindId = major + separator + minor + separator + patch;
        AlgorithmVersionIdTest.assertEquals((String)expectedStrindId, (String)id.toString());
    }

    public void testSerialize() throws IOException, ClassNotFoundException {
        AlgorithmVersionId expectedId = new AlgorithmVersionId(1, 2, 3);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(expectedId);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        AlgorithmVersionId loadedId = (AlgorithmVersionId)objectInput.readObject();
        AlgorithmVersionIdTest.assertEquals((int)expectedId.getMajor(), (int)loadedId.getMajor());
        AlgorithmVersionIdTest.assertEquals((int)expectedId.getMinor(), (int)loadedId.getMinor());
        AlgorithmVersionIdTest.assertEquals((int)expectedId.getPatch(), (int)loadedId.getPatch());
    }
}

