/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import junit.framework.TestCase;

public final class CategoryTest
extends TestCase {
    public void testCategory1() {
        String id = "ID";
        String name = "Nome";
        Category category = new Category(null, id, name);
        CategoryTest.assertEquals((String)id, (String)category.getId());
        CategoryTest.assertEquals((String)name, (String)category.getName());
    }

    public void testCategory2() {
        String id = null;
        String name = "Nome";
        try {
            new Category(null, id, name);
            CategoryTest.fail();
        }
        catch (IllegalArgumentException e) {
            CategoryTest.assertEquals((String)"id == null", (String)e.getLocalizedMessage());
        }
    }

    public void testCategory3() {
        String id = "ID";
        String name = null;
        try {
            new Category(null, id, name);
            CategoryTest.fail();
        }
        catch (IllegalArgumentException e) {
            CategoryTest.assertEquals((String)"name == null", (String)e.getLocalizedMessage());
        }
    }

    public void testAddCategory1() {
        Category category = new Category(null, "1", "Nome 1");
        CategoryTest.assertNotNull((Object)category.getCategories());
        CategoryTest.assertTrue((boolean)category.getCategories().isEmpty());
        Category childCategory = new Category(category, "1.1", "Nome 1.1");
        CategoryTest.assertTrue((boolean)category.addCategory(childCategory));
        CategoryTest.assertNotNull((Object)category.getCategories());
        CategoryTest.assertEquals((int)1, (int)category.getCategories().size());
        CategoryTest.assertEquals((Object)childCategory, category.getCategories().iterator().next());
    }

    public void testAddCategory2() {
        Category category = new Category(null, "1", "Nome 1");
        CategoryTest.assertNotNull((Object)category.getCategories());
        CategoryTest.assertTrue((boolean)category.getCategories().isEmpty());
        CategoryTest.assertFalse((boolean)category.addCategory(category));
        CategoryTest.assertNotNull((Object)category.getCategories());
        CategoryTest.assertTrue((boolean)category.getCategories().isEmpty());
    }

    public void testAddCategory3() {
        Category category = new Category(null, "1", "Nome 1");
        CategoryTest.assertNotNull((Object)category.getCategories());
        CategoryTest.assertTrue((boolean)category.getCategories().isEmpty());
        Category childCategory = new Category(category, "1.1", "Nome 1.1");
        CategoryTest.assertTrue((boolean)category.addCategory(childCategory));
        CategoryTest.assertNotNull((Object)category.getCategories());
        CategoryTest.assertEquals((int)1, (int)category.getCategories().size());
        CategoryTest.assertEquals((Object)childCategory, category.getCategories().iterator().next());
        CategoryTest.assertFalse((boolean)category.addCategory(childCategory));
        CategoryTest.assertNotNull((Object)category.getCategories());
        CategoryTest.assertEquals((int)1, (int)category.getCategories().size());
        CategoryTest.assertEquals((Object)childCategory, category.getCategories().iterator().next());
    }

    public void testAddCategory4() {
        Category category = new Category(null, "1", "Nome 1");
        CategoryTest.assertNotNull((Object)category.getCategories());
        CategoryTest.assertTrue((boolean)category.getCategories().isEmpty());
        try {
            category.addCategory(null);
        }
        catch (IllegalArgumentException e) {
            CategoryTest.assertEquals((String)"category == null", (String)e.getLocalizedMessage());
        }
        CategoryTest.assertNotNull((Object)category.getCategories());
        CategoryTest.assertTrue((boolean)category.getCategories().isEmpty());
    }

    public void testAddAlgorithm1() {
        Category category = new Category(null, "Categoria 1", "Categoria 1");
        AlgorithmInfo algorithm = CategoryTest.createAlgorithm("Algoritmo 1");
        CategoryTest.assertNotNull((Object)category.getAlgorithms());
        CategoryTest.assertTrue((boolean)category.getAlgorithms().isEmpty());
        CategoryTest.assertTrue((boolean)category.addAlgorithm(algorithm));
        CategoryTest.assertNotNull((Object)category.getAlgorithms());
        CategoryTest.assertEquals((int)1, (int)category.getAlgorithms().size());
        CategoryTest.assertEquals((Object)algorithm, category.getAlgorithms().iterator().next());
    }

    public void testAddAlgorithm2() {
        Category category = new Category(null, "Categoria 1", "Categoria 1");
        AlgorithmInfo algorithm = CategoryTest.createAlgorithm("Algoritmo 1");
        CategoryTest.assertNotNull((Object)category.getAlgorithms());
        CategoryTest.assertTrue((boolean)category.getAlgorithms().isEmpty());
        CategoryTest.assertTrue((boolean)category.addAlgorithm(algorithm));
        CategoryTest.assertNotNull((Object)category.getAlgorithms());
        CategoryTest.assertEquals((int)1, (int)category.getAlgorithms().size());
        CategoryTest.assertEquals((Object)algorithm, category.getAlgorithms().iterator().next());
        CategoryTest.assertFalse((boolean)category.addAlgorithm(algorithm));
        CategoryTest.assertNotNull((Object)category.getAlgorithms());
        CategoryTest.assertEquals((int)1, (int)category.getAlgorithms().size());
        CategoryTest.assertEquals((Object)algorithm, category.getAlgorithms().iterator().next());
    }

    public void testAddAlgorithm3() {
        Category category = new Category(null, "Categoria 1", "Categoria 1");
        CategoryTest.assertNotNull((Object)category.getAlgorithms());
        CategoryTest.assertTrue((boolean)category.getAlgorithms().isEmpty());
        try {
            category.addAlgorithm(null);
        }
        catch (IllegalArgumentException e) {
            CategoryTest.assertEquals((String)"algorithm == null", (String)e.getLocalizedMessage());
        }
        CategoryTest.assertNotNull((Object)category.getAlgorithms());
        CategoryTest.assertTrue((boolean)category.getAlgorithms().isEmpty());
    }

    public void testRemoveAlgorithm1() {
        Category category = new Category(null, "Categoria 1", "Categoria 1");
        AlgorithmInfo algorithm1 = CategoryTest.createAlgorithm("Algoritmo 1");
        AlgorithmInfo algorithm2 = CategoryTest.createAlgorithm("Algoritmo 2");
        AlgorithmInfo algorithm3 = CategoryTest.createAlgorithm("Algoritmo 3");
        CategoryTest.assertTrue((boolean)category.addAlgorithm(algorithm1));
        CategoryTest.assertTrue((boolean)category.addAlgorithm(algorithm2));
        CategoryTest.assertTrue((boolean)category.addAlgorithm(algorithm3));
        CategoryTest.assertEquals(new HashSet<AlgorithmInfo>(Arrays.asList(algorithm1, algorithm2, algorithm3)), (Object)category.getAlgorithms());
        CategoryTest.assertTrue((boolean)category.removeAlgorithm(algorithm2));
        CategoryTest.assertEquals(new HashSet<AlgorithmInfo>(Arrays.asList(algorithm1, algorithm3)), (Object)category.getAlgorithms());
    }

    public void testRemoveAlgorithm2() {
        Category category = new Category(null, "Categoria 1", "Categoria 1");
        AlgorithmInfo algorithm1 = CategoryTest.createAlgorithm("Algoritmo 1");
        CategoryTest.assertTrue((boolean)category.addAlgorithm(algorithm1));
        CategoryTest.assertEquals(new HashSet<AlgorithmInfo>(Arrays.asList(algorithm1)), (Object)category.getAlgorithms());
        CategoryTest.assertTrue((boolean)category.removeAlgorithm(algorithm1));
        CategoryTest.assertEquals(Collections.emptySet(), (Object)category.getAlgorithms());
    }

    public void testRemoveAlgorithm3() {
        Category category = new Category(null, "Categoria 1", "Categoria 1");
        AlgorithmInfo algorithm1 = CategoryTest.createAlgorithm("Algoritmo 1");
        AlgorithmInfo algorithm2 = CategoryTest.createAlgorithm("Algoritmo 2");
        CategoryTest.assertTrue((boolean)category.addAlgorithm(algorithm1));
        CategoryTest.assertTrue((boolean)category.addAlgorithm(algorithm2));
        CategoryTest.assertEquals(new HashSet<AlgorithmInfo>(Arrays.asList(algorithm1, algorithm2)), (Object)category.getAlgorithms());
        AlgorithmInfo algorithm3 = CategoryTest.createAlgorithm("Algoritmo 3");
        CategoryTest.assertFalse((boolean)category.removeAlgorithm(algorithm3));
        CategoryTest.assertEquals(new HashSet<AlgorithmInfo>(Arrays.asList(algorithm1, algorithm2)), (Object)category.getAlgorithms());
    }

    public void testRemoveAlgorithm4() {
        Category category = new Category(null, "Categoria 1", "Categoria 1");
        AlgorithmInfo algorithm1 = CategoryTest.createAlgorithm("Algoritmo 1");
        CategoryTest.assertEquals(Collections.emptySet(), (Object)category.getAlgorithms());
        CategoryTest.assertFalse((boolean)category.removeAlgorithm(algorithm1));
        CategoryTest.assertEquals(Collections.emptySet(), (Object)category.getAlgorithms());
    }

    public void testRemoveAlgorithm5() {
        Category category = new Category(null, "Categoria 1", "Categoria 1");
        CategoryTest.assertEquals(Collections.emptySet(), (Object)category.getAlgorithms());
        try {
            category.removeAlgorithm(null);
            CategoryTest.fail();
        }
        catch (IllegalArgumentException e) {
            CategoryTest.assertEquals((String)"algorithm == null", (String)e.getMessage());
        }
        CategoryTest.assertEquals(Collections.emptySet(), (Object)category.getAlgorithms());
    }

    public void testEquals1() {
        String id = "Identificador";
        String name1 = "Nome 1";
        Category category1 = new Category(null, id, name1);
        String name2 = "Nome 2";
        Category category2 = new Category(null, id, name2);
        CategoryTest.assertTrue((boolean)category1.equals((Object)category2));
    }

    public void testEquals2() {
        String name = "Nome";
        String id1 = "Identificador 1";
        Category category1 = new Category(null, id1, name);
        String id2 = "Identificador 2";
        Category category2 = new Category(null, id2, name);
        CategoryTest.assertFalse((boolean)category1.equals((Object)category2));
    }

    public void testEquals3() {
        String id = "Identificador";
        String name = "Nome";
        Category category = new Category(null, id, name);
        CategoryTest.assertFalse((boolean)category.equals(null));
    }

    public void testEquals4() {
        String id = "Identificador";
        String name = "Nome";
        Category category = new Category(null, id, name);
        CategoryTest.assertFalse((boolean)category.equals((Object)"Objeto de outra classe"));
    }

    public void testHashCode1() {
        String id = "Identificador";
        String name1 = "Nome 1";
        Category category1 = new Category(null, id, name1);
        String name2 = "Nome 2";
        Category category2 = new Category(null, id, name2);
        CategoryTest.assertEquals((Object)category1, (Object)category2);
        CategoryTest.assertEquals((int)category1.hashCode(), (int)category2.hashCode());
    }

    public void testToString1() {
        String id = "Identificador da categoria";
        String name = "Nome da categoria";
        Category category = new Category(null, id, name);
        CategoryTest.assertEquals((String)name, (String)category.toString());
    }

    public void testCompareTo1() {
        String id = "ID";
        String name = "Nome";
        Category category1 = new Category(null, id, name);
        Category category2 = new Category(null, id, name);
        CategoryTest.assertEquals((int)0, (int)category1.compareTo(category2));
    }

    public void testCompareTo2() {
        String id1 = "z";
        String name1 = "AAA";
        Category category1 = new Category(null, id1, name1);
        String id2 = "a";
        String name2 = "BBB";
        Category category2 = new Category(null, id2, name2);
        CategoryTest.assertTrue((category1.compareTo(category2) < 0 ? 1 : 0) != 0);
    }

    public void testCompareTo3() {
        String id1 = "a";
        String name1 = "BBB";
        Category category1 = new Category(null, id1, name1);
        String id2 = "z";
        String name2 = "AAA";
        Category category2 = new Category(null, id2, name2);
        CategoryTest.assertTrue((category1.compareTo(category2) > 0 ? 1 : 0) != 0);
    }

    public void testCompareTo4() {
        String id = "ID";
        String name = "Nome";
        Category category = new Category(null, id, name);
        try {
            category.compareTo(null);
            CategoryTest.fail();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    private static AlgorithmInfo createAlgorithm(String algorithmId) {
        return new AlgorithmInfo(algorithmId, "Nome de " + algorithmId, "diret\u00f3rio", "algorithms", new Hashtable());
    }
}

