/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.flows.configurator;

import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.CommandScript;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.FlowCommandLineContext;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowLink;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.LinkParameter;
import csbase.logic.algorithms.flows.NodeParameter;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class FlowAlgorithmConfiguratorTest {
    private static final String IN_PREFIX = "in";
    private static final String OUT_PREFIX = "out";
    private static final String PIPE_IN_PREFIX = ".from_";
    private static final String PIPE_OUT_PREFIX = ".to_";
    private static final String LINK_DIR_PREFIX = ".dir_";
    private static final String SCRIPT_HEADER = "#! /bin/ksh";
    private static final String LINE_SEPARATOR = "\n";
    private static final String TEST_CLIENT = "TEST_CLIENT";
    private static final String EXPORT_CLIENT_HOST = "export " + EnvironmentVariable.CLIENT_HOST + "=" + "TEST_CLIENT";

    private FlowAlgorithmConfigurator createFlow(int numNodes) {
        return this.createFlow(numNodes, false, false);
    }

    private FlowAlgorithmConfigurator createFlow(int numNodes, boolean createLinks, boolean isDir) {
        String fileType;
        FileParameterMode fileMode;
        HashSet<FlowNode> nodes = new HashSet<FlowNode>();
        HashSet<FlowLink> links = new HashSet<FlowLink>();
        if (isDir) {
            fileMode = FileParameterMode.DIRECTORY;
            fileType = "DIRECTORY";
        } else {
            fileMode = FileParameterMode.REGULAR_FILE;
            fileType = "TEXT";
        }
        for (int i = 0; i < numNodes; ++i) {
            String algorithmName = "algorithm" + i;
            AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(i, 0, 0);
            AlgorithmInfo algorithmInfo = new AlgorithmInfo("algo_id", algorithmName, algorithmName, "/algorithms", null);
            AlgorithmVersionInfo versionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, null, null);
            SimpleAlgorithmConfigurator algorithmConfigurator = new SimpleAlgorithmConfigurator(versionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "cmd", "shell", null, false, null);
            algorithmConfigurator.setHasExitCode(true);
            ParameterGroup group = new ParameterGroup("grupo");
            algorithmConfigurator.addGroup(group);
            String paramDescription = "descri\u00e7\u00e3o do par\u00e2metro";
            String paramLabel = "r\u00f3tulo do par\u00e2metro";
            String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
            InputFileParameter inputFileParameter = new InputFileParameter(IN_PREFIX + i, IN_PREFIX + paramLabel + i, IN_PREFIX + paramDescription + i, null, true, true, commandLinePattern, null, fileMode, FileParameterPipeAcceptance.TRUE, false);
            OutputFileParameter outputFileParameter = new OutputFileParameter(OUT_PREFIX + i, OUT_PREFIX + paramLabel + i, OUT_PREFIX + paramDescription + i, null, true, true, commandLinePattern, null, fileMode, FileParameterPipeAcceptance.TRUE, false, false);
            group.addParameter((Parameter)inputFileParameter);
            group.addParameter((Parameter)outputFileParameter);
            HashSet<NodeParameter> parameters = new HashSet<NodeParameter>();
            String outputFileName = this.makeFileName(i, OUT_PREFIX, isDir);
            String inputFileName = this.makeFileName(i, IN_PREFIX, isDir);
            parameters.add(new NodeParameter(OUT_PREFIX + i, OUT_PREFIX + paramLabel + i, fileType, outputFileName));
            parameters.add(new NodeParameter(IN_PREFIX + i, IN_PREFIX + paramLabel + i, fileType, inputFileName));
            FlowNode flowNode = new FlowNode(i, (AlgorithmConfigurator)algorithmConfigurator, parameters, 0, 0, 100, 100);
            nodes.add(flowNode);
            if (createLinks) {
                if (i == 0) {
                    inputFileParameter.setValue((Object)new FileParameterValue(inputFileName));
                }
                if (i < numNodes - 1) {
                    FlowLink link = new FlowLink(i, new LinkParameter(i, OUT_PREFIX + i, OUT_PREFIX + paramLabel + i), new LinkParameter(i + 1, IN_PREFIX + (i + 1), IN_PREFIX + paramLabel + (i + 1)), new ArrayList());
                    links.add(link);
                    continue;
                }
                outputFileParameter.setValue(new FileParameterValue(outputFileName));
                continue;
            }
            inputFileParameter.setValue((Object)new FileParameterValue(inputFileName));
            outputFileParameter.setValue(new FileParameterValue(outputFileName));
        }
        Flow flow = new Flow("flow", "flow_description", nodes, links);
        FlowAlgorithmConfigurator configurator = new FlowAlgorithmConfigurator(flow);
        FileParameterValue logFile = new FileParameterValue(".cmds/admi_admi_XXXXXXXXX/guilty.log");
        configurator.setGuiltyNodeLog(logFile);
        return configurator;
    }

    private FlowCommandLineContext createFlowContext(int numNodes, boolean isScript, Map<Integer, Map<String, String>> fromPipes, Map<Integer, Map<String, String>> toPipes, Map<Integer, Map<String, String>> linkDirectories) {
        String commandId = "admi@admi.XXXXXXXX";
        String platformId = "Platform";
        char fileSeparator = '/';
        String projectDirectory = "user/Project";
        String algorithmRootDirectory = "/algorithms";
        String projectRootDirectory = "/projects";
        String sandboxRootDirectory = "/tmp";
        String sandboxDirectory = "sandbox";
        String persistenceDirectory = ".cmds/admi_admi_XXXXXXXXX";
        CommandLineContext context = new CommandLineContext(commandId, platformId, fileSeparator, projectDirectory, algorithmRootDirectory, projectRootDirectory, sandboxRootDirectory, sandboxDirectory, persistenceDirectory, isScript, null, null);
        FlowCommandLineContext flowContext = FlowCommandLineContext.createFlowContext((CommandLineContext)context, fromPipes, toPipes, linkDirectories);
        int i = 0;
        while (i < numNodes) {
            int nodeId = i++;
            CommandLineContext nodeContext = new CommandLineContext(commandId, platformId, fileSeparator, projectDirectory, algorithmRootDirectory, projectRootDirectory, sandboxRootDirectory, sandboxDirectory, persistenceDirectory, isScript, Integer.valueOf(nodeId), TEST_CLIENT);
            flowContext.addFlowNodeContext(Integer.valueOf(nodeId), nodeContext);
        }
        return flowContext;
    }

    private Map<Integer, Map<String, String>> getFromPipes(int numNodes) {
        HashMap<Integer, Map<String, String>> allFromPipes = new HashMap<Integer, Map<String, String>>();
        for (int i = 0; i < numNodes - 1; ++i) {
            HashMap<String, String> fromPipes = new HashMap<String, String>();
            String fromPipe = this.makeLinkPath(i, PIPE_OUT_PREFIX, OUT_PREFIX, "");
            fromPipes.put(OUT_PREFIX + i, fromPipe);
            allFromPipes.put(i, fromPipes);
        }
        return allFromPipes;
    }

    private Map<Integer, Map<String, String>> getLinkDirs(int numNodes) {
        HashMap<Integer, Map<String, String>> linkDirs = new HashMap<Integer, Map<String, String>>();
        for (int i = 0; i < numNodes; ++i) {
            String dir;
            HashMap<String, String> dirs = new HashMap<String, String>();
            if (i < numNodes - 1) {
                dir = this.makeLinkPath(i, LINK_DIR_PREFIX, OUT_PREFIX, "");
                dirs.put(OUT_PREFIX + i, dir);
            }
            if (i > 0) {
                dir = this.makeLinkPath(i - 1, LINK_DIR_PREFIX, OUT_PREFIX, "");
                dirs.put(IN_PREFIX + i, dir);
            }
            linkDirs.put(i, dirs);
        }
        return linkDirs;
    }

    private Map<Integer, Map<String, String>> getToPipes(int numNodes) {
        HashMap<Integer, Map<String, String>> allToPipes = new HashMap<Integer, Map<String, String>>();
        for (int i = 1; i < numNodes; ++i) {
            HashMap<String, String> toPipes = new HashMap<String, String>();
            String toPipe = this.makeLinkPath(i, PIPE_IN_PREFIX, IN_PREFIX, "");
            toPipes.put(IN_PREFIX + i, toPipe);
            allToPipes.put(i, toPipes);
        }
        return allToPipes;
    }

    private String makeFileName(int id, String prefix, boolean isDir) {
        if (isDir) {
            return prefix + "_dir" + id;
        }
        return prefix + "_file" + id + ".txt";
    }

    private String makeFilePath(int id, String prefix, String escapeString) {
        return this.makeFilePath(id, prefix, escapeString, false);
    }

    private String makeFilePath(int id, String prefix, String escapeString, boolean isDir) {
        String fileName = this.makeFileName(id, prefix, isDir);
        return escapeString + "$CSBASE_PROJ_DIR/" + fileName;
    }

    private StringBuffer makeFlowCommandLine(int numNodes, boolean hasPipes, String escapeString, String lineSeparator) {
        String fromPipe;
        int i;
        StringBuffer flowCmd = new StringBuffer();
        flowCmd.append("export CSBASE_FLOW_GUILTY_NODE_ID_LOG=/projects/user/Project/.cmds/admi_admi_XXXXXXXXX/guilty.log;");
        flowCmd.append(lineSeparator);
        flowCmd.append("export CSBASE_FLOW_SANDBOX_DIR=/tmp/sandbox;");
        flowCmd.append(lineSeparator);
        flowCmd.append("/bin/ksh ./flowmonitor ");
        flowCmd.append("\"");
        if (hasPipes) {
            for (i = 0; i < numNodes - 1; ++i) {
                fromPipe = this.makeLinkPath(i, PIPE_OUT_PREFIX, OUT_PREFIX, escapeString);
                flowCmd.append(fromPipe);
                flowCmd.append(" ");
            }
            for (i = 1; i < numNodes; ++i) {
                String toPipe = this.makeLinkPath(i, PIPE_IN_PREFIX, IN_PREFIX, escapeString);
                flowCmd.append(toPipe);
                flowCmd.append(" ");
            }
        }
        flowCmd.append("\" ");
        flowCmd.append("\"");
        if (hasPipes) {
            for (i = 1; i < numNodes; ++i) {
                flowCmd.append(-i);
                flowCmd.append(" ");
            }
        }
        for (i = 0; i < numNodes; ++i) {
            flowCmd.append(i);
            flowCmd.append(" ");
        }
        flowCmd.append("\"");
        if (hasPipes) {
            for (i = 0; i < numNodes - 1; ++i) {
                fromPipe = this.makeLinkPath(i, PIPE_OUT_PREFIX, OUT_PREFIX, escapeString);
                String toPipe = this.makeLinkPath(i + 1, PIPE_IN_PREFIX, IN_PREFIX, escapeString);
                flowCmd.append(" \"tee " + toPipe + " < " + fromPipe + " > /dev/null\"");
            }
        }
        return flowCmd;
    }

    private String makeNodeCommandLine(int nodeId, String inputFile, String outputFile) {
        return this.makeNodeCommandLine(nodeId, " ", "\\", inputFile, outputFile);
    }

    private String makeNodeCommandLine(int nodeId, String lineSeparator, String escapeString, String inputFile, String outputFile) {
        StringBuilder cmd = new StringBuilder();
        cmd.append("export CSBASE_FLOW_NODE_ID=" + nodeId);
        String cmdSeparator = ";";
        cmd.append(cmdSeparator);
        cmd.append(lineSeparator);
        cmd.append("export CSBASE_BIN_DIR=/algorithms/algorithm" + nodeId + "/versions/v_00" + nodeId + "_000_000/bin/Platform");
        cmd.append(cmdSeparator);
        cmd.append(lineSeparator);
        cmd.append("export CSBASE_PROJ_DIR=/projects/user/Project");
        cmd.append(cmdSeparator);
        cmd.append(lineSeparator);
        cmd.append("export CSBASE_SANDBOX_DIR=/tmp/sandbox");
        cmd.append(cmdSeparator);
        cmd.append(lineSeparator);
        cmd.append("export CSBASE_EXECUTION_DIR=" + escapeString + "$CSBASE_BIN_DIR");
        cmd.append(cmdSeparator);
        cmd.append(lineSeparator);
        cmd.append(EXPORT_CLIENT_HOST);
        cmd.append(cmdSeparator);
        cmd.append(lineSeparator);
        cmd.append("export CSBASE_INPUT_FILES=" + inputFile);
        cmd.append(cmdSeparator);
        cmd.append(lineSeparator);
        cmd.append("export CSBASE_OUTPUT_FILES=" + outputFile);
        cmd.append(cmdSeparator);
        cmd.append(lineSeparator);
        cmd.append("( cd " + escapeString + "$CSBASE_EXECUTION_DIR && ( shell " + escapeString + "$CSBASE_BIN_DIR/cmd ");
        cmd.append(IN_PREFIX + nodeId + "=" + inputFile + " " + OUT_PREFIX + nodeId + "=" + outputFile + " ))");
        cmd.append(" > /dev/null 2>&1");
        return cmd.toString();
    }

    private String makeNodeCommandLineAsScript(int nodeId, String inputFile, String outputFile) {
        StringBuilder nodeCmd = new StringBuilder();
        nodeCmd.append(SCRIPT_HEADER);
        nodeCmd.append(LINE_SEPARATOR);
        nodeCmd.append(this.makeNodeCommandLine(nodeId, LINE_SEPARATOR, "", inputFile, outputFile));
        return nodeCmd.toString();
    }

    private String makeLinkPath(int id, String prefix, String paramPrefix, String escapeString) {
        return escapeString + "$CSBASE_FLOW_SANDBOX_DIR/" + prefix + id + "_" + paramPrefix + id;
    }

    @Test
    public void testCanBeRunAsSimpleCommandWithEmptyFlow() {
        FlowAlgorithmConfigurator configurator = this.createFlow(0);
        boolean canBeRunAsSimpleCommand = configurator.canBeRunAsSimpleCommand();
        Assert.assertTrue((boolean)canBeRunAsSimpleCommand);
    }

    @Test
    public void testCanBeRunAsSimpleCommandWithMultipleNodesFlow() {
        FlowAlgorithmConfigurator configurator = this.createFlow(3);
        boolean canBeRunAsSimpleCommand = configurator.canBeRunAsSimpleCommand();
        Assert.assertFalse((boolean)canBeRunAsSimpleCommand);
    }

    @Test
    public void testCanBeRunAsSimpleCommandWithSingleNodeFlow() {
        FlowAlgorithmConfigurator configurator = this.createFlow(1);
        boolean canBeRunAsSimpleCommand = configurator.canBeRunAsSimpleCommand();
        Assert.assertTrue((boolean)canBeRunAsSimpleCommand);
    }

    @Test
    public void testMakeCommandLineAsScriptWithoutLinks() {
        int numNodes = 5;
        FlowAlgorithmConfigurator configurator = this.createFlow(numNodes);
        String escapeString = "";
        FlowCommandLineContext context = this.createFlowContext(numNodes, true, null, null, null);
        StringBuilder flowCmd = new StringBuilder();
        flowCmd.append(SCRIPT_HEADER);
        flowCmd.append(LINE_SEPARATOR);
        flowCmd.append(this.makeFlowCommandLine(numNodes, false, escapeString, LINE_SEPARATOR));
        for (int i = 0; i < numNodes; ++i) {
            flowCmd.append(" \"/bin/ksh .cmds/admi_admi_XXXXXXXXX/script" + i + "\"");
        }
        flowCmd.append(LINE_SEPARATOR);
        CommandScript[] scripts = configurator.makeCommandLineAsScript((CommandLineContext)context);
        Assert.assertEquals((long)(numNodes + 1), (long)scripts.length);
        Assert.assertEquals((Object)flowCmd.toString(), (Object)scripts[0].getScriptContent());
        for (int i = 0; i < numNodes; ++i) {
            String nodeCmdLine = this.makeNodeCommandLineAsScript(i, this.makeFilePath(i, IN_PREFIX, escapeString), this.makeFilePath(i, OUT_PREFIX, escapeString));
            Assert.assertEquals((Object)nodeCmdLine, (Object)scripts[i + 1].getScriptContent());
            Assert.assertEquals((Object)("script" + i), (Object)scripts[i + 1].getFileName());
        }
    }

    @Test
    public void testMakeCommandLineAsScriptWithPipeLinks() {
        int i;
        int numNodes = 5;
        FlowAlgorithmConfigurator configurator = this.createFlow(numNodes, true, false);
        String escapeString = "";
        Map<Integer, Map<String, String>> fromPipes = this.getFromPipes(numNodes);
        Map<Integer, Map<String, String>> toPipes = this.getToPipes(numNodes);
        FlowCommandLineContext context = this.createFlowContext(numNodes, true, fromPipes, toPipes, null);
        CommandScript[] scripts = configurator.makeCommandLineAsScript((CommandLineContext)context);
        Assert.assertEquals((long)(numNodes + 1), (long)scripts.length);
        StringBuffer flowCmd = new StringBuffer();
        flowCmd.append(SCRIPT_HEADER);
        flowCmd.append(LINE_SEPARATOR);
        flowCmd.append(this.makeFlowCommandLine(numNodes, true, escapeString, LINE_SEPARATOR));
        for (i = 0; i < numNodes; ++i) {
            flowCmd.append(" \"/bin/ksh .cmds/admi_admi_XXXXXXXXX/script" + i + "\"");
        }
        flowCmd.append(LINE_SEPARATOR);
        Assert.assertEquals((Object)flowCmd.toString(), (Object)scripts[0].getScriptContent());
        for (i = 0; i < numNodes; ++i) {
            String inputFile;
            String outputFile;
            if (i == 0) {
                outputFile = this.makeLinkPath(i, PIPE_OUT_PREFIX, OUT_PREFIX, escapeString);
                inputFile = this.makeFilePath(i, IN_PREFIX, escapeString);
            } else if (i < numNodes - 1) {
                outputFile = this.makeLinkPath(i, PIPE_OUT_PREFIX, OUT_PREFIX, escapeString);
                inputFile = this.makeLinkPath(i, PIPE_IN_PREFIX, IN_PREFIX, escapeString);
            } else {
                outputFile = this.makeFilePath(i, OUT_PREFIX, escapeString);
                inputFile = this.makeLinkPath(i, PIPE_IN_PREFIX, IN_PREFIX, escapeString);
            }
            String nodeCmdLine = this.makeNodeCommandLineAsScript(i, inputFile, outputFile);
            Assert.assertEquals((Object)nodeCmdLine, (Object)scripts[i + 1].getScriptContent());
            Assert.assertEquals((Object)("script" + i), (Object)scripts[i + 1].getFileName());
        }
    }

    @Test
    public void testMakeCommandLineWithoutLinks() {
        int numNodes = 5;
        FlowAlgorithmConfigurator configurator = this.createFlow(numNodes);
        FlowCommandLineContext context = this.createFlowContext(numNodes, false, null, null, null);
        StringBuilder cmd = new StringBuilder();
        String escapeString = "\\";
        cmd.append(this.makeFlowCommandLine(numNodes, false, escapeString, " "));
        for (int i = 0; i < numNodes; ++i) {
            cmd.append(" \"" + this.makeNodeCommandLine(i, this.makeFilePath(i, IN_PREFIX, escapeString), this.makeFilePath(i, OUT_PREFIX, escapeString)) + "\"");
        }
        cmd.append(" ");
        String cmdLine = configurator.makeCommandLine((CommandLineContext)context);
        Assert.assertEquals((Object)cmd.toString(), (Object)cmdLine);
    }

    @Test
    public void testMakeCommandLineWithPipeLinks() {
        int numNodes = 5;
        FlowAlgorithmConfigurator configurator = this.createFlow(numNodes, true, false);
        String escapeString = "\\";
        Map<Integer, Map<String, String>> fromPipes = this.getFromPipes(numNodes);
        Map<Integer, Map<String, String>> toPipes = this.getToPipes(numNodes);
        StringBuffer flowCmd = this.makeFlowCommandLine(numNodes, true, escapeString, " ");
        for (int i = 0; i < numNodes; ++i) {
            String inputFile;
            String outputFile;
            if (i == 0) {
                outputFile = this.makeLinkPath(i, PIPE_OUT_PREFIX, OUT_PREFIX, escapeString);
                inputFile = this.makeFilePath(i, IN_PREFIX, escapeString);
            } else if (i < numNodes - 1) {
                outputFile = this.makeLinkPath(i, PIPE_OUT_PREFIX, OUT_PREFIX, escapeString);
                inputFile = this.makeLinkPath(i, PIPE_IN_PREFIX, IN_PREFIX, escapeString);
            } else {
                outputFile = this.makeFilePath(i, OUT_PREFIX, escapeString);
                inputFile = this.makeLinkPath(i, PIPE_IN_PREFIX, IN_PREFIX, escapeString);
            }
            flowCmd.append(" \"" + this.makeNodeCommandLine(i, inputFile, outputFile) + "\"");
        }
        flowCmd.append(" ");
        FlowCommandLineContext context = this.createFlowContext(numNodes, false, fromPipes, toPipes, null);
        String cmd = configurator.makeCommandLine((CommandLineContext)context);
        Assert.assertEquals((Object)flowCmd.toString(), (Object)cmd);
    }

    @Test
    public void testMakeCommandLineWithLinkDirs() {
        int numNodes = 5;
        FlowAlgorithmConfigurator configurator = this.createFlow(numNodes, true, true);
        String escapeString = "\\";
        StringBuffer flowCmd = this.makeFlowCommandLine(numNodes, false, escapeString, " ");
        for (int i = 0; i < numNodes; ++i) {
            String inputFile;
            String outputFile;
            if (i == 0) {
                outputFile = this.makeLinkPath(i, LINK_DIR_PREFIX, OUT_PREFIX, escapeString);
                inputFile = this.makeFilePath(i, IN_PREFIX, escapeString, true);
            } else if (i < numNodes - 1) {
                outputFile = this.makeLinkPath(i, LINK_DIR_PREFIX, OUT_PREFIX, escapeString);
                inputFile = this.makeLinkPath(i - 1, LINK_DIR_PREFIX, OUT_PREFIX, escapeString);
            } else {
                outputFile = this.makeFilePath(i, OUT_PREFIX, escapeString, true);
                inputFile = this.makeLinkPath(i - 1, LINK_DIR_PREFIX, OUT_PREFIX, escapeString);
            }
            flowCmd.append(" \"" + this.makeNodeCommandLine(i, inputFile, outputFile) + "\"");
        }
        flowCmd.append(" ");
        Map<Integer, Map<String, String>> linkDirs = this.getLinkDirs(numNodes);
        FlowCommandLineContext context = this.createFlowContext(numNodes, false, null, null, linkDirs);
        String cmd = configurator.makeCommandLine((CommandLineContext)context);
        Assert.assertEquals((Object)flowCmd.toString(), (Object)cmd);
    }

    @Test
    public void testMakeCommandLineAsScriptWithLinkDirs() {
        int i;
        int numNodes = 5;
        FlowAlgorithmConfigurator configurator = this.createFlow(numNodes, true, true);
        String escapeString = "";
        Map<Integer, Map<String, String>> linkDirs = this.getLinkDirs(numNodes);
        FlowCommandLineContext context = this.createFlowContext(numNodes, true, null, null, linkDirs);
        CommandScript[] scripts = configurator.makeCommandLineAsScript((CommandLineContext)context);
        Assert.assertEquals((long)(numNodes + 1), (long)scripts.length);
        StringBuffer flowCmd = new StringBuffer();
        flowCmd.append(SCRIPT_HEADER);
        flowCmd.append(LINE_SEPARATOR);
        flowCmd.append(this.makeFlowCommandLine(numNodes, false, escapeString, LINE_SEPARATOR));
        for (i = 0; i < numNodes; ++i) {
            flowCmd.append(" \"/bin/ksh .cmds/admi_admi_XXXXXXXXX/script" + i + "\"");
        }
        flowCmd.append(LINE_SEPARATOR);
        Assert.assertEquals((long)(numNodes + 1), (long)scripts.length);
        Assert.assertEquals((Object)flowCmd.toString(), (Object)scripts[0].getScriptContent());
        for (i = 0; i < numNodes; ++i) {
            String inputFile;
            String outputFile;
            if (i == 0) {
                outputFile = this.makeLinkPath(i, LINK_DIR_PREFIX, OUT_PREFIX, escapeString);
                inputFile = this.makeFilePath(i, IN_PREFIX, escapeString, true);
            } else if (i < numNodes - 1) {
                outputFile = this.makeLinkPath(i, LINK_DIR_PREFIX, OUT_PREFIX, escapeString);
                inputFile = this.makeLinkPath(i - 1, LINK_DIR_PREFIX, OUT_PREFIX, escapeString);
            } else {
                outputFile = this.makeFilePath(i, OUT_PREFIX, escapeString, true);
                inputFile = this.makeLinkPath(i - 1, LINK_DIR_PREFIX, OUT_PREFIX, escapeString);
            }
            String nodeCmdLine = this.makeNodeCommandLineAsScript(i, inputFile, outputFile);
            Assert.assertEquals((Object)nodeCmdLine, (Object)scripts[i + 1].getScriptContent());
            Assert.assertEquals((Object)("script" + i), (Object)scripts[i + 1].getFileName());
        }
    }
}

