/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BooleanColumn;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;

public final class BooleanColumnTest
extends TestCase {
    public void testBooleanColumn1() {
        String id = "Idenficador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        boolean isEditable = true;
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, isEditable, null, null);
        BooleanColumnTest.assertEquals((String)id, (String)column.getId());
        BooleanColumnTest.assertEquals((String)label, (String)column.getLabel());
        BooleanColumnTest.assertFalse((boolean)column.isOptional());
        BooleanColumnTest.assertEquals((Object)new Boolean(defaultValue), (Object)column.getDefaultValue(0));
        BooleanColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        BooleanColumnTest.assertEquals((String)"1", (String)column.getTrueCommand());
        BooleanColumnTest.assertEquals((String)"0", (String)column.getFalseCommand());
    }

    public void testBooleanColumn2() {
        String id = "Idenficador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = true;
        boolean isEditable = true;
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, isEditable, null, null);
        BooleanColumnTest.assertEquals((String)id, (String)column.getId());
        BooleanColumnTest.assertEquals((String)label, (String)column.getLabel());
        BooleanColumnTest.assertFalse((boolean)column.isOptional());
        BooleanColumnTest.assertEquals((Object)new Boolean(defaultValue), (Object)column.getDefaultValue(0));
        BooleanColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        BooleanColumnTest.assertEquals((String)"1", (String)column.getTrueCommand());
        BooleanColumnTest.assertEquals((String)"0", (String)column.getFalseCommand());
    }

    public void testBooleanColumn3() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        boolean isEditable = false;
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, isEditable, null, null);
        BooleanColumnTest.assertEquals((String)id, (String)column.getId());
        BooleanColumnTest.assertEquals((String)label, (String)column.getLabel());
        BooleanColumnTest.assertFalse((boolean)column.isOptional());
        BooleanColumnTest.assertEquals((Object)new Boolean(defaultValue), (Object)column.getDefaultValue(0));
        BooleanColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        BooleanColumnTest.assertEquals((String)"1", (String)column.getTrueCommand());
        BooleanColumnTest.assertEquals((String)"0", (String)column.getFalseCommand());
    }

    public void testBooleanColumn4() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = true;
        boolean isEditable = false;
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, isEditable, null, null);
        BooleanColumnTest.assertEquals((String)id, (String)column.getId());
        BooleanColumnTest.assertEquals((String)label, (String)column.getLabel());
        BooleanColumnTest.assertFalse((boolean)column.isOptional());
        BooleanColumnTest.assertEquals((Object)new Boolean(defaultValue), (Object)column.getDefaultValue(0));
        BooleanColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        BooleanColumnTest.assertEquals((String)"1", (String)column.getTrueCommand());
        BooleanColumnTest.assertEquals((String)"0", (String)column.getFalseCommand());
    }

    public void testBooleanColumn5() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = true;
        boolean isEditable = true;
        String trueCommand = "COMANDO_VERDADEIRO";
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, isEditable, null, trueCommand);
        BooleanColumnTest.assertEquals((String)id, (String)column.getId());
        BooleanColumnTest.assertEquals((String)label, (String)column.getLabel());
        BooleanColumnTest.assertFalse((boolean)column.isOptional());
        BooleanColumnTest.assertEquals((Object)new Boolean(defaultValue), (Object)column.getDefaultValue(0));
        BooleanColumnTest.assertEquals((String)trueCommand, (String)column.getTrueCommand());
        BooleanColumnTest.assertEquals((String)"0", (String)column.getFalseCommand());
    }

    public void testBooleanColumn6() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        boolean isEditable = true;
        String falseCommand = "COMANDO_FALSO";
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, isEditable, falseCommand, null);
        BooleanColumnTest.assertEquals((String)id, (String)column.getId());
        BooleanColumnTest.assertEquals((String)label, (String)column.getLabel());
        BooleanColumnTest.assertFalse((boolean)column.isOptional());
        BooleanColumnTest.assertEquals((Object)new Boolean(defaultValue), (Object)column.getDefaultValue(0));
        BooleanColumnTest.assertEquals((String)"1", (String)column.getTrueCommand());
        BooleanColumnTest.assertEquals((String)falseCommand, (String)column.getFalseCommand());
    }

    public void testBooleanColumn7() {
        try {
            new BooleanColumn("ID", null, false, true, null, null);
            BooleanColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar uma coluna com nome nulo.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBooleanColumn8() {
        try {
            new BooleanColumn(null, "R\u00f3tulo", false, true, null, null);
            BooleanColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar uma coluna com nome nulo.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetCommandValue1() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        String falseCommand = "COMANDO_FALSO";
        String trueCommand = "COMANDO_VERDADEIRO";
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, true, falseCommand, trueCommand);
        BooleanColumnTest.assertEquals((String)trueCommand, (String)column.getTrueCommand());
        BooleanColumnTest.assertEquals((String)falseCommand, (String)column.getFalseCommand());
        BooleanColumnTest.assertEquals((String)trueCommand, (String)column.getCommandValue(new Boolean(true)));
    }

    public void testGetCommandValue2() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        String falseCommand = "COMANDO_FALSO";
        String trueCommand = "COMANDO_VERDADEIRO";
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, true, falseCommand, trueCommand);
        BooleanColumnTest.assertEquals((String)trueCommand, (String)column.getTrueCommand());
        BooleanColumnTest.assertEquals((String)falseCommand, (String)column.getFalseCommand());
        BooleanColumnTest.assertEquals((String)falseCommand, (String)column.getCommandValue(new Boolean(false)));
    }

    public void testGetCommandValue3() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        String falseCommand = "COMANDO_FALSO";
        String trueCommand = "COMANDO_VERDADEIRO";
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, true, falseCommand, trueCommand);
        try {
            BooleanColumnTest.assertNull((Object)column.getCommandValue(null));
            BooleanColumnTest.fail((String)"Esperada IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testGetItemValueAsText1() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        String falseCommand = "COMANDO_FALSO";
        String trueCommand = "COMANDO_VERDADEIRO";
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, true, falseCommand, trueCommand);
        BooleanColumnTest.assertEquals((String)"true", (String)column.getItemValueAsText((Object)true));
    }

    public void testGetItemValueAsText2() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        String falseCommand = "COMANDO_FALSO";
        String trueCommand = "COMANDO_VERDADEIRO";
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, true, falseCommand, trueCommand);
        BooleanColumnTest.assertEquals((String)"false", (String)column.getItemValueAsText((Object)false));
    }

    public void testGetItemValueAsText3() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        String falseCommand = "COMANDO_FALSO";
        String trueCommand = "COMANDO_VERDADEIRO";
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, true, falseCommand, trueCommand);
        BooleanColumnTest.assertNull((Object)column.getItemValueAsText(null));
    }

    public void testGetItemValueFromText1() throws ParseException {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        String falseCommand = "COMANDO_FALSO";
        String trueCommand = "COMANDO_VERDADEIRO";
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, true, falseCommand, trueCommand);
        BooleanColumnTest.assertEquals((Object)new Boolean(true), (Object)column.getItemValueFromText("true"));
    }

    public void testGetItemValueFromText2() throws ParseException {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        String falseCommand = "COMANDO_FALSO";
        String trueCommand = "COMANDO_VERDADEIRO";
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, true, falseCommand, trueCommand);
        BooleanColumnTest.assertEquals((Object)new Boolean(false), (Object)column.getItemValueFromText("false"));
    }

    public void testGetItemValueFromText3() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        String falseCommand = "COMANDO_FALSO";
        String trueCommand = "COMANDO_VERDADEIRO";
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, true, falseCommand, trueCommand);
        try {
            column.getItemValueFromText(null);
            BooleanColumnTest.fail();
        }
        catch (ParseException e) {
            // empty catch block
        }
    }

    public void testGetItemValueFromText4() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = false;
        String falseCommand = "COMANDO_FALSO";
        String trueCommand = "COMANDO_VERDADEIRO";
        BooleanColumn column = new BooleanColumn(id, label, defaultValue, true, falseCommand, trueCommand);
        try {
            column.getItemValueFromText("valor n\u00e3o-booleano");
            BooleanColumnTest.fail();
        }
        catch (ParseException e) {
            // empty catch block
        }
    }

    public void testSerialize() throws IOException, ClassNotFoundException {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean defaultValue = true;
        String trueCommand = "COMANDO_VERDADEIRO";
        String falseCommand = "COMANDO_FALSO";
        BooleanColumn outputColumn = new BooleanColumn(id, label, defaultValue, true, falseCommand, trueCommand);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputColumn);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        BooleanColumn inputColumn = (BooleanColumn)objectInput.readObject();
        BooleanColumnTest.assertEquals((String)outputColumn.getId(), (String)inputColumn.getId());
        BooleanColumnTest.assertEquals((String)outputColumn.getLabel(), (String)inputColumn.getLabel());
        BooleanColumnTest.assertEquals((boolean)outputColumn.isOptional(), (boolean)inputColumn.isOptional());
        BooleanColumnTest.assertEquals((Object)outputColumn.getDefaultValue(0), (Object)inputColumn.getDefaultValue(0));
        BooleanColumnTest.assertEquals((String)outputColumn.getFalseCommand(), (String)inputColumn.getFalseCommand());
        BooleanColumnTest.assertEquals((String)outputColumn.getTrueCommand(), (String)inputColumn.getTrueCommand());
    }
}

