/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.validators.DoubleParameterValidator;
import csbase.logic.algorithms.parameters.validators.ListParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public final class DoubleListParameterTest {
    @Test
    public void testDoubleListParameterWithTrueIsOptional() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = 10.1;
        boolean isMaximumIncluded = true;
        Double minimum = 1.1;
        boolean isMinimumIncluded = true;
        DoubleListParameter parameter = new DoubleListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
        this.assertEquals(name, label, description, isOptional, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded, parameter);
    }

    @Test
    public void testDoubleListParameterWithFalseIsOptional() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Double maximum = 10.1;
        boolean isMaximumIncluded = true;
        Double minimum = 1.1;
        boolean isMinimumIncluded = true;
        DoubleListParameter parameter = new DoubleListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
        this.assertEquals(name, label, description, isOptional, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded, parameter);
    }

    @Test
    public void testDoubleListParameterWithNullMaximum() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Double maximum = null;
        boolean isMaximumIncluded = false;
        Double minimum = 1.1;
        boolean isMinimumIncluded = true;
        DoubleListParameter parameter = new DoubleListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
        this.assertEquals(name, label, description, isOptional, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded, parameter);
    }

    @Test
    public void testDoubleListParameterWithNullMinimum() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Double maximum = 10.1;
        boolean isMaximumIncluded = true;
        Double minimum = null;
        boolean isMinimumIncluded = false;
        DoubleListParameter parameter = new DoubleListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
        this.assertEquals(name, label, description, isOptional, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded, parameter);
    }

    @Test
    public void testDoubleListParameterWithFalseIsMaximumIncluded() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Double maximum = 10.1;
        boolean isMaximumIncluded = false;
        Double minimum = 1.1;
        boolean isMinimumIncluded = true;
        DoubleListParameter parameter = new DoubleListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
        this.assertEquals(name, label, description, isOptional, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded, parameter);
    }

    @Test
    public void testDoubleListParameterWithFalseIsMinimumIncluded() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Double maximum = 10.1;
        boolean isMaximumIncluded = true;
        Double minimum = 1.1;
        boolean isMinimumIncluded = false;
        DoubleListParameter parameter = new DoubleListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
        this.assertEquals(name, label, description, isOptional, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded, parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDoubleListParameterWithMinimumLargerThanMaximum() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Double maximum = 10.1;
        boolean isMaximumIncluded = true;
        Double minimum = 12.12;
        boolean isMinimumIncluded = false;
        new DoubleListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
    }

    @Test
    public void testSetMaximumWithValidValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Boolean maximumIncluded = true;
        Double maximum = 10.0;
        DoubleListParameter parameter = new DoubleListParameter(name, label, description, null, false, true, null, maximum, maximumIncluded.booleanValue(), Double.valueOf(0.0), true);
        ArrayList<Double> value = new ArrayList<Double>();
        value.add(2.0);
        value.add(5.0);
        parameter.setValue(value);
        ListParameterValidator listParameterValidator = (ListParameterValidator)parameter.getParameterValidator();
        DoubleParameterValidator validator = (DoubleParameterValidator)listParameterValidator.getItemValidator();
        Double newMaximum = 6.0;
        boolean valueWasSet = parameter.setMaximum(newMaximum, maximumIncluded.booleanValue());
        Assert.assertTrue((boolean)valueWasSet);
        Assert.assertEquals((Object)newMaximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)maximumIncluded, (Object)parameter.isMaximumIncluded());
        Assert.assertEquals((Object)newMaximum, (Object)validator.getMaximum());
        Assert.assertEquals((Object)maximumIncluded, (Object)validator.isMaximumIncluded());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = parameter.validate(context);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testSetMaximumWithInvalidValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Boolean maximumIncluded = true;
        Double maximum = 10.0;
        DoubleListParameter parameter = new DoubleListParameter(name, label, description, null, false, true, null, maximum, maximumIncluded.booleanValue(), Double.valueOf(0.0), true);
        ArrayList<Double> value = new ArrayList<Double>();
        value.add(2.0);
        value.add(5.0);
        parameter.setValue(value);
        ListParameterValidator listParameterValidator = (ListParameterValidator)parameter.getParameterValidator();
        DoubleParameterValidator validator = (DoubleParameterValidator)listParameterValidator.getItemValidator();
        Double newMaximum = 4.0;
        boolean valueWasSet = parameter.setMaximum(newMaximum, maximumIncluded.booleanValue());
        Assert.assertTrue((boolean)valueWasSet);
        Assert.assertEquals((Object)newMaximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)maximumIncluded, (Object)parameter.isMaximumIncluded());
        Assert.assertEquals((Object)maximumIncluded, (Object)validator.isMaximumIncluded());
        Assert.assertEquals((Object)newMaximum, (Object)validator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = parameter.validate(context);
        Assert.assertFalse((boolean)result.isWellSucceded());
    }

    @Test
    public void testSetMaximWithNonIncludedMaximumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Boolean maximumIncluded = true;
        Double maximum = 10.0;
        DoubleListParameter parameter = new DoubleListParameter(name, label, description, null, false, true, null, maximum, maximumIncluded.booleanValue(), Double.valueOf(0.0), true);
        ArrayList<Double> value = new ArrayList<Double>();
        value.add(2.0);
        value.add(5.0);
        parameter.setValue(value);
        ListParameterValidator listParameterValidator = (ListParameterValidator)parameter.getParameterValidator();
        DoubleParameterValidator validator = (DoubleParameterValidator)listParameterValidator.getItemValidator();
        Double newMaximum = 5.0;
        Boolean newMinimumIncluded = false;
        boolean valueWasSet = parameter.setMaximum(newMaximum, newMinimumIncluded.booleanValue());
        Assert.assertTrue((boolean)valueWasSet);
        Assert.assertEquals((Object)newMaximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)newMinimumIncluded, (Object)parameter.isMaximumIncluded());
        Assert.assertEquals((Object)newMinimumIncluded, (Object)validator.isMaximumIncluded());
        Assert.assertEquals((Object)newMaximum, (Object)validator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = parameter.validate(context);
        Assert.assertFalse((boolean)result.isWellSucceded());
    }

    @Test
    public void testSetMinimumWithValidValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Boolean minimumIncluded = true;
        Double minimum = 0.0;
        DoubleListParameter parameter = new DoubleListParameter(name, label, description, null, false, true, null, Double.valueOf(10.0), true, minimum, minimumIncluded.booleanValue());
        ArrayList<Double> value = new ArrayList<Double>();
        value.add(5.0);
        value.add(8.0);
        parameter.setValue(value);
        ListParameterValidator listParameterValidator = (ListParameterValidator)parameter.getParameterValidator();
        DoubleParameterValidator validator = (DoubleParameterValidator)listParameterValidator.getItemValidator();
        Double newMinimum = 4.0;
        boolean valueWasSet = parameter.setMinimum(newMinimum, minimumIncluded.booleanValue());
        Assert.assertTrue((boolean)valueWasSet);
        Assert.assertEquals((Object)newMinimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)minimumIncluded, (Object)parameter.isMinimumIncluded());
        Assert.assertEquals((Object)minimumIncluded, (Object)validator.isMinimumIncluded());
        Assert.assertEquals((Object)newMinimum, (Object)validator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = parameter.validate(context);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testSetMinimumWithInvalidValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Boolean minimumIncluded = true;
        Double minimum = 0.0;
        DoubleListParameter parameter = new DoubleListParameter(name, label, description, null, false, true, null, Double.valueOf(10.0), true, minimum, minimumIncluded.booleanValue());
        ArrayList<Double> value = new ArrayList<Double>();
        value.add(5.0);
        value.add(8.0);
        parameter.setValue(value);
        ListParameterValidator listParameterValidator = (ListParameterValidator)parameter.getParameterValidator();
        DoubleParameterValidator validator = (DoubleParameterValidator)listParameterValidator.getItemValidator();
        Double newMinimum = 6.0;
        boolean valueWasSet = parameter.setMinimum(newMinimum, minimumIncluded.booleanValue());
        Assert.assertTrue((boolean)valueWasSet);
        Assert.assertEquals((Object)newMinimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)minimumIncluded, (Object)parameter.isMinimumIncluded());
        Assert.assertEquals((Object)minimumIncluded, (Object)validator.isMinimumIncluded());
        Assert.assertEquals((Object)newMinimum, (Object)validator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = parameter.validate(context);
        Assert.assertFalse((boolean)result.isWellSucceded());
    }

    @Test
    public void testSetMinimumWithNonIncludedMinimumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Boolean minimumIncluded = true;
        Double minimum = 0.0;
        DoubleListParameter parameter = new DoubleListParameter(name, label, description, null, false, true, null, Double.valueOf(10.0), true, minimum, minimumIncluded.booleanValue());
        ArrayList<Double> value = new ArrayList<Double>();
        value.add(5.0);
        value.add(8.0);
        parameter.setValue(value);
        ListParameterValidator listParameterValidator = (ListParameterValidator)parameter.getParameterValidator();
        DoubleParameterValidator validator = (DoubleParameterValidator)listParameterValidator.getItemValidator();
        Boolean newMinimumIncluded = false;
        Double newMinimum = 5.0;
        boolean valueWasSet = parameter.setMinimum(newMinimum, newMinimumIncluded.booleanValue());
        Assert.assertTrue((boolean)valueWasSet);
        Assert.assertEquals((Object)newMinimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)newMinimumIncluded, (Object)parameter.isMinimumIncluded());
        Assert.assertEquals((Object)newMinimum, (Object)validator.getMinimum());
        Assert.assertEquals((Object)newMinimumIncluded, (Object)validator.isMinimumIncluded());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = parameter.validate(context);
        Assert.assertFalse((boolean)result.isWellSucceded());
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = new Double(10.1);
        boolean isMaximumIncluded = true;
        Double minimum = new Double(1.1);
        boolean isMinimumIncluded = true;
        DoubleListParameter outputParameter = new DoubleListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputParameter);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        DoubleListParameter inputParameter = (DoubleListParameter)objectInput.readObject();
        this.assertEquals(outputParameter.getName(), outputParameter.getLabel(), outputParameter.getDescription(), outputParameter.isOptional(), outputParameter.getCommandLinePattern(), outputParameter.getMaximum(), outputParameter.isMaximumIncluded(), outputParameter.getMinimum(), outputParameter.isMinimumIncluded(), inputParameter);
    }

    private void assertEquals(String name, String label, String description, boolean isOptional, String commandLinePattern, Double maximum, boolean isMaximumIncluded, Double minimum, boolean isMinimumIncluded, DoubleListParameter parameter) {
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)isMaximumIncluded, (Object)parameter.isMaximumIncluded());
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)isMinimumIncluded, (Object)parameter.isMinimumIncluded());
        Assert.assertNull((Object)parameter.getDefaultValue());
    }
}

