/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public final class EnumerationListParameterTest {
    @Test
    public void testEnumerationListParameterWithSingleItem() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String itemId = "ID do item";
        String itemName = "Nome do item";
        String itemValue = "Valor do item";
        String itemDescription = "Descri\u00e7\u00e3o do item";
        EnumerationItem defaultValue = new EnumerationItem(itemId, itemName, itemValue, itemDescription);
        LinkedList<EnumerationItem> defaultItems = new LinkedList<EnumerationItem>();
        defaultItems.add(defaultValue);
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        boolean mustSortItems = true;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(defaultValue);
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, defaultItems, true, true, commandLinePattern, mustSortItems);
        parameter.setItems(items);
        this.assertEquals(name, label, description, defaultItems, commandLinePattern, items, mustSortItems, parameter, null);
    }

    @Test
    public void testEnumerationListParameterWithMultipleItems() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        EnumerationItem item1 = this.createEnumItem("1");
        LinkedList<EnumerationItem> defaultItems = new LinkedList<EnumerationItem>();
        defaultItems.add(item1);
        EnumerationItem item2 = this.createEnumItem("2");
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        boolean mustSortItems = false;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item2);
        items.add(item1);
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, defaultItems, true, true, commandLinePattern, mustSortItems);
        parameter.setItems(items);
        this.assertEquals(name, label, description, defaultItems, commandLinePattern, items, mustSortItems, parameter, null);
    }

    @Test
    public void testEnumerationListParameterWithSorting() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        EnumerationItem item1 = this.createEnumItem("1");
        LinkedList<EnumerationItem> defaultItems = new LinkedList<EnumerationItem>();
        defaultItems.add(item1);
        EnumerationItem item2 = this.createEnumItem("2");
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        boolean mustSortItems = true;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item2);
        items.add(item1);
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, defaultItems, true, true, commandLinePattern, mustSortItems);
        parameter.setItems(items);
        Collections.sort(items);
        this.assertEquals(name, label, description, defaultItems, commandLinePattern, items, mustSortItems, parameter, null);
    }

    @Test
    public void testEnumerationListParameterWithNullDefaultValue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        EnumerationItem item1 = this.createEnumItem("1");
        EnumerationItem item2 = this.createEnumItem("2");
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        boolean mustSortItems = false;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item2);
        items.add(item1);
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, null, true, true, commandLinePattern, mustSortItems);
        parameter.setItems(items);
        this.assertEquals(name, label, description, null, commandLinePattern, items, mustSortItems, parameter, null);
    }

    @Test
    public void testEnumerationListParameterWithNoCommandLinePattern() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        EnumerationItem item1 = this.createEnumItem("1");
        EnumerationItem item2 = this.createEnumItem("2");
        String commandLinePattern = null;
        boolean mustSortItems = false;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item2);
        items.add(item1);
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, null, true, true, commandLinePattern, mustSortItems);
        parameter.setItems(items);
        this.assertEquals(name, label, description, null, commandLinePattern, items, mustSortItems, parameter, null);
    }

    @Test
    public void testEnumerationListParameterWithNullItemCollection() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean mustSortItems = true;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, null, true, true, commandLinePattern, mustSortItems);
        this.assertEquals(name, label, description, null, commandLinePattern, items, mustSortItems, parameter, null);
    }

    @Test
    public void testEnumerationListParameterWithEmptyItemCollection() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean mustSortItems = true;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, null, true, true, commandLinePattern, mustSortItems);
        parameter.setItems(items);
        this.assertEquals(name, label, description, null, commandLinePattern, items, mustSortItems, parameter, null);
    }

    @Test
    public void testSetValueAsTextWithNewItems() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean mustSortItems = false;
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, null, true, true, commandLinePattern, mustSortItems);
        String itemId1 = "Identificador do item 1";
        String itemName1 = "Nome do item 1";
        String itemValue1 = "Valor do item 1";
        String itemDescription1 = "Descri\u00e7\u00e3o do item 1";
        boolean visible1 = true;
        String value1 = "{id=" + itemId1 + "/label=" + itemName1 + "/value=" + itemValue1 + "/description=" + itemDescription1 + "/visible=" + visible1 + "}";
        EnumerationItem item1 = new EnumerationItem(itemId1, itemName1, itemValue1, itemDescription1);
        String itemId2 = "Identificador do item 2";
        String itemName2 = "Nome do item 2";
        String itemValue2 = "Valor do item 2";
        String itemDescription2 = "Descri\u00e7\u00e3o do item 2";
        boolean visible2 = false;
        String value2 = "{id=" + itemId2 + "/label=" + itemName2 + "/value=" + itemValue2 + "/description=" + itemDescription2 + "/visible=" + visible2 + "}";
        EnumerationItem item2 = new EnumerationItem(itemId2, itemName2, itemValue2, itemDescription2);
        String value = "{" + value1 + "," + value2 + "}:{" + itemName2 + "}";
        parameter.setValueAsText(value);
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item1);
        items.add(item2);
        LinkedList<EnumerationItem> selectedItems = new LinkedList<EnumerationItem>();
        selectedItems.add(item2);
        this.assertEquals(name, label, description, null, commandLinePattern, items, mustSortItems, parameter, selectedItems);
    }

    @Test
    public void testSetValueAsTextWithSelectedItem() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean mustSortItems = false;
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, null, true, true, commandLinePattern, mustSortItems);
        EnumerationItem item1 = this.createEnumItem("1");
        EnumerationItem item2 = this.createEnumItem("2");
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item1);
        items.add(item2);
        LinkedList<EnumerationItem> selectedItems = new LinkedList<EnumerationItem>();
        selectedItems.add(item2);
        parameter.setItems(items);
        parameter.setValueAsText("{" + item2.getLabel() + "}");
        this.assertEquals(name, label, description, null, commandLinePattern, items, mustSortItems, parameter, selectedItems);
    }

    @Test
    public void testSetValueAsTextWithSelectedItems() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean mustSortItems = false;
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, null, true, true, commandLinePattern, mustSortItems);
        EnumerationItem item1 = this.createEnumItem("1");
        EnumerationItem item2 = this.createEnumItem("2");
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item1);
        items.add(item2);
        LinkedList<EnumerationItem> selectedItems = new LinkedList<EnumerationItem>();
        selectedItems.add(item1);
        selectedItems.add(item2);
        parameter.setItems(items);
        parameter.setValueAsText("{" + item1.getLabel() + "," + item2.getLabel() + "}");
        this.assertEquals(name, label, description, null, commandLinePattern, items, mustSortItems, parameter, selectedItems);
    }

    @Test(expected=ParseException.class)
    public void testSetValueAsTextWithInvalidItem() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean mustSortItems = false;
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, null, true, true, commandLinePattern, mustSortItems);
        EnumerationItem item1 = this.createEnumItem("1");
        EnumerationItem item2 = this.createEnumItem("2");
        parameter.setValueAsText("{itemName2, itemName3}");
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item1);
        items.add(item2);
        LinkedList<EnumerationItem> selectedItems = new LinkedList<EnumerationItem>();
        selectedItems.add(item2);
    }

    @Test
    public void testSetValueWithMultipleItems() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        EnumerationItem item1 = this.createEnumItem("1");
        EnumerationItem item2 = this.createEnumItem("2");
        EnumerationItem item3 = this.createEnumItem("3");
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        boolean mustSortItems = false;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item2);
        items.add(item1);
        items.add(item3);
        List defaultValues = null;
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, defaultValues, true, true, commandLinePattern, mustSortItems);
        parameter.setItems(items);
        LinkedList<EnumerationItem> value = new LinkedList<EnumerationItem>();
        value.add(item3);
        value.add(item2);
        value.add(item1);
        parameter.setValue(value);
        this.assertEquals(name, label, description, defaultValues, commandLinePattern, items, mustSortItems, parameter, value);
    }

    @Test
    public void testSetValueWithSorting() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        EnumerationItem item1 = this.createEnumItem("1");
        EnumerationItem item2 = this.createEnumItem("2");
        EnumerationItem item3 = this.createEnumItem("3");
        EnumerationItem item4 = this.createEnumItem("4");
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        boolean mustSortItems = true;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item4);
        items.add(item2);
        items.add(item1);
        items.add(item3);
        LinkedList<EnumerationItem> sortedItems = new LinkedList<EnumerationItem>();
        sortedItems.add(item1);
        sortedItems.add(item2);
        sortedItems.add(item3);
        sortedItems.add(item4);
        List defaultValues = null;
        EnumerationListParameter parameter = new EnumerationListParameter(name, label, description, defaultValues, true, true, commandLinePattern, mustSortItems);
        parameter.setItems(items);
        LinkedList<EnumerationItem> value = new LinkedList<EnumerationItem>();
        value.add(item3);
        value.add(item2);
        value.add(item1);
        parameter.setValue(value);
        LinkedList<EnumerationItem> sortedValue = new LinkedList<EnumerationItem>();
        sortedValue.add(item1);
        sortedValue.add(item2);
        sortedValue.add(item3);
        this.assertEquals(name, label, description, defaultValues, commandLinePattern, sortedItems, mustSortItems, parameter, sortedValue);
    }

    private EnumerationItem createEnumItem(String suffix) {
        String itemId = "Identificador do item " + suffix;
        String itemName = "Nome do item " + suffix;
        String itemValue = "Valor do item " + suffix;
        String itemDescription = "Descri\u00e7\u00e3o do item " + suffix;
        return new EnumerationItem(itemId, itemName, itemValue, itemDescription);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumerationListParameterWihtNullName() {
        String name = null;
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean mustSortItems = true;
        new EnumerationListParameter(name, label, description, null, true, true, commandLinePattern, mustSortItems);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumerationListParameterWithNullLabel() {
        String name = "Nome do par\u00e2metro";
        String label = null;
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean mustSortItems = true;
        new EnumerationListParameter(name, label, description, null, true, true, commandLinePattern, mustSortItems);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumerationListParameterWithNullDescription() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = null;
        String commandLinePattern = null;
        boolean mustSortItems = true;
        new EnumerationListParameter(name, label, description, null, true, true, commandLinePattern, mustSortItems);
    }

    private void assertEquals(String name, String label, String description, List<EnumerationItem> defaultValues, String commandLinePattern, List<EnumerationItem> items, boolean mustSortItems, EnumerationListParameter parameter, List<EnumerationItem> selectedItems) {
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals(defaultValues, (Object)parameter.getDefaultValue());
        Assert.assertTrue((boolean)parameter.isOptional());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertEquals(items, (Object)parameter.getItems());
        Assert.assertEquals((Object)mustSortItems, (Object)parameter.mustSortItems());
        List value = (List)parameter.getValue();
        Assert.assertEquals(selectedItems, (Object)value);
    }
}

