/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.CheckListExpressionFunction;
import csbase.logic.algorithms.parameters.MockListExpressionFunction;
import csbase.logic.algorithms.parameters.MockListParameter;
import csbase.logic.algorithms.parameters.MockSimpleParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public final class ListExpressionFunctionTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testListExpressionFunction1() {
        String name = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Integer.class, Double.class};
        Class[] expectedParameterTypes = new Class[]{String.class, Integer.class, Double.class};
        MockListExpressionFunction function = new MockListExpressionFunction(name, parameterTypes);
        Assert.assertEquals((Object)name, (Object)function.getName());
        List parameterTypeList = function.getParameterTypes();
        this.assertParameterTypes(expectedParameterTypes, parameterTypeList);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testListExpressionFunction2() {
        Class[] parameterTypes = new Class[]{String.class, Object.class};
        new MockListExpressionFunction(null, parameterTypes);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testListExpressionFunction3() {
        String name = "Nome da fun\u00e7\u00e3o";
        new MockListExpressionFunction(name, null);
    }

    @Test
    public void testAcceptParameters4() {
        String name = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Integer.class, Double.class};
        MockListExpressionFunction function = new MockListExpressionFunction(name, parameterTypes);
        Object[] parameters = new Object[]{"Nome da lista", 1, 2.0};
        Assert.assertTrue((boolean)function.acceptParameters(parameters));
    }

    @Test
    public void testAcceptParameters5() {
        String name = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Integer.class, Double.class};
        MockListExpressionFunction function = new MockListExpressionFunction(name, parameterTypes);
        Object[] parameters = new Object[]{1, 2.0};
        Assert.assertFalse((boolean)function.acceptParameters(parameters));
    }

    @Test
    public void testDoOperation1() throws ExpressionFunctionExecutionException {
        String name = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Integer.class, Double.class};
        CheckListExpressionFunction function = new CheckListExpressionFunction(name, parameterTypes);
        Object[] parameters = new Object[]{1, 2.0};
        LinkedList<Object> parameterList = new LinkedList<Object>();
        for (Object parameter : parameters) {
            parameterList.add(parameter);
        }
        String result = "Resultado";
        function.setExpected(parameterList, parameters, result);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        MockListParameter parameter = new MockListParameter(parameterName, parameterLabel, parameterDescription, false, true, false, true, "{0}={1}");
        parameter.setValue(parameterList);
        ParameterGroup group = new ParameterGroup("Grupo");
        group.addParameter((Parameter)parameter);
        SimpleAlgorithmConfigurator configurator = this.createConfigurator();
        configurator.addGroup(group);
        Assert.assertEquals((Object)result, (Object)function.doOperation(configurator, new Object[]{parameterName, 1, 2.0}));
        Assert.assertTrue((boolean)function.wasDoneOperation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ExpressionFunctionExecutionException.class)
    public void testDoOperation2() throws ExpressionFunctionExecutionException {
        Object parameter2;
        String name = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Integer.class, Double.class};
        CheckListExpressionFunction function = new CheckListExpressionFunction(name, parameterTypes);
        Object[] parameters = new Object[]{1, 2.0};
        LinkedList<Object> parameterList = new LinkedList<Object>();
        for (Object parameter2 : parameters) {
            parameterList.add(parameter2);
        }
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        parameter2 = new MockListParameter(parameterName, parameterLabel, parameterDescription, false, true, false, true, "{0}={1}");
        parameter2.setValue(parameterList);
        ParameterGroup group = new ParameterGroup("Grupo");
        group.addParameter((Parameter)parameter2);
        SimpleAlgorithmConfigurator configurator = this.createConfigurator();
        configurator.addGroup(group);
        try {
            function.doOperation(configurator, new Object[]{"Nome de fun\u00e7\u00e3o que n\u00e3o existe", 1, 2.0});
        }
        finally {
            Assert.assertFalse((boolean)function.wasDoneOperation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ExpressionFunctionExecutionException.class)
    public void testDoOperation3() throws ExpressionFunctionExecutionException {
        Object parameter2;
        String name = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Integer.class, Double.class};
        CheckListExpressionFunction function = new CheckListExpressionFunction(name, parameterTypes);
        Object[] parameters = new Object[]{1, 2.0};
        LinkedList<Object> parameterList = new LinkedList<Object>();
        for (Object parameter2 : parameters) {
            parameterList.add(parameter2);
        }
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        parameter2 = new MockSimpleParameter(parameterName, parameterLabel, parameterDescription, null, false, true, "{0}{1}");
        parameter2.setValue(parameterList);
        ParameterGroup group = new ParameterGroup("Grupo");
        group.addParameter((Parameter)parameter2);
        SimpleAlgorithmConfigurator configurator = this.createConfigurator();
        configurator.addGroup(group);
        try {
            function.doOperation(configurator, new Object[]{parameterName, 1, 2.0});
        }
        finally {
            Assert.assertFalse((boolean)function.wasDoneOperation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testDoOperation4() throws ExpressionFunctionExecutionException {
        String name = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Integer.class, Double.class};
        CheckListExpressionFunction function = new CheckListExpressionFunction(name, parameterTypes);
        Object[] parameters = new Object[]{1, 2.0};
        LinkedList<Object> parameterList = new LinkedList<Object>();
        for (Object parameter : parameters) {
            parameterList.add(parameter);
        }
        String parameterName = "Nome do par\u00e2metro";
        try {
            function.doOperation(null, new Object[]{parameterName, 1, 2.0});
        }
        finally {
            Assert.assertFalse((boolean)function.wasDoneOperation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ExpressionFunctionExecutionException.class)
    public void testDoOperation5() throws ExpressionFunctionExecutionException {
        Object parameter2;
        String name = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Integer.class, Double.class};
        CheckListExpressionFunction function = new CheckListExpressionFunction(name, parameterTypes);
        Object[] parameters = new Object[]{1, 2.0};
        LinkedList<Object> parameterList = new LinkedList<Object>();
        for (Object parameter2 : parameters) {
            parameterList.add(parameter2);
        }
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        parameter2 = new MockListParameter(parameterName, parameterLabel, parameterDescription, false, true, false, true, "{0}={1}");
        parameter2.setValue(parameterList);
        ParameterGroup group = new ParameterGroup("Grupo");
        group.addParameter((Parameter)parameter2);
        SimpleAlgorithmConfigurator configurator = this.createConfigurator();
        configurator.addGroup(group);
        try {
            function.doOperation(configurator, new Object[]{null, 1, 2.0});
        }
        finally {
            Assert.assertFalse((boolean)function.wasDoneOperation());
        }
    }

    private SimpleAlgorithmConfigurator createConfigurator() {
        String algorithmId = "Identificador do algoritmo";
        String algorithmName = "Nome do algoritmo";
        String algorithmDirectory = "Diret\u00f3rio do algoritmo";
        AlgorithmInfo algorithmInfo = new AlgorithmInfo(algorithmId, algorithmName, algorithmDirectory, "algorithms", new Hashtable(), new Hashtable());
        AlgorithmVersionInfo versionInfo = new AlgorithmVersionInfo(algorithmInfo, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(versionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        return configurator;
    }

    private void assertParameterTypes(Class<?>[] expectedParameterTypes, List<Class<?>> foundParameterTypes) {
        Iterator<Class<?>> parameterTypeIterator = foundParameterTypes.iterator();
        for (Class<?> parameterType : expectedParameterTypes) {
            Assert.assertEquals(parameterTypeIterator.next(), parameterType);
        }
    }
}

